/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.ByteUtils;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.IntegerOverflowException;

public class AAD {
    public static byte[] compute(JWEHeader jweHeader) {
        return AAD.compute(jweHeader.toBase64URL());
    }

    public static byte[] compute(Base64URL encodedJWEHeader) {
        return encodedJWEHeader.toString().getBytes(Charset.forName("ASCII"));
    }

    public static byte[] computeLength(byte[] aad) throws IntegerOverflowException {
        int bitLength = ByteUtils.safeBitLength(aad);
        return ByteBuffer.allocate(8).putLong(bitLength).array();
    }
}

