/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.kfs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Progressable;
import org.kosmix.kosmosfs.access.KfsAccess;
import org.kosmix.kosmosfs.access.KfsOutputChannel;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class KFSOutputStream
extends OutputStream {
    private String path;
    private KfsOutputChannel kfsChannel;
    private Progressable progressReporter;

    public KFSOutputStream(KfsAccess kfsAccess, String path, short replication, boolean append, Progressable prog) {
        this.path = path;
        this.kfsChannel = append && kfsAccess.kfs_isFile(path) ? kfsAccess.kfs_append(path) : kfsAccess.kfs_create(path, (int)replication);
        this.progressReporter = prog;
    }

    public long getPos() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        return this.kfsChannel.tell();
    }

    @Override
    public void write(int v) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        byte[] b = new byte[]{(byte)v};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        this.progressReporter.progress();
        this.kfsChannel.write(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public void flush() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        this.progressReporter.progress();
        this.kfsChannel.sync();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.kfsChannel == null) {
            return;
        }
        this.flush();
        this.kfsChannel.close();
        this.kfsChannel = null;
    }
}

