/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public abstract class AbstractDelegationTokenSecretManager<TokenIdent extends AbstractDelegationTokenIdentifier>
extends SecretManager<TokenIdent> {
    private static final Log LOG = LogFactory.getLog(AbstractDelegationTokenSecretManager.class);
    protected final Map<TokenIdent, DelegationTokenInformation> currentTokens = new HashMap<TokenIdent, DelegationTokenInformation>();
    protected int delegationTokenSequenceNumber = 0;
    protected final Map<Integer, DelegationKey> allKeys = new HashMap<Integer, DelegationKey>();
    protected int currentId = 0;
    private DelegationKey currentKey;
    private long keyUpdateInterval;
    private long tokenMaxLifetime;
    private long tokenRemoverScanInterval;
    private long tokenRenewInterval;
    private Thread tokenRemoverThread;
    protected volatile boolean running;

    public AbstractDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
        this.keyUpdateInterval = delegationKeyUpdateInterval;
        this.tokenMaxLifetime = delegationTokenMaxLifetime;
        this.tokenRenewInterval = delegationTokenRenewInterval;
        this.tokenRemoverScanInterval = delegationTokenRemoverScanInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThreads() throws IOException {
        this.updateCurrentKey();
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager = this;
        synchronized (abstractDelegationTokenSecretManager) {
            this.running = true;
            this.tokenRemoverThread = new Daemon(new ExpiredTokenRemover());
            this.tokenRemoverThread.start();
        }
    }

    public synchronized void reset() {
        this.currentId = 0;
        this.allKeys.clear();
        this.delegationTokenSequenceNumber = 0;
        this.currentTokens.clear();
    }

    public synchronized void addKey(DelegationKey key) throws IOException {
        if (this.running) {
            throw new IOException("Can't add delegation key to a running SecretManager.");
        }
        if (key.getKeyId() > this.currentId) {
            this.currentId = key.getKeyId();
        }
        this.allKeys.put(key.getKeyId(), key);
    }

    public synchronized DelegationKey[] getAllKeys() {
        return this.allKeys.values().toArray(new DelegationKey[0]);
    }

    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentKey() throws IOException {
        int newCurrentId;
        LOG.info((Object)"Updating the current master key for generating delegation tokens");
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager = this;
        synchronized (abstractDelegationTokenSecretManager) {
            newCurrentId = this.currentId + 1;
        }
        DelegationKey newKey = new DelegationKey(newCurrentId, System.currentTimeMillis() + this.keyUpdateInterval + this.tokenMaxLifetime, this.generateSecret());
        this.logUpdateMasterKey(newKey);
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager2 = this;
        synchronized (abstractDelegationTokenSecretManager2) {
            this.currentId = newKey.getKeyId();
            this.currentKey = newKey;
            this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollMasterKey() throws IOException {
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager = this;
        synchronized (abstractDelegationTokenSecretManager) {
            this.removeExpiredKeys();
            this.currentKey.setExpiryDate(System.currentTimeMillis() + this.tokenMaxLifetime);
            this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        }
        this.updateCurrentKey();
    }

    private synchronized void removeExpiredKeys() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<Integer, DelegationKey>> it = this.allKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, DelegationKey> e = it.next();
            if (e.getValue().getExpiryDate() >= now) continue;
            it.remove();
        }
    }

    @Override
    protected synchronized byte[] createPassword(TokenIdent identifier) {
        long now = System.currentTimeMillis();
        int sequenceNum = ++this.delegationTokenSequenceNumber;
        ((AbstractDelegationTokenIdentifier)identifier).setIssueDate(now);
        ((AbstractDelegationTokenIdentifier)identifier).setMaxDate(now + this.tokenMaxLifetime);
        ((AbstractDelegationTokenIdentifier)identifier).setMasterKeyId(this.currentId);
        ((AbstractDelegationTokenIdentifier)identifier).setSequenceNumber(sequenceNum);
        LOG.info((Object)("Creating password for identifier: " + identifier));
        byte[] password = AbstractDelegationTokenSecretManager.createPassword(((TokenIdentifier)identifier).getBytes(), this.currentKey.getKey());
        this.currentTokens.put(identifier, new DelegationTokenInformation(now + this.tokenRenewInterval, password));
        return password;
    }

    @Override
    public synchronized byte[] retrievePassword(TokenIdent identifier) throws SecretManager.InvalidToken {
        DelegationTokenInformation info = this.currentTokens.get(identifier);
        if (info == null) {
            throw new SecretManager.InvalidToken("token (" + ((AbstractDelegationTokenIdentifier)identifier).toString() + ") can't be found in cache");
        }
        long now = System.currentTimeMillis();
        if (info.getRenewDate() < now) {
            throw new SecretManager.InvalidToken("token (" + ((AbstractDelegationTokenIdentifier)identifier).toString() + ") is expired");
        }
        return info.getPassword();
    }

    public synchronized void verifyToken(TokenIdent identifier, byte[] password) throws SecretManager.InvalidToken {
        byte[] storedPassword = this.retrievePassword(identifier);
        if (!Arrays.equals(password, storedPassword)) {
            throw new SecretManager.InvalidToken("token (" + identifier + ") is invalid, password doesn't match");
        }
    }

    public synchronized long renewToken(Token<TokenIdent> token, String renewer) throws SecretManager.InvalidToken, IOException {
        long now = System.currentTimeMillis();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
        id.readFields(in);
        LOG.info((Object)("Token renewal requested for identifier: " + id));
        if (id.getMaxDate() < now) {
            throw new SecretManager.InvalidToken("User " + renewer + " tried to renew an expired token");
        }
        if (id.getRenewer() == null || "".equals(id.getRenewer().toString())) {
            throw new AccessControlException("User " + renewer + " tried to renew a token without " + "a renewer");
        }
        if (!id.getRenewer().toString().equals(renewer)) {
            throw new AccessControlException("Client " + renewer + " tries to renew a token with " + "renewer specified as " + id.getRenewer());
        }
        DelegationKey key = this.allKeys.get(id.getMasterKeyId());
        if (key == null) {
            throw new SecretManager.InvalidToken("Unable to find master key for keyId=" + id.getMasterKeyId() + " from cache. Failed to renew an unexpired token" + " with sequenceNumber=" + id.getSequenceNumber());
        }
        byte[] password = AbstractDelegationTokenSecretManager.createPassword(token.getIdentifier(), key.getKey());
        if (!Arrays.equals(password, token.getPassword())) {
            throw new AccessControlException("Client " + renewer + " is trying to renew a token with " + "wrong password");
        }
        long renewTime = Math.min(id.getMaxDate(), now + this.tokenRenewInterval);
        DelegationTokenInformation info = new DelegationTokenInformation(renewTime, password);
        if (this.currentTokens.get(id) == null) {
            throw new SecretManager.InvalidToken("Renewal request for unknown token");
        }
        this.currentTokens.put(id, info);
        return renewTime;
    }

    public synchronized TokenIdent cancelToken(Token<TokenIdent> token, String canceller) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
        id.readFields(in);
        LOG.info((Object)("Token cancelation requested for identifier: " + id));
        if (id.getUser() == null) {
            throw new SecretManager.InvalidToken("Token with no owner");
        }
        String owner = id.getUser().getUserName();
        Text renewer = id.getRenewer();
        HadoopKerberosName cancelerKrbName = new HadoopKerberosName(canceller);
        String cancelerShortName = cancelerKrbName.getShortName();
        if (!(canceller.equals(owner) || renewer != null && !"".equals(renewer.toString()) && cancelerShortName.equals(renewer.toString()))) {
            throw new AccessControlException(canceller + " is not authorized to cancel the token");
        }
        DelegationTokenInformation info = null;
        info = this.currentTokens.remove(id);
        if (info == null) {
            throw new SecretManager.InvalidToken("Token not found");
        }
        return (TokenIdent)id;
    }

    public static SecretKey createSecretKey(byte[] key) {
        return SecretManager.createSecretKey(key);
    }

    private synchronized void removeExpiredToken() {
        long now = System.currentTimeMillis();
        Iterator<DelegationTokenInformation> i = this.currentTokens.values().iterator();
        while (i.hasNext()) {
            long renewDate = i.next().getRenewDate();
            if (now <= renewDate) continue;
            i.remove();
        }
    }

    public synchronized void stopThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping expired delegation token remover thread");
        }
        this.running = false;
        if (this.tokenRemoverThread != null) {
            this.tokenRemoverThread.interrupt();
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private class ExpiredTokenRemover
    extends Thread {
        private long lastMasterKeyUpdate;
        private long lastTokenCacheCleanup;

        private ExpiredTokenRemover() {
        }

        @Override
        public void run() {
            LOG.info((Object)("Starting expired delegation token remover thread, tokenRemoverScanInterval=" + AbstractDelegationTokenSecretManager.this.tokenRemoverScanInterval / 60000L + " min(s)"));
            block6: while (true) {
                try {
                    while (AbstractDelegationTokenSecretManager.this.running) {
                        long now = System.currentTimeMillis();
                        if (this.lastMasterKeyUpdate + AbstractDelegationTokenSecretManager.this.keyUpdateInterval < now) {
                            try {
                                AbstractDelegationTokenSecretManager.this.rollMasterKey();
                                this.lastMasterKeyUpdate = now;
                            }
                            catch (IOException e) {
                                LOG.error((Object)"Master key updating failed: ", (Throwable)e);
                            }
                        }
                        if (this.lastTokenCacheCleanup + AbstractDelegationTokenSecretManager.this.tokenRemoverScanInterval < now) {
                            AbstractDelegationTokenSecretManager.this.removeExpiredToken();
                            this.lastTokenCacheCleanup = now;
                        }
                        try {
                            Thread.sleep(5000L);
                            continue block6;
                        }
                        catch (InterruptedException ie) {
                            LOG.error((Object)("InterruptedExcpetion recieved for ExpiredTokenRemover thread " + ie));
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    LOG.error((Object)("ExpiredTokenRemover thread received unexpected exception. " + t));
                    Runtime.getRuntime().exit(-1);
                    break;
                }
            }
        }
    }

    @InterfaceStability.Evolving
    public static class DelegationTokenInformation {
        long renewDate;
        byte[] password;

        public DelegationTokenInformation(long renewDate, byte[] password) {
            this.renewDate = renewDate;
            this.password = password;
        }

        public long getRenewDate() {
            return this.renewDate;
        }

        byte[] getPassword() {
            return this.password;
        }
    }
}

