/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Ls
extends FsCommand {
    public static final String NAME = "ls";
    public static final String USAGE = "[-d] [-h] [-R] [<path> ...]";
    public static final String DESCRIPTION = "List the contents that match the specified file pattern. If\npath is not specified, the contents of /user/<currentUser>\nwill be listed. Directory entries are of the form \n\tpermissions - userid groupid size_of_directory(in bytes) modification_date(yyyy-MM-dd HH:mm) directoryName \nand file entries are of the form \n\tpermissions number_of_replicas userid groupid size_of_file(in bytes) modification_date(yyyy-MM-dd HH:mm) fileName \n  -d  Directories are listed as plain files.\n  -h  Formats the sizes of files in a human-readable fashion\n      rather than a number of bytes.\n  -R  Recursively list the contents of directories.";
    protected static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected int maxRepl = 3;
    protected int maxLen = 10;
    protected int maxOwner = 0;
    protected int maxGroup = 0;
    protected String lineFormat;
    protected boolean dirRecurse;
    protected boolean humanReadable = false;
    private Set<URI> aclNotSupportedFsSet = Sets.newHashSet();

    Ls() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Ls.class, "-ls");
        factory.addClass(Lsr.class, "-lsr");
    }

    protected String formatSize(long size) {
        return this.humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "d", "h", "R");
        cf.parse(args);
        this.dirRecurse = !cf.getOpt("d");
        this.setRecursive(cf.getOpt("R") && this.dirRecurse);
        this.humanReadable = cf.getOpt("h");
        if (args.isEmpty()) {
            args.add(".");
        }
    }

    @Override
    protected void processPathArgument(PathData item) throws IOException {
        if (this.dirRecurse && item.stat.isDirectory()) {
            this.recursePath(item);
        } else {
            super.processPathArgument(item);
        }
    }

    @Override
    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        if (parent != null && !this.isRecursive() && items.length != 0) {
            this.out.println("Found " + items.length + " items");
        }
        this.adjustColumnWidths(items);
        super.processPaths(parent, items);
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        FileStatus stat = item.stat;
        String line = String.format(this.lineFormat, stat.isDirectory() ? "d" : "-", stat.getPermission() + (this.hasAcl(item) ? "+" : " "), stat.isFile() ? Short.valueOf(stat.getReplication()) : "-", stat.getOwner(), stat.getGroup(), this.formatSize(stat.getLen()), dateFormat.format(new Date(stat.getModificationTime())), item);
        this.out.println(line);
    }

    private void adjustColumnWidths(PathData[] items) {
        for (PathData item : items) {
            FileStatus stat = item.stat;
            this.maxRepl = this.maxLength(this.maxRepl, stat.getReplication());
            this.maxLen = this.maxLength(this.maxLen, stat.getLen());
            this.maxOwner = this.maxLength(this.maxOwner, stat.getOwner());
            this.maxGroup = this.maxLength(this.maxGroup, stat.getGroup());
        }
        StringBuilder fmt = new StringBuilder();
        fmt.append("%s%s");
        fmt.append("%" + this.maxRepl + "s ");
        fmt.append(this.maxOwner > 0 ? "%-" + this.maxOwner + "s " : "%s");
        fmt.append(this.maxGroup > 0 ? "%-" + this.maxGroup + "s " : "%s");
        fmt.append("%" + this.maxLen + "s ");
        fmt.append("%s %s");
        this.lineFormat = fmt.toString();
    }

    private boolean hasAcl(PathData item) throws IOException {
        FileSystem fs = item.fs;
        if (this.aclNotSupportedFsSet.contains(fs.getUri())) {
            return false;
        }
        try {
            return !fs.getAclStatus(item.path).getEntries().isEmpty();
        }
        catch (RemoteException e) {
            IOException e2 = e.unwrapRemoteException(RpcNoSuchMethodException.class);
            if (!(e2 instanceof RpcNoSuchMethodException)) {
                throw e;
            }
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && !message.contains("ACLs has been disabled")) {
                throw e;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.aclNotSupportedFsSet.add(fs.getUri());
        return false;
    }

    private int maxLength(int n, Object value) {
        return Math.max(n, value != null ? String.valueOf(value).length() : 0);
    }

    public static class Lsr
    extends Ls {
        public static final String NAME = "lsr";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-R");
            super.processOptions(args);
        }

        @Override
        public String getReplacementCommand() {
            return "ls -R";
        }
    }
}

