/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ClientCache;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcInvocationHandler;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;

public class FailoverRPC {
    private static final Log LOG = LogFactory.getLog(FailoverRPC.class);
    private static ClientCache CLIENTS = new ClientCache();
    public static final long writableRpcVersion = 2L;

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, FileSystem fs, Configuration conf) throws IOException {
        return FailoverRPC.getProxy(protocol, clientVersion, fs, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, FileSystem fs, Configuration conf, SocketFactory factory) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return FailoverRPC.getProxy(protocol, clientVersion, fs, ugi, conf, factory);
    }

    public static VersionedProtocol getProxy(Class<?> protocol, long clientVersion, FileSystem fs, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            SaslRpcServer.init(conf);
        }
        FailoverInvoker failoverInvoker = new FailoverInvoker(protocol, clientVersion, fs, ticket, conf, factory);
        VersionedProtocol proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)failoverInvoker);
        return proxy;
    }

    private static class FailoverInvoker
    implements InvocationHandler,
    Closeable {
        private InetSocketAddress[] addresses;
        private UserGroupInformation ticket;
        private Client client;
        private boolean isClosed = false;
        private Configuration conf;
        Class<?> protocol;
        long clientVersion;
        SocketFactory factory;
        int activeServer;
        int lastActiveServer;
        int totalServers;
        FileSystem fs = null;
        boolean usefs = false;
        private boolean firstAttempt = true;
        private int maxFirstTimeAttempts = 20;

        public FailoverInvoker(Class<?> protocol, long clientVersion, FileSystem fs, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
            this.protocol = protocol;
            this.clientVersion = clientVersion;
            this.ticket = ticket;
            this.client = CLIENTS.getClient(conf, factory);
            this.conf = conf;
            this.factory = factory;
            this.activeServer = 0;
            this.lastActiveServer = 0;
            this.fs = fs != null ? fs : FileSystem.get(conf);
            this.addresses = null;
            this.totalServers = 0;
            this.usefs = true;
            this.maxFirstTimeAttempts = conf.getInt("ipc.client.max.connection.setup.timeout", 20);
            this.maxFirstTimeAttempts = this.maxFirstTimeAttempts <= 1 ? 10 : (this.maxFirstTimeAttempts == 2 ? 15 : 2 * (this.maxFirstTimeAttempts - 2) + 15);
        }

        public synchronized void searchActiverServer() throws IOException {
            boolean logInfo = LOG.isInfoEnabled();
            if (logInfo) {
                LOG.info((Object)"Searching for the Active Server ...");
            }
            boolean found = false;
            long attempts = 1L;
            while (!found) {
                Object quickProxy;
                Invoker quickInvoker;
                block17: {
                    if (logInfo) {
                        LOG.info((Object)("Attempt# " + attempts + " . Trying to connect Server at " + this.addresses[this.activeServer]));
                    }
                    int maxIdleTime = this.conf.getInt("ipc.client.connection.maxidletime", 10000);
                    int maxRetries = this.conf.getInt("ipc.client.connect.max.retries", 10);
                    this.conf.setInt("ipc.client.connection.maxidletime", 10);
                    this.conf.setInt("ipc.client.connect.max.retries", 1);
                    quickInvoker = new Invoker(this.protocol, this.addresses[this.activeServer], this.ticket, this.conf, this.factory, 0);
                    this.conf.setInt("ipc.client.connection.maxidletime", maxIdleTime);
                    this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
                    quickProxy = Proxy.newProxyInstance(this.protocol.getClassLoader(), new Class[]{this.protocol}, (InvocationHandler)quickInvoker);
                    if (quickProxy instanceof VersionedProtocol) {
                        try {
                            long serverVersion = ((VersionedProtocol)quickProxy).getProtocolVersion(this.protocol.getName(), this.clientVersion);
                            if (serverVersion != this.clientVersion) {
                                LOG.warn((Object)"Version mistmatch while searching for the Active Server");
                                break block17;
                            }
                            found = true;
                        }
                        catch (IOException e) {
                            LOG.warn((Object)("Error connecting server at " + this.addresses[this.activeServer] + " " + e));
                        }
                    } else {
                        LOG.error((Object)"Not a versioned protocol?");
                    }
                }
                quickInvoker.close();
                quickProxy = null;
                quickInvoker = null;
                if (found) continue;
                this.activeServer = (this.activeServer + 1) % this.totalServers;
                if (this.activeServer != this.lastActiveServer) continue;
                if (logInfo) {
                    LOG.info((Object)"Tried all servers sleeping");
                }
                try {
                    if (attempts * 2L > 30L) {
                        Thread.currentThread();
                        Thread.sleep(30000L);
                    } else {
                        Thread.currentThread();
                        Thread.sleep(attempts * 2L * 1000L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.firstAttempt && attempts >= (long)this.maxFirstTimeAttempts) {
                    throw new IOException("Failed to establish initial contact with all servers. mapred.job.tracker = " + this.conf.get("mapred.job.tracker", "maprdummy"));
                }
                ++attempts;
                if (!this.usefs) continue;
                try {
                    this.addresses = this.fs.getJobTrackerAddrs(this.conf);
                    this.totalServers = this.addresses.length;
                    this.activeServer = 0;
                    this.lastActiveServer = 0;
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Error while fetching JobTracker location " + ioe));
                    throw ioe;
                }
            }
            this.firstAttempt = false;
            this.lastActiveServer = this.activeServer;
            if (logInfo) {
                LOG.info((Object)("New Active server found on " + this.addresses[this.activeServer]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean done = false;
            ObjectWritable value = null;
            boolean logDebug = LOG.isDebugEnabled();
            boolean logInfo = LOG.isInfoEnabled();
            long startTime = 0L;
            if (logDebug) {
                startTime = System.currentTimeMillis();
            }
            if (this.usefs && this.addresses == null) {
                FailoverInvoker failoverInvoker = this;
                synchronized (failoverInvoker) {
                    try {
                        this.addresses = this.fs.getJobTrackerAddrs(this.conf);
                        this.totalServers = this.addresses.length;
                        this.activeServer = 0;
                        this.lastActiveServer = 0;
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)("FailoverProxy: Failing this Call: " + method.getName() + ". Error while fetching JobTracker location " + ioe));
                        throw ioe;
                    }
                }
            }
            while (!done) {
                try {
                    value = (ObjectWritable)this.client.call(RPC.RpcKind.RPC_WRITABLE, new Invocation(method, args), this.addresses[this.activeServer], this.protocol, this.ticket, 0, this.conf);
                    done = true;
                    this.firstAttempt = false;
                }
                catch (IOException exception) {
                    Throwable cause = exception.getCause();
                    if (exception instanceof SocketTimeoutException || exception instanceof EOFException || exception instanceof SocketException || exception instanceof ConnectException || cause instanceof SocketTimeoutException || cause instanceof EOFException || cause instanceof SocketException || cause instanceof ConnectException || cause != null && cause.getMessage() != null && cause.getMessage().equals("Connection reset by peer")) {
                        if (logInfo) {
                            LOG.info((Object)("FailoverProxy: Server on " + this.addresses[this.activeServer] + " is lost due to " + exception + " in call " + method.getName()));
                        }
                        this.searchActiverServer();
                        continue;
                    }
                    LOG.error((Object)("FailoverProxy: Failing this Call: " + method.getName() + " for error(RemoteException): " + exception));
                    throw exception;
                }
            }
            if (logDebug) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            return value.get();
        }

        @Override
        public synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class Invoker
    implements RpcInvocationHandler,
    Closeable {
        private Client.ConnectionId remoteId;
        private Client client;
        private boolean isClosed = false;

        public Invoker(Class<?> protocol, InetSocketAddress address, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
            this.remoteId = Client.ConnectionId.getConnectionId(address, protocol, ticket, rpcTimeout, conf);
            this.client = CLIENTS.getClient(conf, factory);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long startTime = 0L;
            if (LOG.isDebugEnabled()) {
                startTime = Time.now();
            }
            ObjectWritable value = (ObjectWritable)this.client.call(RPC.RpcKind.RPC_WRITABLE, (Writable)new Invocation(method, args), this.remoteId);
            if (LOG.isDebugEnabled()) {
                long callTime = Time.now() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            return value.get();
        }

        @Override
        public synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }

        @Override
        public Client.ConnectionId getConnectionId() {
            return this.remoteId;
        }
    }

    private static class Invocation
    implements Writable,
    Configurable {
        private String methodName;
        private Class<?>[] parameterClasses;
        private Object[] parameters;
        private Configuration conf;
        private long clientVersion;
        private int clientMethodsHash;
        private String declaringClassProtocolName;
        private long rpcVersion;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
            this.rpcVersion = 2L;
            if (method.getDeclaringClass().equals(VersionedProtocol.class)) {
                this.clientVersion = 0L;
                this.clientMethodsHash = 0;
            } else {
                this.clientVersion = RPC.getProtocolVersion(method.getDeclaringClass());
                this.clientMethodsHash = ProtocolSignature.getFingerprint(method.getDeclaringClass().getMethods());
            }
            this.declaringClassProtocolName = RPC.getProtocolName(method.getDeclaringClass());
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterClasses() {
            return this.parameterClasses;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        private long getProtocolVersion() {
            return this.clientVersion;
        }

        private int getClientMethodsHash() {
            return this.clientMethodsHash;
        }

        public long getRpcVersion() {
            return this.rpcVersion;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.rpcVersion = in.readLong();
            this.declaringClassProtocolName = UTF8.readString(in);
            this.methodName = UTF8.readString(in);
            this.clientVersion = in.readLong();
            this.clientMethodsHash = in.readInt();
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            ObjectWritable objectWritable = new ObjectWritable();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = ObjectWritable.readObject(in, objectWritable, this.conf);
                this.parameterClasses[i] = objectWritable.getDeclaredClass();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeLong(this.rpcVersion);
            UTF8.writeString(out, this.declaringClassProtocolName);
            UTF8.writeString(out, this.methodName);
            out.writeLong(this.clientVersion);
            out.writeInt(this.clientMethodsHash);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                ObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf, true);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.methodName);
            buffer.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")");
            buffer.append(", rpc version=" + this.rpcVersion);
            buffer.append(", client version=" + this.clientVersion);
            buffer.append(", methodsFingerPrint=" + this.clientMethodsHash);
            return buffer.toString();
        }

        @Override
        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Configuration getConf() {
            return this.conf;
        }
    }
}

