/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.net.InetAddress;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class SaslPropertiesResolver
implements Configurable {
    private Map<String, Object> properties;
    Configuration conf;

    public static SaslPropertiesResolver getInstance(Configuration conf) {
        Class<SaslPropertiesResolver> clazz = conf.getClass("hadoop.security.saslproperties.resolver.class", SaslPropertiesResolver.class, SaslPropertiesResolver.class);
        return ReflectionUtils.newInstance(clazz, conf);
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.properties = new TreeMap<String, Object>();
        String[] qop = conf.getTrimmedStrings("hadoop.rpc.protection", SaslRpcServer.QualityOfProtection.AUTHENTICATION.toString());
        for (int i = 0; i < qop.length; ++i) {
            qop[i] = SaslRpcServer.QualityOfProtection.valueOf(qop[i].toUpperCase()).getSaslQop();
        }
        this.properties.put("javax.security.sasl.qop", StringUtils.join((CharSequence)",", qop));
        this.properties.put("javax.security.sasl.server.authentication", "true");
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    protected Map<String, Object> getDefaultProperties() {
        return this.properties;
    }

    public Map<String, Object> getServerProperties(InetAddress clientAddress) {
        return this.properties;
    }

    public Map<String, Object> getClientProperties(InetAddress serverAddress) {
        return this.properties;
    }
}

