/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;

public class TestDeprecatedKeys
extends TestCase {
    public void testDeprecatedKeys() throws Exception {
        Configuration conf = new Configuration();
        conf.set("topology.script.file.name", "xyz");
        conf.set("topology.script.file.name", "xyz");
        String scriptFile = conf.get("net.topology.script.file.name");
        TestDeprecatedKeys.assertTrue((boolean)scriptFile.equals("xyz"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadWriteWithDeprecatedKeys() throws Exception {
        String fileContents;
        Configuration conf = new Configuration();
        conf.setBoolean("old.config.yet.to.be.deprecated", true);
        Configuration.addDeprecation((String)"old.config.yet.to.be.deprecated", (String[])new String[]{"new.conf.to.replace.deprecated.conf"});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            conf.writeXml((OutputStream)out);
            fileContents = out.toString();
        }
        finally {
            out.close();
        }
        TestDeprecatedKeys.assertTrue((boolean)fileContents.contains("old.config.yet.to.be.deprecated"));
        TestDeprecatedKeys.assertTrue((boolean)fileContents.contains("new.conf.to.replace.deprecated.conf"));
    }

    @Test
    public void testIteratorWithDeprecatedKeysMappedToMultipleNewKeys() {
        Configuration conf = new Configuration();
        Configuration.addDeprecation((String)"dK", (String[])new String[]{"nK1", "nK2"});
        conf.set("k", "v");
        conf.set("dK", "V");
        TestDeprecatedKeys.assertEquals((String)"V", (String)conf.get("dK"));
        TestDeprecatedKeys.assertEquals((String)"V", (String)conf.get("nK1"));
        TestDeprecatedKeys.assertEquals((String)"V", (String)conf.get("nK2"));
        conf.set("nK1", "VV");
        TestDeprecatedKeys.assertEquals((String)"VV", (String)conf.get("dK"));
        TestDeprecatedKeys.assertEquals((String)"VV", (String)conf.get("nK1"));
        TestDeprecatedKeys.assertEquals((String)"VV", (String)conf.get("nK2"));
        conf.set("nK2", "VVV");
        TestDeprecatedKeys.assertEquals((String)"VVV", (String)conf.get("dK"));
        TestDeprecatedKeys.assertEquals((String)"VVV", (String)conf.get("nK2"));
        TestDeprecatedKeys.assertEquals((String)"VVV", (String)conf.get("nK1"));
        boolean kFound = false;
        boolean dKFound = false;
        boolean nK1Found = false;
        boolean nK2Found = false;
        for (Map.Entry entry : conf) {
            if (((String)entry.getKey()).equals("k")) {
                TestDeprecatedKeys.assertEquals((String)"v", (String)((String)entry.getValue()));
                kFound = true;
            }
            if (((String)entry.getKey()).equals("dK")) {
                TestDeprecatedKeys.assertEquals((String)"VVV", (String)((String)entry.getValue()));
                dKFound = true;
            }
            if (((String)entry.getKey()).equals("nK1")) {
                TestDeprecatedKeys.assertEquals((String)"VVV", (String)((String)entry.getValue()));
                nK1Found = true;
            }
            if (!((String)entry.getKey()).equals("nK2")) continue;
            TestDeprecatedKeys.assertEquals((String)"VVV", (String)((String)entry.getValue()));
            nK2Found = true;
        }
        TestDeprecatedKeys.assertTrue((String)"regular Key not found", (boolean)kFound);
        TestDeprecatedKeys.assertTrue((String)"deprecated Key not found", (boolean)dKFound);
        TestDeprecatedKeys.assertTrue((String)"new Key 1 not found", (boolean)nK1Found);
        TestDeprecatedKeys.assertTrue((String)"new Key 2 not found", (boolean)nK2Found);
    }
}

