/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3.FileSystemStore;
import org.apache.hadoop.fs.s3.InMemoryFileSystemStore;
import org.apache.hadoop.fs.s3.S3FileSystem;

public class TestS3FileSystem
extends TestCase {
    public void testInitialization() throws IOException {
        this.initializationTest("s3://a:b@c", "s3://a:b@c");
        this.initializationTest("s3://a:b@c/", "s3://a:b@c");
        this.initializationTest("s3://a:b@c/path", "s3://a:b@c");
        this.initializationTest("s3://a@c", "s3://a@c");
        this.initializationTest("s3://a@c/", "s3://a@c");
        this.initializationTest("s3://a@c/path", "s3://a@c");
        this.initializationTest("s3://c", "s3://c");
        this.initializationTest("s3://c/", "s3://c");
        this.initializationTest("s3://c/path", "s3://c");
    }

    private void initializationTest(String initializationUri, String expectedUri) throws IOException {
        S3FileSystem fs = new S3FileSystem((FileSystemStore)new InMemoryFileSystemStore());
        fs.initialize(URI.create(initializationUri), new Configuration());
        TestS3FileSystem.assertEquals((Object)URI.create(expectedUri), (Object)fs.getUri());
    }
}

