/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.TestChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestViewFileSystemDelegation {
    static Configuration conf;
    static FileSystem viewFs;
    static FakeFileSystem fs1;
    static FakeFileSystem fs2;

    @BeforeClass
    public static void setup() throws Exception {
        conf = ViewFileSystemTestSetup.createConfig();
        fs1 = TestViewFileSystemDelegation.setupFileSystem(new URI("fs1:/"), FakeFileSystem.class);
        fs2 = TestViewFileSystemDelegation.setupFileSystem(new URI("fs2:/"), FakeFileSystem.class);
        viewFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
    }

    static FakeFileSystem setupFileSystem(URI uri, Class clazz) throws Exception {
        String scheme = uri.getScheme();
        conf.set("fs." + scheme + ".impl", clazz.getName());
        FakeFileSystem fs = (FakeFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Path targetPath = new FileSystemTestHelper().getAbsoluteTestRootPath((FileSystem)fs);
        ConfigUtil.addLink((Configuration)conf, (String)("/mounts/" + scheme), (URI)targetPath.toUri());
        return fs;
    }

    private static FileSystem setupMockFileSystem(Configuration conf, URI uri) throws Exception {
        String scheme = uri.getScheme();
        conf.set("fs." + scheme + ".impl", TestChRootedFileSystem.MockFileSystem.class.getName());
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        ConfigUtil.addLink((Configuration)conf, (String)("/mounts/" + scheme), (URI)uri);
        return ((TestChRootedFileSystem.MockFileSystem)fs).getRawFileSystem();
    }

    @Test
    public void testSanity() {
        Assert.assertEquals((Object)"fs1:/", (Object)fs1.getUri().toString());
        Assert.assertEquals((Object)"fs2:/", (Object)fs2.getUri().toString());
    }

    @Test
    public void testVerifyChecksum() throws Exception {
        this.checkVerifyChecksum(false);
        this.checkVerifyChecksum(true);
    }

    @Test
    public void testAclMethods() throws Exception {
        Configuration conf = ViewFileSystemTestSetup.createConfig();
        FileSystem mockFs1 = TestViewFileSystemDelegation.setupMockFileSystem(conf, new URI("mockfs1:/"));
        FileSystem mockFs2 = TestViewFileSystemDelegation.setupMockFileSystem(conf, new URI("mockfs2:/"));
        FileSystem viewFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        Path viewFsPath1 = new Path("/mounts/mockfs1/a/b/c");
        Path mockFsPath1 = new Path("/a/b/c");
        Path viewFsPath2 = new Path("/mounts/mockfs2/d/e/f");
        Path mockFsPath2 = new Path("/d/e/f");
        List entries = Collections.emptyList();
        viewFs.modifyAclEntries(viewFsPath1, entries);
        ((FileSystem)Mockito.verify((Object)mockFs1)).modifyAclEntries(mockFsPath1, entries);
        viewFs.modifyAclEntries(viewFsPath2, entries);
        ((FileSystem)Mockito.verify((Object)mockFs2)).modifyAclEntries(mockFsPath2, entries);
        viewFs.removeAclEntries(viewFsPath1, entries);
        ((FileSystem)Mockito.verify((Object)mockFs1)).removeAclEntries(mockFsPath1, entries);
        viewFs.removeAclEntries(viewFsPath2, entries);
        ((FileSystem)Mockito.verify((Object)mockFs2)).removeAclEntries(mockFsPath2, entries);
        viewFs.removeDefaultAcl(viewFsPath1);
        ((FileSystem)Mockito.verify((Object)mockFs1)).removeDefaultAcl(mockFsPath1);
        viewFs.removeDefaultAcl(viewFsPath2);
        ((FileSystem)Mockito.verify((Object)mockFs2)).removeDefaultAcl(mockFsPath2);
        viewFs.removeAcl(viewFsPath1);
        ((FileSystem)Mockito.verify((Object)mockFs1)).removeAcl(mockFsPath1);
        viewFs.removeAcl(viewFsPath2);
        ((FileSystem)Mockito.verify((Object)mockFs2)).removeAcl(mockFsPath2);
        viewFs.setAcl(viewFsPath1, entries);
        ((FileSystem)Mockito.verify((Object)mockFs1)).setAcl(mockFsPath1, entries);
        viewFs.setAcl(viewFsPath2, entries);
        ((FileSystem)Mockito.verify((Object)mockFs2)).setAcl(mockFsPath2, entries);
        viewFs.getAclStatus(viewFsPath1);
        ((FileSystem)Mockito.verify((Object)mockFs1)).getAclStatus(mockFsPath1);
        viewFs.getAclStatus(viewFsPath2);
        ((FileSystem)Mockito.verify((Object)mockFs2)).getAclStatus(mockFsPath2);
    }

    void checkVerifyChecksum(boolean flag) {
        viewFs.setVerifyChecksum(flag);
        Assert.assertEquals((Object)flag, (Object)fs1.getVerifyChecksum());
        Assert.assertEquals((Object)flag, (Object)fs2.getVerifyChecksum());
    }

    static class FakeFileSystem
    extends LocalFileSystem {
        boolean verifyChecksum = true;
        URI uri;

        FakeFileSystem() {
        }

        public void initialize(URI uri, Configuration conf) throws IOException {
            super.initialize(uri, conf);
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setVerifyChecksum(boolean verifyChecksum) {
            this.verifyChecksum = verifyChecksum;
        }

        public boolean getVerifyChecksum() {
            return this.verifyChecksum;
        }
    }
}

