/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestAuthenticationFilter
extends TestCase {
    public void testConfiguration() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.authentication.foo", "bar");
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        File secretFile = new File(testDir, "http-secret.txt");
        FileWriter writer = new FileWriter(new File(testDir, "http-secret.txt"));
        writer.write("hadoop");
        ((Writer)writer).close();
        conf.set("hadoop.http.authentication.signature.secret.file", secretFile.getAbsolutePath());
        conf.set("bind.address", "barhost");
        FilterContainer container = (FilterContainer)Mockito.mock(FilterContainer.class);
        ((FilterContainer)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                TestCase.assertEquals((Object)"authentication", (Object)args[0]);
                TestCase.assertEquals((Object)AuthenticationFilter.class.getName(), (Object)args[1]);
                Map conf = (Map)args[2];
                TestCase.assertEquals((String)"/", (String)((String)conf.get("cookie.path")));
                TestCase.assertEquals((String)"simple", (String)((String)conf.get("type")));
                TestCase.assertEquals((String)"36000", (String)((String)conf.get("token.validity")));
                TestCase.assertEquals((String)"hadoop", (String)((String)conf.get("signature.secret")));
                TestCase.assertNull(conf.get("cookie.domain"));
                TestCase.assertEquals((String)"true", (String)((String)conf.get("simple.anonymous.allowed")));
                TestCase.assertEquals((String)"HTTP/barhost@LOCALHOST", (String)((String)conf.get("kerberos.principal")));
                TestCase.assertEquals((String)(System.getProperty("user.home") + "/hadoop.keytab"), (String)((String)conf.get("kerberos.keytab")));
                TestCase.assertEquals((String)"bar", (String)((String)conf.get("foo")));
                return null;
            }
        }).when((Object)container)).addFilter((String)Mockito.anyObject(), (String)Mockito.anyObject(), (Map)Mockito.anyObject());
        new AuthenticationFilterInitializer().initFilter(container, conf);
    }
}

