/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public abstract class TestConfigurationFieldsBase {
    protected String xmlFilename = null;
    protected Class[] configurationClasses = null;
    protected boolean errorIfMissingConfigProps = false;
    protected boolean errorIfMissingXmlProps = false;
    protected Set<String> configurationPropsToSkipCompare = null;
    protected Set<String> configurationPrefixToSkipCompare = null;
    protected Set<String> xmlPropsToSkipCompare = null;
    protected Set<String> xmlPrefixToSkipCompare = null;
    private Map<String, String> configurationMemberVariables = null;
    private Map<String, String> xmlKeyValueMap = null;
    private Set<String> configurationFieldsMissingInXmlFile = null;
    private Set<String> xmlFieldsMissingInConfiguration = null;

    public abstract void initializeMemberVariables();

    private HashMap<String, String> extractMemberVariablesFromConfigurationFields(Field[] fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        String propRegex = "^[A-Za-z_-]+(\\.[A-Za-z_-]+)+$";
        Pattern p = Pattern.compile(propRegex);
        boolean totalFields = false;
        for (Field f : fields) {
            Matcher m;
            String value;
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getType().getName().equals("java.lang.String")) continue;
            try {
                value = (String)f.get(null);
            }
            catch (IllegalAccessException iaException) {
                continue;
            }
            if (value.endsWith(".xml") || value.endsWith(".") || value.endsWith("-") || this.configurationPropsToSkipCompare != null && this.configurationPropsToSkipCompare.contains(value)) continue;
            boolean skipPrefix = false;
            if (this.configurationPrefixToSkipCompare != null) {
                for (String cfgPrefix : this.configurationPrefixToSkipCompare) {
                    if (!value.startsWith(cfgPrefix)) continue;
                    skipPrefix = true;
                    break;
                }
            }
            if (skipPrefix || !(m = p.matcher(value)).find()) continue;
            retVal.put(value, f.getName());
        }
        return retVal;
    }

    private HashMap<String, String> extractPropertiesFromXml(String filename) {
        if (filename == null) {
            return null;
        }
        Configuration conf = new Configuration(false);
        conf.setAllowNullValueProperties(true);
        conf.addResource(filename);
        HashMap<String, String> retVal = new HashMap<String, String>();
        Iterator kvItr = conf.iterator();
        while (kvItr.hasNext()) {
            Map.Entry entry = (Map.Entry)kvItr.next();
            String key = (String)entry.getKey();
            if (this.xmlPropsToSkipCompare != null && this.xmlPropsToSkipCompare.contains(key)) continue;
            boolean skipPrefix = false;
            if (this.xmlPrefixToSkipCompare != null) {
                for (String xmlPrefix : this.xmlPrefixToSkipCompare) {
                    if (!key.startsWith(xmlPrefix)) continue;
                    skipPrefix = true;
                    break;
                }
            }
            if (skipPrefix) continue;
            if (conf.onlyKeyExists(key)) {
                retVal.put(key, null);
            } else {
                String value = conf.get(key);
                if (value != null) {
                    retVal.put(key, (String)entry.getValue());
                }
            }
            kvItr.remove();
        }
        return retVal;
    }

    private static Set<String> compareConfigurationToXmlFields(Map<String, String> keyMap1, Map<String, String> keyMap2) {
        HashSet<String> retVal = new HashSet<String>(keyMap1.keySet());
        retVal.removeAll(keyMap2.keySet());
        return retVal;
    }

    @Before
    public void setupTestConfigurationFields() throws Exception {
        this.initializeMemberVariables();
        Assert.assertTrue((this.xmlFilename != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationClasses != null ? 1 : 0) != 0);
        this.configurationMemberVariables = new HashMap<String, String>();
        for (Class c : this.configurationClasses) {
            Field[] fields = c.getDeclaredFields();
            HashMap<String, String> memberMap = this.extractMemberVariablesFromConfigurationFields(fields);
            if (memberMap == null) continue;
            this.configurationMemberVariables.putAll(memberMap);
        }
        this.xmlKeyValueMap = this.extractPropertiesFromXml(this.xmlFilename);
        this.configurationFieldsMissingInXmlFile = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.configurationMemberVariables, this.xmlKeyValueMap);
        this.xmlFieldsMissingInConfiguration = TestConfigurationFieldsBase.compareConfigurationToXmlFields(this.xmlKeyValueMap, this.configurationMemberVariables);
    }

    @Test
    public void testCompareConfigurationClassAgainstXml() {
        Assert.assertTrue((this.xmlFilename != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationClasses != null ? 1 : 0) != 0);
        int missingXmlSize = this.configurationFieldsMissingInXmlFile.size();
        for (Class c : this.configurationClasses) {
            System.out.println(c);
        }
        System.out.println("  (" + this.configurationMemberVariables.size() + " member variables)");
        System.out.println();
        StringBuffer xmlErrorMsg = new StringBuffer();
        for (Class c : this.configurationClasses) {
            xmlErrorMsg.append(c);
            xmlErrorMsg.append(" ");
        }
        xmlErrorMsg.append("has ");
        xmlErrorMsg.append(missingXmlSize);
        xmlErrorMsg.append(" variables missing in ");
        xmlErrorMsg.append(this.xmlFilename);
        System.out.println(xmlErrorMsg.toString());
        System.out.println();
        if (missingXmlSize == 0) {
            System.out.println("  (None)");
        } else {
            for (String missingField : this.configurationFieldsMissingInXmlFile) {
                System.out.println("  " + missingField);
            }
        }
        System.out.println();
        System.out.println("=====");
        System.out.println();
        if (this.errorIfMissingXmlProps) {
            Assert.assertTrue((String)xmlErrorMsg.toString(), (missingXmlSize == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareXmlAgainstConfigurationClass() {
        Assert.assertTrue((this.xmlFilename != null ? 1 : 0) != 0);
        Assert.assertTrue((this.configurationClasses != null ? 1 : 0) != 0);
        int missingConfigSize = this.xmlFieldsMissingInConfiguration.size();
        System.out.println("File " + this.xmlFilename + " (" + this.xmlKeyValueMap.size() + " properties)");
        System.out.println();
        StringBuffer configErrorMsg = new StringBuffer();
        configErrorMsg.append(this.xmlFilename);
        configErrorMsg.append(" has ");
        configErrorMsg.append(missingConfigSize);
        configErrorMsg.append(" properties missing in");
        for (Class c : this.configurationClasses) {
            configErrorMsg.append("  " + c);
        }
        System.out.println(configErrorMsg.toString());
        System.out.println();
        if (missingConfigSize == 0) {
            System.out.println("  (None)");
        } else {
            for (String missingField : this.xmlFieldsMissingInConfiguration) {
                System.out.println("  " + missingField);
            }
        }
        System.out.println();
        System.out.println("=====");
        System.out.println();
        if (this.errorIfMissingConfigProps) {
            Assert.assertTrue((String)configErrorMsg.toString(), (missingConfigSize == 0 ? 1 : 0) != 0);
        }
    }
}

