/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.SetFile;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class TestSetFile
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestSetFile.class);
    private static String FILE = System.getProperty("test.build.data", ".") + "/test.set";
    private static Configuration conf = new Configuration();

    public TestSetFile(String name) {
        super(name);
    }

    public void testSetFile() throws Exception {
        try (LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);){
            RandomDatum[] data = TestSetFile.generate(10000);
            TestSetFile.writeTest((FileSystem)fs, data, FILE, SequenceFile.CompressionType.NONE);
            TestSetFile.readTest((FileSystem)fs, data, FILE);
            TestSetFile.writeTest((FileSystem)fs, data, FILE, SequenceFile.CompressionType.BLOCK);
            TestSetFile.readTest((FileSystem)fs, data, FILE);
        }
    }

    public void testSetFileAccessMethods() {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            int size = 10;
            this.writeData((FileSystem)fs, size);
            SetFile.Reader reader = this.createReader((FileSystem)fs);
            TestSetFile.assertTrue((String)"testSetFileWithConstruction1 error !!!", (boolean)reader.next((WritableComparable)new IntWritable(0)));
            TestSetFile.assertEquals((String)"testSetFileWithConstruction2 error !!!", (Object)new IntWritable(size / 2 + 1), (Object)reader.get((WritableComparable)new IntWritable(size / 2)));
            TestSetFile.assertNull((String)"testSetFileWithConstruction3 error !!!", (Object)reader.get((WritableComparable)new IntWritable(size * 2)));
        }
        catch (Exception ex) {
            TestSetFile.fail((String)"testSetFileWithConstruction error !!!");
        }
    }

    private SetFile.Reader createReader(FileSystem fs) throws IOException {
        return new SetFile.Reader(fs, FILE, WritableComparator.get(IntWritable.class), conf);
    }

    private void writeData(FileSystem fs, int elementSize) throws IOException {
        MapFile.delete((FileSystem)fs, (String)FILE);
        SetFile.Writer writer = new SetFile.Writer(fs, FILE, IntWritable.class);
        for (int i = 0; i < elementSize; ++i) {
            writer.append((WritableComparable)new IntWritable(i));
        }
        writer.close();
    }

    private static RandomDatum[] generate(int count) {
        LOG.info((Object)("generating " + count + " records in memory"));
        Object[] data = new RandomDatum[count];
        RandomDatum.Generator generator = new RandomDatum.Generator();
        for (int i = 0; i < count; ++i) {
            generator.next();
            data[i] = generator.getValue();
        }
        LOG.info((Object)("sorting " + count + " records"));
        Arrays.sort(data);
        return data;
    }

    private static void writeTest(FileSystem fs, RandomDatum[] data, String file, SequenceFile.CompressionType compress) throws IOException {
        MapFile.delete((FileSystem)fs, (String)file);
        LOG.info((Object)("creating with " + data.length + " records"));
        SetFile.Writer writer = new SetFile.Writer(conf, fs, file, WritableComparator.get(RandomDatum.class), compress);
        for (int i = 0; i < data.length; ++i) {
            writer.append((WritableComparable)data[i]);
        }
        writer.close();
    }

    private static void readTest(FileSystem fs, RandomDatum[] data, String file) throws IOException {
        RandomDatum v = new RandomDatum();
        int sample = (int)Math.sqrt(data.length);
        Random random = new Random();
        LOG.info((Object)("reading " + sample + " records"));
        SetFile.Reader reader = new SetFile.Reader(fs, file, conf);
        for (int i = 0; i < sample; ++i) {
            if (reader.seek((WritableComparable)data[random.nextInt(data.length)])) continue;
            throw new RuntimeException("wrong value at " + i);
        }
        reader.close();
        LOG.info((Object)("done reading " + data.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 0x100000;
        boolean create = true;
        boolean check = true;
        String file = FILE;
        String compress = "NONE";
        String usage = "Usage: TestSetFile [-count N] [-nocreate] [-nocheck] [-compress type] file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        Path fpath = null;
        try (FileSystem fs = null;){
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-nocreate")) {
                    create = false;
                    continue;
                }
                if (args[i].equals("-nocheck")) {
                    check = false;
                    continue;
                }
                if (args[i].equals("-compress")) {
                    compress = args[++i];
                    continue;
                }
                file = args[i];
                fpath = new Path(file);
            }
            fs = fpath.getFileSystem(conf);
            LOG.info((Object)("count = " + count));
            LOG.info((Object)("create = " + create));
            LOG.info((Object)("check = " + check));
            LOG.info((Object)("compress = " + compress));
            LOG.info((Object)("file = " + file));
            RandomDatum[] data = TestSetFile.generate(count);
            if (create) {
                TestSetFile.writeTest(fs, data, file, SequenceFile.CompressionType.valueOf((String)compress));
            }
            if (check) {
                TestSetFile.readTest(fs, data, file);
            }
        }
    }
}

