/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.StaticMapping;
import org.junit.Assert;
import org.junit.Test;

public class TestStaticMapping
extends Assert {
    private static final Log LOG = LogFactory.getLog(TestStaticMapping.class);

    private StaticMapping newInstance() {
        StaticMapping.resetMap();
        return new StaticMapping();
    }

    private StaticMapping newInstance(String script) {
        StaticMapping mapping = this.newInstance();
        mapping.setConf(this.createConf(script));
        return mapping;
    }

    private Configuration createConf(String script) {
        Configuration conf = new Configuration();
        if (script != null) {
            conf.set("net.topology.script.file.name", script);
        } else {
            conf.unset("net.topology.script.file.name");
        }
        return conf;
    }

    private void assertSingleSwitch(DNSToSwitchMapping mapping) {
        TestStaticMapping.assertEquals((String)("Expected a single switch mapping " + mapping), (Object)true, (Object)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping));
    }

    private void assertMultiSwitch(DNSToSwitchMapping mapping) {
        TestStaticMapping.assertEquals((String)("Expected a multi switch mapping " + mapping), (Object)false, (Object)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping));
    }

    protected void assertMapSize(AbstractDNSToSwitchMapping switchMapping, int expectedSize) {
        TestStaticMapping.assertEquals((String)("Expected two entries in the map " + switchMapping.dumpTopology()), (long)expectedSize, (long)switchMapping.getSwitchMap().size());
    }

    private List<String> createQueryList() {
        ArrayList<String> l1 = new ArrayList<String>(2);
        l1.add("n1");
        l1.add("unknown");
        return l1;
    }

    @Test
    public void testStaticIsSingleSwitchOnNullScript() throws Throwable {
        StaticMapping mapping = this.newInstance(null);
        mapping.setConf(this.createConf(null));
        this.assertSingleSwitch((DNSToSwitchMapping)mapping);
    }

    @Test
    public void testStaticIsMultiSwitchOnScript() throws Throwable {
        StaticMapping mapping = this.newInstance("ls");
        this.assertMultiSwitch((DNSToSwitchMapping)mapping);
    }

    @Test
    public void testAddResolveNodes() throws Throwable {
        StaticMapping mapping = this.newInstance();
        StaticMapping.addNodeToRack("n1", "/r1");
        List<String> queryList = this.createQueryList();
        List<String> resolved = mapping.resolve(queryList);
        TestStaticMapping.assertEquals((long)2L, (long)resolved.size());
        TestStaticMapping.assertEquals((Object)"/r1", (Object)resolved.get(0));
        TestStaticMapping.assertEquals((Object)"/default-rack", (Object)resolved.get(1));
        Map<String, String> switchMap = mapping.getSwitchMap();
        String topology = mapping.dumpTopology();
        LOG.info((Object)topology);
        TestStaticMapping.assertEquals((String)topology, (long)1L, (long)switchMap.size());
        TestStaticMapping.assertEquals((String)topology, (Object)"/r1", (Object)switchMap.get("n1"));
    }

    @Test
    public void testReadNodesFromConfig() throws Throwable {
        StaticMapping mapping = this.newInstance();
        Configuration conf = new Configuration();
        conf.set("hadoop.configured.node.mapping", "n1=/r1,n2=/r2");
        mapping.setConf(conf);
        this.assertSingleSwitch((DNSToSwitchMapping)mapping);
        ArrayList<String> l1 = new ArrayList<String>(3);
        l1.add("n1");
        l1.add("unknown");
        l1.add("n2");
        List<String> resolved = mapping.resolve(l1);
        TestStaticMapping.assertEquals((long)3L, (long)resolved.size());
        TestStaticMapping.assertEquals((Object)"/r1", (Object)resolved.get(0));
        TestStaticMapping.assertEquals((Object)"/default-rack", (Object)resolved.get(1));
        TestStaticMapping.assertEquals((Object)"/r2", (Object)resolved.get(2));
        Map<String, String> switchMap = mapping.getSwitchMap();
        String topology = mapping.dumpTopology();
        LOG.info((Object)topology);
        TestStaticMapping.assertEquals((String)topology, (long)2L, (long)switchMap.size());
        TestStaticMapping.assertEquals((String)topology, (Object)"/r1", (Object)switchMap.get("n1"));
        TestStaticMapping.assertNull((String)topology, (Object)switchMap.get("unknown"));
    }

    @Test
    public void testCachingRelaysSingleSwitchQueries() throws Throwable {
        StaticMapping staticMapping = this.newInstance(null);
        this.assertSingleSwitch((DNSToSwitchMapping)staticMapping);
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        LOG.info((Object)("Mapping: " + cachedMap + "\n" + cachedMap.dumpTopology()));
        this.assertSingleSwitch((DNSToSwitchMapping)cachedMap);
    }

    @Test
    public void testCachingRelaysMultiSwitchQueries() throws Throwable {
        StaticMapping staticMapping = this.newInstance("top");
        this.assertMultiSwitch((DNSToSwitchMapping)staticMapping);
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        LOG.info((Object)("Mapping: " + cachedMap + "\n" + cachedMap.dumpTopology()));
        this.assertMultiSwitch((DNSToSwitchMapping)cachedMap);
    }

    @Test
    public void testCachingRelaysResolveQueries() throws Throwable {
        StaticMapping mapping = this.newInstance();
        mapping.setConf(this.createConf("top"));
        StaticMapping staticMapping = mapping;
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 0);
        StaticMapping.addNodeToRack("n1", "/r1");
        this.assertMapSize(staticMapping, 1);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 0);
        cachedMap.resolve(this.createQueryList());
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 2);
    }

    @Test
    public void testCachingCachesNegativeEntries() throws Throwable {
        StaticMapping staticMapping = this.newInstance();
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 0);
        this.assertMapSize(staticMapping, 0);
        List resolved = cachedMap.resolve(this.createQueryList());
        this.assertMapSize(staticMapping, 0);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 2);
    }
}

