/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.io.file.tfile.TestTFileByteArrays;
import org.junit.Assert;

public class TestTFileStreams
extends TestCase {
    private static String ROOT = System.getProperty("test.build.data", "/tmp/tfile-test");
    private static final int BLOCK_SIZE = 512;
    private static final int K = 1024;
    private static final int M = 0x100000;
    protected boolean skip = false;
    private FileSystem fs;
    private Configuration conf;
    private Path path;
    private FSDataOutputStream out;
    TFile.Writer writer;
    private String compression = Compression.Algorithm.GZ.getName();
    private String comparator = "memcmp";
    private final String outputFile = ((Object)((Object)this)).getClass().getSimpleName();

    public void init(String compression, String comparator) {
        this.compression = compression;
        this.comparator = comparator;
    }

    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile);
        this.fs = this.path.getFileSystem(this.conf);
        this.out = this.fs.create(this.path);
        this.writer = new TFile.Writer(this.out, 512, this.compression, this.comparator, this.conf);
    }

    public void tearDown() throws IOException {
        if (!this.skip) {
            try {
                this.closeOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fs.delete(this.path, true);
        }
    }

    public void testNoEntry() throws IOException {
        if (this.skip) {
            return;
        }
        this.closeOutput();
        TestTFileByteArrays.readRecords(this.fs, this.path, 0, this.conf);
    }

    public void testOneEntryKnownLength() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(1, true, true);
        TestTFileByteArrays.readRecords(this.fs, this.path, 1, this.conf);
    }

    public void testOneEntryUnknownLength() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(1, false, false);
        TestTFileByteArrays.readRecords(this.fs, this.path, 1, this.conf);
    }

    public void testOneEntryMixedLengths1() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(1, true, false);
        TestTFileByteArrays.readRecords(this.fs, this.path, 1, this.conf);
    }

    public void testOneEntryMixedLengths2() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(1, false, true);
        TestTFileByteArrays.readRecords(this.fs, this.path, 1, this.conf);
    }

    public void testTwoEntriesKnownLength() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(2, true, true);
        TestTFileByteArrays.readRecords(this.fs, this.path, 2, this.conf);
    }

    public void testFailureAddKeyWithoutValue() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream dos = this.writer.prepareAppendKey(-1);
        dos.write("key0".getBytes());
        try {
            this.closeOutput();
            TestTFileStreams.fail((String)"Cannot add only a key without a value. ");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testFailureAddValueWithoutKey() throws IOException {
        if (this.skip) {
            return;
        }
        try (DataOutputStream outValue = null;){
            outValue = this.writer.prepareAppendValue(6);
            outValue.write("value0".getBytes());
            TestTFileStreams.fail((String)"Cannot add a value without adding key first. ");
        }
    }

    public void testFailureOneEntryKnownLength() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream outKey = this.writer.prepareAppendKey(2);
        try {
            outKey.write("key0".getBytes());
            TestTFileStreams.fail((String)"Specified key length mismatched the actual key length.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DataOutputStream outValue = null;
        try {
            outValue = this.writer.prepareAppendValue(6);
            outValue.write("value0".getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testFailureKeyTooLong() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream outKey = this.writer.prepareAppendKey(2);
        try {
            outKey.write("key0".getBytes());
            outKey.close();
            Assert.fail((String)"Key is longer than requested.");
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureKeyTooShort() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream outKey = this.writer.prepareAppendKey(4);
        outKey.write("key0".getBytes());
        outKey.close();
        DataOutputStream outValue = this.writer.prepareAppendValue(15);
        try {
            outValue.write("value0".getBytes());
            outValue.close();
            Assert.fail((String)"Value is shorter than expected.");
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public void testFailureValueTooLong() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream outKey = this.writer.prepareAppendKey(4);
        outKey.write("key0".getBytes());
        outKey.close();
        DataOutputStream outValue = this.writer.prepareAppendValue(3);
        try {
            outValue.write("value0".getBytes());
            outValue.close();
            Assert.fail((String)"Value is longer than expected.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            outKey.close();
            outKey.close();
        }
        catch (Exception e) {
            Assert.fail((String)"Second or more close() should have no effect.");
        }
    }

    public void testFailureValueTooShort() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream outKey = this.writer.prepareAppendKey(8);
        try {
            outKey.write("key0".getBytes());
            outKey.close();
            Assert.fail((String)"Key is shorter than expected.");
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public void testFailureCloseKeyStreamManyTimesInWriter() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream outKey = this.writer.prepareAppendKey(4);
        try {
            outKey.write("key0".getBytes());
            outKey.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                outKey.close();
            }
            catch (Exception exception) {}
        }
        outKey.close();
        outKey.close();
        Assert.assertTrue((String)"Multiple close should have no effect.", (boolean)true);
    }

    public void testFailureKeyLongerThan64K() throws IOException {
        if (this.skip) {
            return;
        }
        try {
            DataOutputStream outKey = this.writer.prepareAppendKey(65537);
            Assert.fail((String)"Failed to handle key longer than 64K.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.closeOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureKeyLongerThan64K_2() throws IOException {
        if (this.skip) {
            return;
        }
        DataOutputStream outKey = this.writer.prepareAppendKey(-1);
        try {
            byte[] buf = new byte[1024];
            Random rand = new Random();
            for (int nx = 0; nx < 1026; ++nx) {
                rand.nextBytes(buf);
                outKey.write(buf);
            }
            outKey.close();
            Assert.fail((String)"Failed to handle key longer than 64K.");
        }
        catch (EOFException eOFException) {
        }
        finally {
            try {
                this.closeOutput();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureNegativeOffset() throws IOException {
        if (this.skip) {
            return;
        }
        this.writeRecords(2, true, true);
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        byte[] buf = new byte[1024];
        try {
            scanner.entry().getKey(buf, -1);
            Assert.fail((String)"Failed to handle key negative offset.");
        }
        catch (Exception exception) {}
        scanner.close();
        reader.close();
    }

    public void testFailureCompressionNotWorking() throws IOException {
        if (this.skip) {
            return;
        }
        long rawDataSize = this.writeRecords(10000, false, false, false);
        if (!this.compression.equalsIgnoreCase(Compression.Algorithm.NONE.getName())) {
            Assert.assertTrue((this.out.getPos() < rawDataSize ? 1 : 0) != 0);
        }
        this.closeOutput();
    }

    public void testFailureCompressionNotWorking2() throws IOException {
        if (this.skip) {
            return;
        }
        long rawDataSize = this.writeRecords(10000, true, true, false);
        if (!this.compression.equalsIgnoreCase(Compression.Algorithm.NONE.getName())) {
            Assert.assertTrue((this.out.getPos() < rawDataSize ? 1 : 0) != 0);
        }
        this.closeOutput();
    }

    private long writeRecords(int count, boolean knownKeyLength, boolean knownValueLength, boolean close) throws IOException {
        long rawDataSize = 0L;
        for (int nx = 0; nx < count; ++nx) {
            String key = TestTFileByteArrays.composeSortedKey("key", nx);
            DataOutputStream outKey = this.writer.prepareAppendKey(knownKeyLength ? key.length() : -1);
            outKey.write(key.getBytes());
            outKey.close();
            String value = "value" + nx;
            DataOutputStream outValue = this.writer.prepareAppendValue(knownValueLength ? value.length() : -1);
            outValue.write(value.getBytes());
            outValue.close();
            rawDataSize += (long)(WritableUtils.getVIntSize((long)key.getBytes().length) + key.getBytes().length + WritableUtils.getVIntSize((long)value.getBytes().length) + value.getBytes().length);
        }
        if (close) {
            this.closeOutput();
        }
        return rawDataSize;
    }

    private long writeRecords(int count, boolean knownKeyLength, boolean knownValueLength) throws IOException {
        return this.writeRecords(count, knownKeyLength, knownValueLength, true);
    }

    private void closeOutput() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

