/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.hadoop.util.MachineList;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMachineList {
    private static String IP_LIST = "10.119.103.110,10.119.103.112,10.119.103.114";
    private static String IP_LIST_SPACES = " 10.119.103.110 , 10.119.103.112,10.119.103.114 ,10.119.103.110, ";
    private static String CIDR_LIST = "10.222.0.0/16,10.241.23.0/24";
    private static String CIDR_LIST1 = "10.222.0.0/16";
    private static String CIDR_LIST2 = "10.241.23.0/24";
    private static String INVALID_CIDR = "10.241/24";
    private static String IP_CIDR_LIST = "10.222.0.0/16,10.119.103.110,10.119.103.112,10.119.103.114,10.241.23.0/24";
    private static String HOST_LIST = "host1,host4";
    private static String HOSTNAME_IP_CIDR_LIST = "host1,10.222.0.0/16,10.119.103.110,10.119.103.112,10.119.103.114,10.241.23.0/24,host4,";

    @Test
    public void testWildCard() {
        MachineList ml = new MachineList("*");
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
    }

    @Test
    public void testIPList() {
        MachineList ml = new MachineList(IP_LIST);
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testIPListSpaces() {
        MachineList ml = new MachineList(IP_LIST_SPACES);
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testStaticIPHostNameList() throws UnknownHostException {
        InetAddress addressHost1 = InetAddress.getByName("1.2.3.1");
        InetAddress addressHost4 = InetAddress.getByName("1.2.3.4");
        MachineList.InetAddressFactory addressFactory = (MachineList.InetAddressFactory)Mockito.mock(MachineList.InetAddressFactory.class);
        Mockito.when((Object)addressFactory.getByName("host1")).thenReturn((Object)addressHost1);
        Mockito.when((Object)addressFactory.getByName("host4")).thenReturn((Object)addressHost4);
        MachineList ml = new MachineList(StringUtils.getTrimmedStringCollection((String)HOST_LIST), addressFactory);
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
        Assert.assertFalse((boolean)ml.includes("1.2.3.5"));
    }

    @Test
    public void testHostNames() throws UnknownHostException {
        InetAddress addressHost1 = InetAddress.getByName("1.2.3.1");
        InetAddress addressHost4 = InetAddress.getByName("1.2.3.4");
        InetAddress addressMockHost4 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)addressMockHost4.getCanonicalHostName()).thenReturn((Object)"differentName");
        InetAddress addressMockHost5 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)addressMockHost5.getCanonicalHostName()).thenReturn((Object)"host5");
        MachineList.InetAddressFactory addressFactory = (MachineList.InetAddressFactory)Mockito.mock(MachineList.InetAddressFactory.class);
        Mockito.when((Object)addressFactory.getByName("1.2.3.4")).thenReturn((Object)addressMockHost4);
        Mockito.when((Object)addressFactory.getByName("1.2.3.5")).thenReturn((Object)addressMockHost5);
        Mockito.when((Object)addressFactory.getByName("host1")).thenReturn((Object)addressHost1);
        Mockito.when((Object)addressFactory.getByName("host4")).thenReturn((Object)addressHost4);
        MachineList ml = new MachineList(StringUtils.getTrimmedStringCollection((String)HOST_LIST), addressFactory);
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
        Assert.assertFalse((boolean)ml.includes("1.2.3.5"));
    }

    @Test
    public void testHostNamesReverserIpMatch() throws UnknownHostException {
        InetAddress addressHost1 = InetAddress.getByName("1.2.3.1");
        InetAddress addressHost4 = InetAddress.getByName("1.2.3.4");
        InetAddress addressMockHost4 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)addressMockHost4.getCanonicalHostName()).thenReturn((Object)"host4");
        InetAddress addressMockHost5 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)addressMockHost5.getCanonicalHostName()).thenReturn((Object)"host5");
        MachineList.InetAddressFactory addressFactory = (MachineList.InetAddressFactory)Mockito.mock(MachineList.InetAddressFactory.class);
        Mockito.when((Object)addressFactory.getByName("1.2.3.4")).thenReturn((Object)addressMockHost4);
        Mockito.when((Object)addressFactory.getByName("1.2.3.5")).thenReturn((Object)addressMockHost5);
        Mockito.when((Object)addressFactory.getByName("host1")).thenReturn((Object)addressHost1);
        Mockito.when((Object)addressFactory.getByName("host4")).thenReturn((Object)addressHost4);
        MachineList ml = new MachineList(StringUtils.getTrimmedStringCollection((String)HOST_LIST), addressFactory);
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
        Assert.assertFalse((boolean)ml.includes("1.2.3.5"));
    }

    @Test
    public void testCIDRs() {
        MachineList ml = new MachineList(CIDR_LIST);
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.1"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.254"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.1"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.254"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testCIDRWith16bitmask() {
        MachineList ml = new MachineList(CIDR_LIST1);
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.1"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.254"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testCIDRWith8BitMask() {
        MachineList ml = new MachineList(CIDR_LIST2);
        Assert.assertFalse((boolean)ml.includes("10.241.22.255"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.1"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.254"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.241.24.0"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testInvalidCIDR() {
        try {
            new MachineList(INVALID_CIDR);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable t) {
            Assert.fail((String)"Expected only IllegalArgumentException");
        }
    }

    @Test
    public void testIPandCIDRs() {
        MachineList ml = new MachineList(IP_CIDR_LIST);
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertFalse((boolean)ml.includes("10.241.22.255"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.241.24.0"));
    }

    @Test
    public void testHostNameIPandCIDRs() {
        MachineList ml = new MachineList(HOSTNAME_IP_CIDR_LIST);
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertFalse((boolean)ml.includes("10.241.22.255"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.241.24.0"));
    }

    @Test
    public void testGetCollection() {
        MachineList ml = new MachineList(HOSTNAME_IP_CIDR_LIST);
        Collection col = ml.getCollection();
        Assert.assertEquals((long)7L, (long)ml.getCollection().size());
        for (String item : StringUtils.getTrimmedStringCollection((String)HOSTNAME_IP_CIDR_LIST)) {
            Assert.assertTrue((boolean)col.contains(item));
        }
    }
}

