/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestUGILoginFromKeytab {
    private MiniKdc kdc;
    private File workDir;
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void startMiniKdc() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.workDir = this.folder.getRoot();
        this.kdc = new MiniKdc(MiniKdc.createConf(), this.workDir);
        this.kdc.start();
    }

    @After
    public void stopMiniKdc() {
        if (this.kdc != null) {
            this.kdc.stop();
        }
    }

    @Test
    public void testUGILoginFromKeytab() throws Exception {
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        String principal = "foo";
        File keytab = new File(this.workDir, "foo.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"UGI should be configured to login from keytab", (boolean)ugi.isFromKeytab());
        User user = ugi.getSubject().getPrincipals(User.class).iterator().next();
        long firstLogin = user.getLastLogin();
        ugi.reloginFromKeytab();
        long secondLogin = user.getLastLogin();
        Assert.assertTrue((String)"User should have been able to relogin from keytab", (secondLogin > firstLogin ? 1 : 0) != 0);
    }
}

