/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;

public class TestLocalFileSystemPermission
extends TestCase {
    static final String TEST_PATH_PREFIX = GenericTestUtils.getTempPath(TestLocalFileSystemPermission.class.getSimpleName());

    private Path writeFile(FileSystem fs, String name) throws IOException {
        Path f = new Path(TEST_PATH_PREFIX + name);
        FSDataOutputStream stm = fs.create(f);
        stm.writeBytes("42\n");
        stm.close();
        return f;
    }

    private void cleanupFile(FileSystem fs, Path name) throws IOException {
        TestLocalFileSystemPermission.assertTrue((boolean)fs.exists(name));
        fs.delete(name, true);
        TestLocalFileSystemPermission.assertTrue((!fs.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocalFSsetPermission() throws IOException {
        if (Path.WINDOWS) {
            System.out.println("Cannot run test for Windows");
            return;
        }
        Configuration conf = new Configuration();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        String filename = "foo";
        Path f = this.writeFile((FileSystem)localfs, filename);
        try {
            FsPermission initialPermission = this.getPermission(localfs, f);
            System.out.println(filename + ": " + initialPermission);
            TestLocalFileSystemPermission.assertEquals((Object)FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)conf)), (Object)initialPermission);
        }
        catch (Exception e) {
            System.out.println(StringUtils.stringifyException((Throwable)e));
            System.out.println("Cannot run test");
            return;
        }
        try {
            FsPermission all = new FsPermission(511);
            FsPermission none = new FsPermission(0);
            localfs.setPermission(f, none);
            TestLocalFileSystemPermission.assertEquals((Object)none, (Object)this.getPermission(localfs, f));
            localfs.setPermission(f, all);
            TestLocalFileSystemPermission.assertEquals((Object)all, (Object)this.getPermission(localfs, f));
        }
        finally {
            this.cleanupFile((FileSystem)localfs, f);
        }
    }

    FsPermission getPermission(LocalFileSystem fs, Path p) throws IOException {
        return fs.getFileStatus(p).getPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocalFSsetOwner() throws IOException {
        if (Path.WINDOWS) {
            System.out.println("Cannot run test for Windows");
            return;
        }
        Configuration conf = new Configuration();
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)conf);
        String filename = "bar";
        Path f = this.writeFile((FileSystem)localfs, filename);
        List<String> groups = null;
        try {
            groups = TestLocalFileSystemPermission.getGroups();
            System.out.println(filename + ": " + this.getPermission(localfs, f));
        }
        catch (IOException e) {
            System.out.println(StringUtils.stringifyException((Throwable)e));
            System.out.println("Cannot run test");
            return;
        }
        if (groups == null || groups.size() < 1) {
            System.out.println("Cannot run test: need at least one group.  groups=" + groups);
            return;
        }
        try {
            String g0 = groups.get(0);
            localfs.setOwner(f, null, g0);
            TestLocalFileSystemPermission.assertEquals((String)g0, (String)this.getGroup(localfs, f));
            if (groups.size() > 1) {
                String g1 = groups.get(1);
                localfs.setOwner(f, null, g1);
                TestLocalFileSystemPermission.assertEquals((String)g1, (String)this.getGroup(localfs, f));
            } else {
                System.out.println("Not testing changing the group since user belongs to only one group.");
            }
        }
        finally {
            this.cleanupFile((FileSystem)localfs, f);
        }
    }

    static List<String> getGroups() throws IOException {
        ArrayList<String> a = new ArrayList<String>();
        String s = Shell.execCommand((String[])Shell.getGroupsCommand());
        StringTokenizer t = new StringTokenizer(s);
        while (t.hasMoreTokens()) {
            a.add(t.nextToken());
        }
        return a;
    }

    String getGroup(LocalFileSystem fs, Path p) throws IOException {
        return fs.getFileStatus(p).getGroup();
    }

    static {
        GenericTestUtils.setLogLevel(FileSystem.LOG, Level.DEBUG);
    }
}

