/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;

public abstract class AbstractContractRenameTest
extends AbstractFSContractTestBase {
    @Test
    public void testRenameNewFileSameDir() throws Throwable {
        this.describe("rename a file into a new file in the same directory");
        Path renameSrc = this.path("rename_src");
        Path renameTarget = this.path("rename_dest");
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), renameSrc, data, data.length, 0x100000, false);
        boolean rename = this.rename(renameSrc, renameTarget);
        AbstractContractRenameTest.assertTrue((String)("rename(" + renameSrc + ", " + renameTarget + ") returned false"), (boolean)rename);
        ContractTestUtils.assertListStatusFinds(this.getFileSystem(), renameTarget.getParent(), renameTarget);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), renameTarget, data);
    }

    @Test
    public void testRenameNonexistentFile() throws Throwable {
        this.describe("rename a file into a new file in the same directory");
        Path missing = this.path("testRenameNonexistentFileSrc");
        Path target = this.path("testRenameNonexistentFileDest");
        boolean renameReturnsFalseOnFailure = this.isSupported("rename-returns-false-if-source-missing");
        this.mkdirs(missing.getParent());
        try {
            boolean renamed = this.rename(missing, target);
            if (!renameReturnsFalseOnFailure) {
                String destDirLS = this.generateAndLogErrorListing(missing, target);
                AbstractContractRenameTest.fail((String)("expected rename(" + missing + ", " + target + " ) to fail," + " got a result of " + renamed + " and a destination directory of " + destDirLS));
            } else {
                AbstractContractRenameTest.getLog().warn("Rename returned {} renaming a nonexistent file", (Object)renamed);
                AbstractContractRenameTest.assertFalse((String)"Renaming a missing file returned true", (boolean)renamed);
            }
        }
        catch (FileNotFoundException e) {
            if (renameReturnsFalseOnFailure) {
                ContractTestUtils.fail("Renaming a missing file unexpectedly threw an exception", e);
            }
            this.handleExpectedException(e);
        }
        catch (IOException e) {
            this.handleRelaxedException("rename nonexistent file", "FileNotFoundException", e);
        }
        this.assertPathDoesNotExist("rename nonexistent file created a destination file", target);
    }

    @Test
    public void testRenameFileOverExistingFile() throws Throwable {
        this.describe("Verify renaming a file onto an existing file matches expectations");
        Path srcFile = this.path("source-256.txt");
        byte[] srcData = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), srcFile, srcData, srcData.length, 1024, false);
        Path destFile = this.path("dest-512.txt");
        byte[] destData = ContractTestUtils.dataset(512, 65, 90);
        ContractTestUtils.writeDataset(this.getFileSystem(), destFile, destData, destData.length, 1024, false);
        this.assertIsFile(destFile);
        boolean renameOverwritesDest = this.isSupported("rename-overwrites-dest");
        boolean renameReturnsFalseOnRenameDestExists = !this.isSupported("rename-returns-false-if-dest-exists");
        boolean destUnchanged = true;
        try {
            boolean renamed = this.rename(srcFile, destFile);
            if (renameOverwritesDest) {
                AbstractContractRenameTest.assertTrue((String)"Rename returned false", (boolean)renamed);
                destUnchanged = false;
            } else if (renamed && !renameReturnsFalseOnRenameDestExists) {
                String destDirLS = this.generateAndLogErrorListing(srcFile, destFile);
                AbstractContractRenameTest.getLog().error("dest dir {}", (Object)destDirLS);
                AbstractContractRenameTest.fail((String)("expected rename(" + srcFile + ", " + destFile + " ) to fail," + " but got success and destination of " + destDirLS));
            }
        }
        catch (FileAlreadyExistsException e) {
            this.handleExpectedException((Exception)((Object)e));
        }
        ContractTestUtils.verifyFileContents(this.getFileSystem(), destFile, destUnchanged ? destData : srcData);
    }

    @Test
    public void testRenameDirIntoExistingDir() throws Throwable {
        this.describe("Verify renaming a dir into an existing dir puts it underneath and leaves existing files alone");
        FileSystem fs = this.getFileSystem();
        String sourceSubdir = "source";
        Path srcDir = this.path(sourceSubdir);
        Path srcFilePath = new Path(srcDir, "source-256.txt");
        byte[] srcDataset = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(fs, srcFilePath, srcDataset, srcDataset.length, 1024, false);
        Path destDir = this.path("dest");
        Path destFilePath = new Path(destDir, "dest-512.txt");
        byte[] destDateset = ContractTestUtils.dataset(512, 65, 90);
        ContractTestUtils.writeDataset(fs, destFilePath, destDateset, destDateset.length, 1024, false);
        this.assertIsFile(destFilePath);
        boolean rename = this.rename(srcDir, destDir);
        Path renamedSrc = new Path(destDir, sourceSubdir);
        this.assertIsFile(destFilePath);
        this.assertIsDirectory(renamedSrc);
        ContractTestUtils.verifyFileContents(fs, destFilePath, destDateset);
        AbstractContractRenameTest.assertTrue((String)"rename returned false though the contents were copied", (boolean)rename);
    }

    @Test
    public void testRenameFileNonexistentDir() throws Throwable {
        this.describe("rename a file into a new file in the same directory");
        Path renameSrc = this.path("testRenameSrc");
        Path renameTarget = this.path("subdir/testRenameTarget");
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), renameSrc, data, data.length, 0x100000, false);
        boolean renameCreatesDestDirs = this.isSupported("rename-creates-dest-dirs");
        try {
            boolean rename = this.rename(renameSrc, renameTarget);
            if (renameCreatesDestDirs) {
                AbstractContractRenameTest.assertTrue((boolean)rename);
                ContractTestUtils.verifyFileContents(this.getFileSystem(), renameTarget, data);
            } else {
                AbstractContractRenameTest.assertFalse((boolean)rename);
                ContractTestUtils.verifyFileContents(this.getFileSystem(), renameSrc, data);
            }
        }
        catch (FileNotFoundException e) {
            AbstractContractRenameTest.assertFalse((boolean)renameCreatesDestDirs);
        }
    }

    @Test
    public void testRenameWithNonEmptySubDir() throws Throwable {
        Path renameTestDir = this.path("testRenameWithNonEmptySubDir");
        Path srcDir = new Path(renameTestDir, "src1");
        Path srcSubDir = new Path(srcDir, "sub");
        Path finalDir = new Path(renameTestDir, "dest");
        FileSystem fs = this.getFileSystem();
        boolean renameRemoveEmptyDest = this.isSupported("rename-remove-dest-if-empty-dir");
        ContractTestUtils.rm(fs, renameTestDir, true, false);
        fs.mkdirs(srcDir);
        fs.mkdirs(finalDir);
        ContractTestUtils.writeTextFile(fs, new Path(srcDir, "source.txt"), "this is the file in src dir", false);
        ContractTestUtils.writeTextFile(fs, new Path(srcSubDir, "subfile.txt"), "this is the file in src/sub dir", false);
        this.assertPathExists("not created in src dir", new Path(srcDir, "source.txt"));
        this.assertPathExists("not created in src/sub dir", new Path(srcSubDir, "subfile.txt"));
        fs.rename(srcDir, finalDir);
        if (renameRemoveEmptyDest) {
            this.assertPathExists("not renamed into dest dir", new Path(finalDir, "source.txt"));
            this.assertPathExists("not renamed into dest/sub dir", new Path(finalDir, "sub/subfile.txt"));
        } else {
            this.assertPathExists("not renamed into dest dir", new Path(finalDir, "src1/source.txt"));
            this.assertPathExists("not renamed into dest/sub dir", new Path(finalDir, "src1/sub/subfile.txt"));
        }
        this.assertPathDoesNotExist("not deleted", new Path(srcDir, "source.txt"));
    }
}

