/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;

public abstract class AbstractContractCreateTest
extends AbstractFSContractTestBase {
    public static final int CREATE_TIMEOUT = 15000;

    protected Path path(String filepath, boolean useBuilder) throws IOException {
        return super.path(filepath + (useBuilder ? "" : "-builder"));
    }

    private void testCreateNewFile(boolean useBuilder) throws Throwable {
        this.describe("Foundational 'create a file' test, using builder API=" + useBuilder);
        Path path = this.path("testCreateNewFile", useBuilder);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 0x100000, false, useBuilder);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), path, data);
    }

    @Test
    public void testCreateNewFile() throws Throwable {
        this.testCreateNewFile(true);
        this.testCreateNewFile(false);
    }

    private void testCreateFileOverExistingFileNoOverwrite(boolean useBuilder) throws Throwable {
        this.describe("Verify overwriting an existing file fails, using builder API=" + useBuilder);
        Path path = this.path("testCreateFileOverExistingFileNoOverwrite", useBuilder);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, false);
        byte[] data2 = ContractTestUtils.dataset(10240, 65, 90);
        try {
            ContractTestUtils.writeDataset(this.getFileSystem(), path, data2, data2.length, 1024, false, useBuilder);
            AbstractContractCreateTest.fail((String)"writing without overwrite unexpectedly succeeded");
        }
        catch (FileAlreadyExistsException expected) {
            this.handleExpectedException((Exception)((Object)expected));
        }
        catch (IOException relaxed) {
            this.handleRelaxedException("Creating a file over a file with overwrite==false", "FileAlreadyExistsException", relaxed);
        }
    }

    @Test
    public void testCreateFileOverExistingFileNoOverwrite() throws Throwable {
        this.testCreateFileOverExistingFileNoOverwrite(false);
        this.testCreateFileOverExistingFileNoOverwrite(true);
    }

    private void testOverwriteExistingFile(boolean useBuilder) throws Throwable {
        this.describe("Overwrite an existing file and verify the new data is there, use builder API=" + useBuilder);
        Path path = this.path("testOverwriteExistingFile", useBuilder);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, false, useBuilder);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), path, data);
        byte[] data2 = ContractTestUtils.dataset(10240, 65, 90);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data2, data2.length, 1024, true, useBuilder);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), path, data2);
    }

    @Test
    public void testOverwriteExistingFile() throws Throwable {
        this.testOverwriteExistingFile(false);
        this.testOverwriteExistingFile(true);
    }

    private void testOverwriteEmptyDirectory(boolean useBuilder) throws Throwable {
        this.describe("verify trying to create a file over an empty dir fails, use builder API=" + useBuilder);
        Path path = this.path("testOverwriteEmptyDirectory");
        this.mkdirs(path);
        this.assertIsDirectory(path);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        try {
            ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, true, useBuilder);
            this.assertIsDirectory(path);
            AbstractContractCreateTest.fail((String)"write of file over empty dir succeeded");
        }
        catch (FileAlreadyExistsException expected) {
            this.handleExpectedException((Exception)((Object)expected));
        }
        catch (FileNotFoundException e) {
            this.handleRelaxedException("overwriting a dir with a file ", "FileAlreadyExistsException", e);
        }
        catch (IOException e) {
            this.handleRelaxedException("overwriting a dir with a file ", "FileAlreadyExistsException", e);
        }
        this.assertIsDirectory(path);
    }

    @Test
    public void testOverwriteEmptyDirectory() throws Throwable {
        this.testOverwriteEmptyDirectory(false);
        this.testOverwriteEmptyDirectory(true);
    }

    private void testOverwriteNonEmptyDirectory(boolean useBuilder) throws Throwable {
        this.describe("verify trying to create a file over a non-empty dir fails, use builder API=" + useBuilder);
        Path path = this.path("testOverwriteNonEmptyDirectory");
        this.mkdirs(path);
        try {
            this.assertIsDirectory(path);
        }
        catch (AssertionError failure) {
            if (this.isSupported("create-overwrites-directory")) {
                throw new AssumptionViolatedException(((Throwable)((Object)failure)).toString(), (Throwable)((Object)failure));
            }
            throw failure;
        }
        Path child = new Path(path, "child");
        ContractTestUtils.writeTextFile(this.getFileSystem(), child, "child file", true);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        try {
            ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, true, useBuilder);
            FileStatus status = this.getFileSystem().getFileStatus(path);
            boolean isDir = status.isDirectory();
            if (!isDir && this.isSupported("create-overwrites-directory")) {
                ContractTestUtils.skip("This Filesystem allows a file to overwrite a directory");
            }
            AbstractContractCreateTest.fail((String)"write of file over dir succeeded");
        }
        catch (FileAlreadyExistsException expected) {
            this.handleExpectedException((Exception)((Object)expected));
        }
        catch (FileNotFoundException e) {
            this.handleRelaxedException("overwriting a dir with a file ", "FileAlreadyExistsException", e);
        }
        catch (IOException e) {
            this.handleRelaxedException("overwriting a dir with a file ", "FileAlreadyExistsException", e);
        }
        this.assertIsDirectory(path);
        this.assertIsFile(child);
    }

    @Test
    public void testOverwriteNonEmptyDirectory() throws Throwable {
        this.testOverwriteNonEmptyDirectory(false);
        this.testOverwriteNonEmptyDirectory(true);
    }

    @Test
    public void testCreatedFileIsImmediatelyVisible() throws Throwable {
        this.describe("verify that a newly created file exists as soon as open returns");
        Path path = this.path("testCreatedFileIsImmediatelyVisible");
        try (FSDataOutputStream out = this.getFileSystem().create(path, false, 4096, (short)1, 1024L);){
            if (!this.getFileSystem().exists(path)) {
                if (this.isSupported("create-visibility-delayed")) {
                    ContractTestUtils.skip("This Filesystem delays visibility of newly created files");
                }
                this.assertPathExists("expected path to be visible before anything written", path);
            }
        }
    }

    @Test
    public void testCreatedFileIsVisibleOnFlush() throws Throwable {
        this.describe("verify that a newly created file exists once a flush has taken place");
        Path path = this.path("testCreatedFileIsVisibleOnFlush");
        FileSystem fs = this.getFileSystem();
        try (FSDataOutputStream out = fs.create(path, false, 4096, (short)1, 1024L);){
            out.write(97);
            out.flush();
            if (!fs.exists(path)) {
                if (this.isSupported("is-blobstore")) {
                    ContractTestUtils.skip("Filesystem is an object store and newly created files are not immediately visible");
                }
                this.assertPathExists("expected path to be visible before file closed", path);
            }
        }
    }

    @Test
    public void testCreatedFileIsEventuallyVisible() throws Throwable {
        this.describe("verify a written to file is visible after the stream is closed");
        Path path = this.path("testCreatedFileIsEventuallyVisible");
        FileSystem fs = this.getFileSystem();
        try (FSDataOutputStream out = fs.create(path, false, 4096, (short)1, 1024L);){
            out.write(1);
            out.close();
            ContractTestUtils.getFileStatusEventually(fs, path, 15000);
        }
    }

    @Test
    public void testFileStatusBlocksizeNonEmptyFile() throws Throwable {
        this.describe("validate the block size of a filesystem and files within it");
        FileSystem fs = this.getFileSystem();
        long rootPath = fs.getDefaultBlockSize(this.path("/"));
        AbstractContractCreateTest.assertTrue((String)("Root block size is invalid " + rootPath), (rootPath > 0L ? 1 : 0) != 0);
        Path path = this.path("testFileStatusBlocksizeNonEmptyFile");
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(fs, path, data, data.length, 0x100000, false);
        this.validateBlockSize(fs, path, 1);
    }

    @Test
    public void testFileStatusBlocksizeEmptyFile() throws Throwable {
        this.describe("check that an empty file may return a 0-byte blocksize");
        FileSystem fs = this.getFileSystem();
        Path path = this.path("testFileStatusBlocksizeEmptyFile");
        ContractTestUtils.touch(fs, path);
        this.validateBlockSize(fs, path, 0);
    }

    private void validateBlockSize(FileSystem fs, Path path, int minValue) throws IOException, InterruptedException {
        FileStatus status = ContractTestUtils.getFileStatusEventually(fs, path, 15000);
        String statusDetails = status.toString();
        AbstractContractCreateTest.assertTrue((String)("File status block size too low:  " + statusDetails + " min value: " + minValue), (status.getBlockSize() >= (long)minValue ? 1 : 0) != 0);
        long defaultBlockSize = fs.getDefaultBlockSize(path);
        AbstractContractCreateTest.assertTrue((String)("fs.getDefaultBlockSize(" + path + ") size " + defaultBlockSize + " is below the minimum of " + minValue), (defaultBlockSize >= (long)minValue ? 1 : 0) != 0);
    }

    @Test
    public void testCreateMakesParentDirs() throws Throwable {
        this.describe("check that after creating a file its parent directories exist");
        FileSystem fs = this.getFileSystem();
        Path grandparent = this.path("testCreateCreatesAndPopulatesParents");
        Path parent = new Path(grandparent, "parent");
        Path child = new Path(parent, "child");
        ContractTestUtils.touch(fs, child);
        AbstractContractCreateTest.assertEquals((String)"List status of parent should include the 1 child file", (long)1L, (long)fs.listStatus(parent).length);
        AbstractContractCreateTest.assertTrue((String)"Parent directory does not appear to be a directory", (boolean)fs.getFileStatus(parent).isDirectory());
        AbstractContractCreateTest.assertEquals((String)"List status of grandparent should include the 1 parent dir", (long)1L, (long)fs.listStatus(grandparent).length);
        AbstractContractCreateTest.assertTrue((String)"Grandparent directory does not appear to be a directory", (boolean)fs.getFileStatus(grandparent).isDirectory());
    }
}

