/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallQueueManager;
import org.apache.hadoop.ipc.FairCallQueue;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RpcMultiplexer;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFairCallQueue {
    private FairCallQueue<Schedulable> fcq;

    private Schedulable mockCall(String id, int priority) {
        Schedulable mockCall = (Schedulable)Mockito.mock(Schedulable.class);
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)id);
        Mockito.when((Object)mockCall.getUserGroupInformation()).thenReturn((Object)ugi);
        Mockito.when((Object)mockCall.getPriorityLevel()).thenReturn((Object)priority);
        Mockito.when((Object)mockCall.toString()).thenReturn((Object)("id=" + id + " priority=" + priority));
        return mockCall;
    }

    private Schedulable mockCall(String id) {
        return this.mockCall(id, 0);
    }

    @Before
    public void setUp() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        this.fcq = new FairCallQueue(2, 10, "ns", conf);
    }

    @Test
    public void testTotalCapacityOfSubQueues() {
        Configuration conf = new Configuration();
        FairCallQueue fairCallQueue = new FairCallQueue(1, 1000, "ns", conf);
        Assert.assertEquals((long)fairCallQueue.remainingCapacity(), (long)1000L);
        fairCallQueue = new FairCallQueue(4, 1000, "ns", conf);
        Assert.assertEquals((long)fairCallQueue.remainingCapacity(), (long)1000L);
        fairCallQueue = new FairCallQueue(7, 1000, "ns", conf);
        Assert.assertEquals((long)fairCallQueue.remainingCapacity(), (long)1000L);
        fairCallQueue = new FairCallQueue(1, 1025, "ns", conf);
        Assert.assertEquals((long)fairCallQueue.remainingCapacity(), (long)1025L);
        fairCallQueue = new FairCallQueue(4, 1025, "ns", conf);
        Assert.assertEquals((long)fairCallQueue.remainingCapacity(), (long)1025L);
        fairCallQueue = new FairCallQueue(7, 1025, "ns", conf);
        Assert.assertEquals((long)fairCallQueue.remainingCapacity(), (long)1025L);
    }

    @Test
    public void testPrioritization() {
        int numQueues = 10;
        Configuration conf = new Configuration();
        this.fcq = new FairCallQueue(numQueues, numQueues, "ns", conf);
        ArrayList<Schedulable> calls = new ArrayList<Schedulable>();
        for (int i = 0; i < numQueues; ++i) {
            Schedulable call = this.mockCall("u", i);
            calls.add(call);
            this.fcq.add(call);
        }
        final AtomicInteger currentIndex = new AtomicInteger();
        this.fcq.setMultiplexer(new RpcMultiplexer(){

            public int getAndAdvanceCurrentIndex() {
                return currentIndex.get();
            }
        });
        currentIndex.set(3);
        Assert.assertSame(calls.get(3), (Object)this.fcq.poll());
        Assert.assertSame(calls.get(0), (Object)this.fcq.poll());
        Assert.assertSame(calls.get(1), (Object)this.fcq.poll());
        currentIndex.set(6);
        Assert.assertSame(calls.get(6), (Object)this.fcq.poll());
        Assert.assertSame(calls.get(2), (Object)this.fcq.poll());
        Assert.assertSame(calls.get(4), (Object)this.fcq.poll());
        currentIndex.set(8);
        Assert.assertSame(calls.get(8), (Object)this.fcq.poll());
        currentIndex.set(9);
        Assert.assertSame(calls.get(9), (Object)this.fcq.poll());
        Assert.assertSame(calls.get(5), (Object)this.fcq.poll());
        Assert.assertSame(calls.get(7), (Object)this.fcq.poll());
        Assert.assertNull((Object)this.fcq.poll());
        Assert.assertNull((Object)this.fcq.poll());
    }

    @Test
    public void testInsertion() throws Exception {
        Configuration conf = new Configuration();
        this.fcq = (FairCallQueue)Mockito.spy((Object)new FairCallQueue(3, 6, "ns", conf));
        Schedulable p0 = this.mockCall("a", 0);
        Schedulable p1 = this.mockCall("b", 1);
        Schedulable p2 = this.mockCall("c", 2);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        this.fcq.add(p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p0);
            Assert.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p1);
            Assert.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.ERROR);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p1);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p1);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            this.fcq.add(p2);
            Assert.fail((String)"didn't fail");
        }
        catch (IllegalStateException ise) {
            this.checkOverflowException(ise, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto.FATAL);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(2, p2);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        RuntimeException stopPuts = new RuntimeException();
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            ((FairCallQueue)Mockito.doThrow((Throwable)stopPuts).when(this.fcq)).putQueue(Mockito.anyInt(), (Schedulable)Mockito.anyObject());
            this.fcq.put(p0);
            Assert.fail((String)"didn't fail");
        }
        catch (Exception e) {
            Assert.assertSame((Object)stopPuts, (Object)e);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(0, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).offerQueue(1, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p0);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).putQueue(2, p0);
        Mockito.reset((Object[])new FairCallQueue[]{this.fcq});
        try {
            ((FairCallQueue)Mockito.doThrow((Throwable)stopPuts).when(this.fcq)).putQueue(Mockito.anyInt(), (Schedulable)Mockito.anyObject());
            this.fcq.put(p2);
            Assert.fail((String)"didn't fail");
        }
        catch (Exception e) {
            Assert.assertSame((Object)stopPuts, (Object)e);
        }
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(0, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(1, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)0))).offerQueue(2, p2);
        ((FairCallQueue)Mockito.verify(this.fcq, (VerificationMode)Mockito.times((int)1))).putQueue(2, p2);
    }

    private void checkOverflowException(Exception ex, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto status) {
        Assert.assertTrue((String)(ex.getClass().getName() + " != CallQueueOverflowException"), (boolean)(ex instanceof CallQueueManager.CallQueueOverflowException));
        IOException ioe = ((CallQueueManager.CallQueueOverflowException)((Object)ex)).getCause();
        Assert.assertNotNull((Object)ioe);
        Assert.assertTrue((String)(ioe.getClass().getName() + " != RpcServerException"), (boolean)(ioe instanceof RpcServerException));
        RpcServerException rse = (RpcServerException)ioe;
        Assert.assertEquals((Object)status, (Object)rse.getRpcStatusProto());
        Assert.assertTrue((String)(rse.getClass().getName() + " != RetriableException"), (boolean)(rse.getCause() instanceof RetriableException));
    }

    @Test
    public void testPollReturnsNullWhenEmpty() {
        Assert.assertNull((Object)this.fcq.poll());
    }

    @Test
    public void testPollReturnsTopCallWhenNotEmpty() {
        Schedulable call = this.mockCall("c");
        Assert.assertTrue((boolean)this.fcq.offer(call));
        Assert.assertEquals((Object)call, (Object)this.fcq.poll());
        Assert.assertEquals((long)0L, (long)this.fcq.size());
    }

    @Test
    public void testOfferSucceeds() {
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)this.fcq.offer(this.mockCall("c")));
        }
        Assert.assertEquals((long)5L, (long)this.fcq.size());
    }

    @Test
    public void testOfferFailsWhenFull() {
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)this.fcq.offer(this.mockCall("c")));
        }
        Assert.assertFalse((boolean)this.fcq.offer(this.mockCall("c")));
        Assert.assertEquals((long)5L, (long)this.fcq.size());
    }

    @Test
    public void testOfferSucceedsWhenScheduledLowPriority() {
        int[] mockedPriorities = new int[]{0, 0, 0, 0, 0, 1, 0};
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)this.fcq.offer(this.mockCall("c", mockedPriorities[i])));
        }
        Assert.assertTrue((boolean)this.fcq.offer(this.mockCall("c", mockedPriorities[5])));
        Assert.assertEquals((long)6L, (long)this.fcq.size());
    }

    @Test
    public void testPeekNullWhenEmpty() {
        Assert.assertNull((Object)this.fcq.peek());
    }

    @Test
    public void testPeekNonDestructive() {
        Schedulable call = this.mockCall("c", 0);
        Assert.assertTrue((boolean)this.fcq.offer(call));
        Assert.assertEquals((Object)call, (Object)this.fcq.peek());
        Assert.assertEquals((Object)call, (Object)this.fcq.peek());
        Assert.assertEquals((long)1L, (long)this.fcq.size());
    }

    @Test
    public void testPeekPointsAtHead() {
        Schedulable call = this.mockCall("c", 0);
        Schedulable next = this.mockCall("b", 0);
        this.fcq.offer(call);
        this.fcq.offer(next);
        Assert.assertEquals((Object)call, (Object)this.fcq.peek());
    }

    @Test
    public void testPollTimeout() throws InterruptedException {
        Assert.assertNull((Object)this.fcq.poll(10L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testPollSuccess() throws InterruptedException {
        Schedulable call = this.mockCall("c", 0);
        Assert.assertTrue((boolean)this.fcq.offer(call));
        Assert.assertEquals((Object)call, (Object)this.fcq.poll(10L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)0L, (long)this.fcq.size());
    }

    @Test
    public void testOfferTimeout() throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)this.fcq.offer(this.mockCall("c"), 10L, TimeUnit.MILLISECONDS));
        }
        Assert.assertFalse((boolean)this.fcq.offer(this.mockCall("e"), 10L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)5L, (long)this.fcq.size());
    }

    @Test
    public void testDrainTo() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        FairCallQueue fcq2 = new FairCallQueue(2, 10, "ns", conf);
        for (int i = 0; i < 3; ++i) {
            this.fcq.offer(this.mockCall("c"));
        }
        this.fcq.drainTo((Collection)fcq2);
        Assert.assertEquals((long)0L, (long)this.fcq.size());
        Assert.assertEquals((long)3L, (long)fcq2.size());
    }

    @Test
    public void testDrainToWithLimit() {
        Configuration conf = new Configuration();
        conf.setInt("ns.faircallqueue.priority-levels", 2);
        FairCallQueue fcq2 = new FairCallQueue(2, 10, "ns", conf);
        for (int i = 0; i < 3; ++i) {
            this.fcq.offer(this.mockCall("c"));
        }
        this.fcq.drainTo((Collection)fcq2, 2);
        Assert.assertEquals((long)1L, (long)this.fcq.size());
        Assert.assertEquals((long)2L, (long)fcq2.size());
    }

    @Test
    public void testInitialRemainingCapacity() {
        Assert.assertEquals((long)10L, (long)this.fcq.remainingCapacity());
    }

    @Test
    public void testFirstQueueFullRemainingCapacity() {
        while (this.fcq.offer(this.mockCall("c"))) {
        }
        Assert.assertEquals((long)5L, (long)this.fcq.remainingCapacity());
    }

    @Test
    public void testAllQueuesFullRemainingCapacity() {
        int[] mockedPriorities = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0};
        int i = 0;
        while (this.fcq.offer(this.mockCall("c", mockedPriorities[i++]))) {
        }
        Assert.assertEquals((long)0L, (long)this.fcq.remainingCapacity());
        Assert.assertEquals((long)10L, (long)this.fcq.size());
    }

    @Test
    public void testQueuesPartialFilledRemainingCapacity() {
        int[] mockedPriorities = new int[]{0, 1, 0, 1, 0};
        for (int i = 0; i < 5; ++i) {
            this.fcq.offer(this.mockCall("c", mockedPriorities[i]));
        }
        Assert.assertEquals((long)5L, (long)this.fcq.remainingCapacity());
        Assert.assertEquals((long)5L, (long)this.fcq.size());
    }

    public void assertCanTake(BlockingQueue<Schedulable> cq, int numberOfTakes, int takeAttempts) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(numberOfTakes);
        Taker taker = new Taker(cq, takeAttempts, "default", latch);
        Thread t = new Thread(taker);
        t.start();
        latch.await();
        Assert.assertEquals((long)numberOfTakes, (long)taker.callsTaken);
        t.interrupt();
    }

    public void assertCanPut(BlockingQueue<Schedulable> cq, int numberOfPuts, int putAttempts) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(numberOfPuts);
        Putter putter = new Putter(cq, putAttempts, null, latch);
        Thread t = new Thread(putter);
        t.start();
        latch.await();
        Assert.assertEquals((long)numberOfPuts, (long)putter.callsAdded);
        t.interrupt();
    }

    @Test
    public void testPutOverflows() throws InterruptedException {
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 8, 8);
        Assert.assertEquals((long)8L, (long)this.fcq.size());
    }

    @Test
    public void testPutBlocksWhenAllFull() throws InterruptedException {
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 10, 10);
        Assert.assertEquals((long)10L, (long)this.fcq.size());
        this.assertCanPut((BlockingQueue<Schedulable>)this.fcq, 0, 1);
    }

    @Test
    public void testTakeBlocksWhenEmpty() throws InterruptedException {
        this.assertCanTake((BlockingQueue<Schedulable>)this.fcq, 0, 1);
    }

    @Test
    public void testTakeRemovesCall() throws InterruptedException {
        Schedulable call = this.mockCall("c");
        this.fcq.offer(call);
        Assert.assertEquals((Object)call, (Object)this.fcq.take());
        Assert.assertEquals((long)0L, (long)this.fcq.size());
    }

    @Test
    public void testTakeTriesNextQueue() throws InterruptedException {
        RpcMultiplexer q0mux = (RpcMultiplexer)Mockito.mock(RpcMultiplexer.class);
        Mockito.when((Object)q0mux.getAndAdvanceCurrentIndex()).thenReturn((Object)0);
        this.fcq.setMultiplexer(q0mux);
        Schedulable call = this.mockCall("c", 1);
        this.fcq.put(call);
        Assert.assertEquals((Object)call, (Object)this.fcq.take());
        Assert.assertEquals((long)0L, (long)this.fcq.size());
    }

    @Test
    public void testFairCallQueueMXBean() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=ns,name=FairCallQueue");
        Schedulable call = this.mockCall("c");
        this.fcq.put(call);
        int[] queueSizes = (int[])mbs.getAttribute(mxbeanName, "QueueSizes");
        Assert.assertEquals((long)1L, (long)queueSizes[0]);
        Assert.assertEquals((long)0L, (long)queueSizes[1]);
        this.fcq.take();
        queueSizes = (int[])mbs.getAttribute(mxbeanName, "QueueSizes");
        Assert.assertEquals((long)0L, (long)queueSizes[0]);
        Assert.assertEquals((long)0L, (long)queueSizes[1]);
    }

    public class Taker
    implements Runnable {
        private final BlockingQueue<Schedulable> cq;
        public final String tag;
        public volatile int callsTaken = 0;
        public volatile Schedulable lastResult = null;
        private final int maxCalls;
        private final CountDownLatch latch;
        private IdentityProvider uip;

        public Taker(BlockingQueue<Schedulable> aCq, int maxCalls, String tag, CountDownLatch latch) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
            this.uip = new UserIdentityProvider();
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                while (this.callsTaken < this.maxCalls || this.maxCalls < 0) {
                    Schedulable res = this.cq.take();
                    String identity = this.uip.makeIdentity(res);
                    if (this.tag != null && this.tag.equals(identity)) {
                        this.cq.put(res);
                        continue;
                    }
                    ++this.callsTaken;
                    this.latch.countDown();
                    this.lastResult = res;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public class Putter
    implements Runnable {
        private final BlockingQueue<Schedulable> cq;
        public final String tag;
        public volatile int callsAdded = 0;
        private final int maxCalls;
        private final CountDownLatch latch;

        public Putter(BlockingQueue<Schedulable> aCq, int maxCalls, String tag, CountDownLatch latch) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
            this.latch = latch;
        }

        private String getTag() {
            if (this.tag != null) {
                return this.tag;
            }
            return "";
        }

        @Override
        public void run() {
            try {
                while (this.callsAdded < this.maxCalls || this.maxCalls < 0) {
                    this.cq.put(TestFairCallQueue.this.mockCall(this.getTag()));
                    ++this.callsAdded;
                    this.latch.countDown();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

