/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDiskChecker {
    public static final Logger LOG = LoggerFactory.getLogger(TestDiskChecker.class);
    private final FsPermission defaultPerm = new FsPermission("755");
    private final FsPermission invalidPerm = new FsPermission("000");
    private DiskChecker.FileIoProvider fileIoProvider = null;

    @Before
    public void setup() {
        this.fileIoProvider = DiskChecker.getFileOutputStreamProvider();
    }

    @After
    public void cleanup() {
        DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)this.fileIoProvider);
    }

    @Test(timeout=30000L)
    public void testMkdirs_dirExists() throws Throwable {
        this._mkdirs(true, this.defaultPerm, this.defaultPerm);
    }

    @Test(timeout=30000L)
    public void testMkdirs_noDir() throws Throwable {
        this._mkdirs(false, this.defaultPerm, this.defaultPerm);
    }

    @Test(timeout=30000L)
    public void testMkdirs_dirExists_badUmask() throws Throwable {
        this._mkdirs(true, this.defaultPerm, this.invalidPerm);
    }

    @Test(timeout=30000L)
    public void testMkdirs_noDir_badUmask() throws Throwable {
        this._mkdirs(false, this.defaultPerm, this.invalidPerm);
    }

    private void _mkdirs(boolean exists, FsPermission before, FsPermission after) throws Throwable {
        block4: {
            File localDir = (File)Mockito.mock(File.class);
            Mockito.when((Object)localDir.exists()).thenReturn((Object)exists);
            Mockito.when((Object)localDir.mkdir()).thenReturn((Object)true);
            Path dir = (Path)Mockito.mock(Path.class);
            LocalFileSystem fs = (LocalFileSystem)Mockito.mock(LocalFileSystem.class);
            Mockito.when((Object)fs.pathToFile(dir)).thenReturn((Object)localDir);
            FileStatus stat = (FileStatus)Mockito.mock(FileStatus.class);
            Mockito.when((Object)stat.getPermission()).thenReturn((Object)after);
            Mockito.when((Object)fs.getFileStatus(dir)).thenReturn((Object)stat);
            try {
                DiskChecker.mkdirsWithExistsAndPermissionCheck((LocalFileSystem)fs, (Path)dir, (FsPermission)before);
                if (!exists) {
                    ((LocalFileSystem)Mockito.verify((Object)fs)).setPermission(dir, before);
                } else {
                    ((LocalFileSystem)Mockito.verify((Object)fs)).getFileStatus(dir);
                    ((FileStatus)Mockito.verify((Object)stat)).getPermission();
                }
            }
            catch (DiskChecker.DiskErrorException e) {
                if (before == after) break block4;
                Assert.assertTrue((boolean)e.getMessage().startsWith("Incorrect permission"));
            }
        }
    }

    @Test(timeout=30000L)
    public void testCheckDir_normal() throws Throwable {
        this._checkDirs(true, new FsPermission("755"), true);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notDir() throws Throwable {
        this._checkDirs(false, new FsPermission("000"), false);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notReadable() throws Throwable {
        this._checkDirs(true, new FsPermission("000"), false);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notWritable() throws Throwable {
        this._checkDirs(true, new FsPermission("444"), false);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notListable() throws Throwable {
        this._checkDirs(true, new FsPermission("666"), false);
    }

    protected File createTempFile() throws IOException {
        File testDir = new File(System.getProperty("test.build.data"));
        return Files.createTempFile(testDir.toPath(), "test", "tmp", new FileAttribute[0]).toFile();
    }

    protected File createTempDir() throws IOException {
        File testDir = new File(System.getProperty("test.build.data"));
        return Files.createTempDirectory(testDir.toPath(), "test", new FileAttribute[0]).toFile();
    }

    private void _checkDirs(boolean isDir, FsPermission perm, boolean success) throws Throwable {
        File localDir;
        block2: {
            localDir = isDir ? this.createTempDir() : this.createTempFile();
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)String.format("%04o", perm.toShort()), (boolean)false, (String)localDir.getAbsolutePath()));
            try {
                DiskChecker.checkDir((LocalFileSystem)FileSystem.getLocal((Configuration)new Configuration()), (Path)new Path(localDir.getAbsolutePath()), (FsPermission)perm);
                Assert.assertTrue((String)"checkDir success, expected failure", (boolean)success);
            }
            catch (DiskChecker.DiskErrorException e) {
                if (!success) break block2;
                throw e;
            }
        }
        localDir.delete();
    }

    @Test(timeout=30000L)
    public void testCheckDir_normal_local() throws Throwable {
        this.checkDirs(true, "755", true);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notDir_local() throws Throwable {
        this.checkDirs(false, "000", false);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notReadable_local() throws Throwable {
        this.checkDirs(true, "000", false);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notWritable_local() throws Throwable {
        this.checkDirs(true, "444", false);
    }

    @Test(timeout=30000L)
    public void testCheckDir_notListable_local() throws Throwable {
        this.checkDirs(true, "666", false);
    }

    protected void checkDirs(boolean isDir, String perm, boolean success) throws Throwable {
        File localDir;
        block2: {
            localDir = isDir ? this.createTempDir() : this.createTempFile();
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)perm, (boolean)false, (String)localDir.getAbsolutePath()));
            try {
                DiskChecker.checkDir((File)localDir);
                Assert.assertTrue((String)"checkDir success, expected failure", (boolean)success);
            }
            catch (DiskChecker.DiskErrorException e) {
                if (!success) break block2;
                throw e;
            }
        }
        localDir.delete();
    }

    @Test(timeout=30000L)
    public void testDiskIoIgnoresTransientCreateErrors() throws Throwable {
        DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(2, 0));
        this.checkDirs(true, "755", true);
    }

    @Test(timeout=30000L)
    public void testDiskIoDetectsCreateErrors() throws Throwable {
        DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(3, 0));
        this.checkDirs(true, "755", false);
    }

    @Test(timeout=30000L)
    public void testDiskIoIgnoresTransientWriteErrors() throws Throwable {
        DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(0, 2));
        this.checkDirs(true, "755", true);
    }

    @Test(timeout=30000L)
    public void testDiskIoDetectsWriteErrors() throws Throwable {
        DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(0, 3));
        this.checkDirs(true, "755", false);
    }

    @Test(timeout=30000L)
    public void testDiskIoFileNaming() throws Throwable {
        File rootDir = new File("/");
        Assert.assertTrue((boolean)".001".matches("\\.00\\d$"));
        for (int i = 1; i < 3; ++i) {
            File file = DiskChecker.getFileNameForDiskIoCheck((File)rootDir, (int)i);
            Assert.assertTrue((String)("File name does not match expected pattern: " + file), (boolean)file.toString().matches("^.*\\.[0-9]+$"));
        }
        File guidFile = DiskChecker.getFileNameForDiskIoCheck((File)rootDir, (int)3);
        Assert.assertTrue((String)("File name does not match expected pattern: " + guidFile), (boolean)guidFile.toString().matches("^.*\\.[A-Za-z0-9-]+$"));
    }

    private static class TestFileIoProvider
    implements DiskChecker.FileIoProvider {
        private final AtomicInteger numCreateCalls = new AtomicInteger(0);
        private final AtomicInteger numWriteCalls = new AtomicInteger(0);
        private final int numTimesToThrowOnCreate;
        private final int numTimesToThrowOnWrite;

        public TestFileIoProvider(int numTimesToThrowOnCreate, int numTimesToThrowOnWrite) {
            this.numTimesToThrowOnCreate = numTimesToThrowOnCreate;
            this.numTimesToThrowOnWrite = numTimesToThrowOnWrite;
        }

        public FileOutputStream get(File f) throws FileNotFoundException {
            if (this.numCreateCalls.getAndIncrement() < this.numTimesToThrowOnCreate) {
                throw new FileNotFoundException("Dummy exception for testing");
            }
            return new FileOutputStream(f);
        }

        public void write(FileOutputStream fos, byte[] data) throws IOException {
            if (this.numWriteCalls.getAndIncrement() < this.numTimesToThrowOnWrite) {
                throw new IOException("Dummy exception for testing");
            }
            fos.write(data);
        }
    }
}

