/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.PartHandle;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.UploadHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class MultipartUploader
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(MultipartUploader.class);

    @Override
    public void close() throws IOException {
    }

    public abstract UploadHandle initialize(Path var1) throws IOException;

    public abstract PartHandle putPart(Path var1, InputStream var2, int var3, UploadHandle var4, long var5) throws IOException;

    public abstract PathHandle complete(Path var1, Map<Integer, PartHandle> var2, UploadHandle var3) throws IOException;

    public abstract void abort(Path var1, UploadHandle var2) throws IOException;

    protected void checkUploadId(byte[] uploadId) throws IllegalArgumentException {
        Preconditions.checkArgument((uploadId != null ? 1 : 0) != 0, (Object)"null uploadId");
        Preconditions.checkArgument((uploadId.length > 0 ? 1 : 0) != 0, (Object)"Empty UploadId is not valid");
    }

    protected void checkPartHandles(Map<Integer, PartHandle> partHandles) {
        Preconditions.checkArgument((!partHandles.isEmpty() ? 1 : 0) != 0, (Object)"Empty upload");
        partHandles.keySet().stream().forEach(key -> Preconditions.checkArgument((key > 0 ? 1 : 0) != 0, (String)"Invalid part handle index %s", (Object[])new Object[]{key}));
    }

    protected void checkPutArguments(Path filePath, InputStream inputStream, int partNumber, UploadHandle uploadId, long lengthInBytes) throws IllegalArgumentException {
        Preconditions.checkArgument((filePath != null ? 1 : 0) != 0, (Object)"null filePath");
        Preconditions.checkArgument((inputStream != null ? 1 : 0) != 0, (Object)"null inputStream");
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"Invalid part number: %d", (Object[])new Object[]{partNumber});
        Preconditions.checkArgument((uploadId != null ? 1 : 0) != 0, (Object)"null uploadId");
        Preconditions.checkArgument((lengthInBytes >= 0L ? 1 : 0) != 0, (String)"Invalid part length: %d", (Object[])new Object[]{lengthInBytes});
    }
}

