/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.list;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;

public abstract class OrderedListing
implements RemoteIterator<List<LocatedFileStatus>> {
    public RemoteIterator<LocatedFileStatus> flatten() {
        return new RemoteIterator<LocatedFileStatus>(){
            private Iterator<LocatedFileStatus> pageIterator = Collections.emptyIterator();

            @Override
            public boolean hasNext() throws IOException {
                this.loadNextPageIfNeeded();
                return this.pageIterator.hasNext();
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more files in listing");
                }
                return this.pageIterator.next();
            }

            private void loadNextPageIfNeeded() throws IOException {
                while (!this.pageIterator.hasNext() && OrderedListing.this.hasNext()) {
                    List nextPage = (List)OrderedListing.this.next();
                    this.pageIterator = nextPage.iterator();
                }
            }
        };
    }

    public static OrderedListing of(final @Nonnull Iterator<List<LocatedFileStatus>> pages) {
        Preconditions.checkNotNull(pages, (Object)"pages must not be null");
        return new OrderedListing(){

            @Override
            public boolean hasNext() {
                return pages.hasNext();
            }

            @Override
            public List<LocatedFileStatus> next() {
                return (List)pages.next();
            }
        };
    }
}

