/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.base.Preconditions;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ByteBufferReadable;

@InterfaceStability.Unstable
public final class ByteBufferIOUtils {
    private ByteBufferIOUtils() {
    }

    public static void readFully(InputStream inputStream, ByteBuffer buf, byte[] copyBuffer) throws IOException {
        Preconditions.checkNotNull((Object)buf, (Object)"buf cannot be null");
        Preconditions.checkNotNull((Object)inputStream, (Object)"input Stream cannot be null");
        if (inputStream instanceof ByteBufferReadable) {
            while (buf.hasRemaining()) {
                int readCount = ((ByteBufferReadable)((Object)inputStream)).read(buf);
                if (readCount != -1) continue;
                throw new EOFException("Reached the end of stream. Still have: " + buf.remaining() + " bytes left");
            }
        } else if (buf.hasArray()) {
            ByteBufferIOUtils.readFullyHeapBuffer(inputStream, buf);
        } else {
            ByteBufferIOUtils.readFullyDirectBuffer(inputStream, buf, copyBuffer);
        }
    }

    public static void validateReadIntoBuffers(long position, List<ByteBuffer> byteBuffers) throws EOFException {
        Preconditions.checkNotNull(byteBuffers, (Object)"byteBuffers cannot be empty");
        for (ByteBuffer buffer : byteBuffers) {
            Preconditions.checkNotNull((Object)buffer, (Object)"any buffer in the list cannot be null");
        }
        if (position < 0L) {
            throw new EOFException("position is negative");
        }
    }

    private static void readFullyHeapBuffer(InputStream f, ByteBuffer buf) throws IOException {
        IOUtils.readFully((InputStream)f, (byte[])buf.array(), (int)(buf.arrayOffset() + buf.position()), (int)buf.remaining());
        buf.position(buf.limit());
    }

    private static void readFullyDirectBuffer(InputStream f, ByteBuffer buf, byte[] copyBuffer) throws IOException {
        int nextReadLength = Math.min(buf.remaining(), copyBuffer.length);
        int bytesRead = 0;
        while (nextReadLength > 0 && (bytesRead = f.read(copyBuffer, 0, nextReadLength)) >= 0) {
            buf.put(copyBuffer, 0, bytesRead);
            nextReadLength = Math.min(buf.remaining(), copyBuffer.length);
        }
        if (buf.remaining() > 0) {
            throw new EOFException("Reached the end of stream with " + buf.remaining() + " bytes left to read");
        }
    }
}

