/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.DelegationTokenIssuer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFilterFileSystem {
    private static final Log LOG = FileSystem.LOG;
    private static final Configuration conf = new Configuration();

    @BeforeClass
    public static void setup() {
        conf.set("fs.flfs.impl", FilterLocalFileSystem.class.getName());
        conf.setBoolean("fs.flfs.impl.disable.cache", true);
        conf.setBoolean("fs.file.impl.disable.cache", true);
    }

    @Test
    public void testFilterFileSystem() throws Exception {
        int errors = 0;
        for (Method m : FileSystem.class.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || Modifier.isPrivate(m.getModifiers()) || Modifier.isFinal(m.getModifiers())) continue;
            try {
                MustNotImplement.class.getMethod(m.getName(), m.getParameterTypes());
                try {
                    FilterFileSystem.class.getDeclaredMethod(m.getName(), m.getParameterTypes());
                    LOG.error((Object)("FilterFileSystem MUST NOT implement " + m));
                    ++errors;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (NoSuchMethodException exc) {
                try {
                    FilterFileSystem.class.getDeclaredMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException exc2) {
                    LOG.error((Object)("FilterFileSystem MUST implement " + m));
                    ++errors;
                }
            }
        }
        Assert.assertTrue((String)(errors + " methods were not overridden correctly - see log"), (errors <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFilterEmbedInit() throws Exception {
        FileSystem mockFs = this.createMockFs(false);
        this.checkInit(new FilterFileSystem(mockFs), true);
    }

    @Test
    public void testFilterEmbedNoInit() throws Exception {
        FileSystem mockFs = this.createMockFs(true);
        this.checkInit(new FilterFileSystem(mockFs), false);
    }

    @Test
    public void testLocalEmbedInit() throws Exception {
        FileSystem mockFs = this.createMockFs(false);
        this.checkInit((FilterFileSystem)new LocalFileSystem(mockFs), true);
    }

    @Test
    public void testLocalEmbedNoInit() throws Exception {
        FileSystem mockFs = this.createMockFs(true);
        this.checkInit((FilterFileSystem)new LocalFileSystem(mockFs), false);
    }

    private FileSystem createMockFs(boolean useConf) {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.getUri()).thenReturn((Object)URI.create("mock:/"));
        Mockito.when((Object)mockFs.getConf()).thenReturn(useConf ? conf : null);
        return mockFs;
    }

    @Test
    public void testGetLocalFsSetsConfs() throws Exception {
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        this.checkFsConf((FileSystem)lfs, conf, 2);
    }

    @Test
    public void testGetFilterLocalFsSetsConfs() throws Exception {
        FilterFileSystem flfs = (FilterFileSystem)FileSystem.get((URI)URI.create("flfs:/"), (Configuration)conf);
        this.checkFsConf((FileSystem)flfs, conf, 3);
    }

    @Test
    public void testInitLocalFsSetsConfs() throws Exception {
        LocalFileSystem lfs = new LocalFileSystem();
        this.checkFsConf((FileSystem)lfs, null, 2);
        lfs.initialize(lfs.getUri(), conf);
        this.checkFsConf((FileSystem)lfs, conf, 2);
    }

    @Test
    public void testInitFilterFsSetsEmbedConf() throws Exception {
        LocalFileSystem lfs = new LocalFileSystem();
        this.checkFsConf((FileSystem)lfs, null, 2);
        FilterFileSystem ffs = new FilterFileSystem((FileSystem)lfs);
        Assert.assertEquals((Object)lfs, (Object)ffs.getRawFileSystem());
        this.checkFsConf((FileSystem)ffs, null, 3);
        ffs.initialize(URI.create("filter:/"), conf);
        this.checkFsConf((FileSystem)ffs, conf, 3);
    }

    @Test
    public void testInitFilterLocalFsSetsEmbedConf() throws Exception {
        FilterLocalFileSystem flfs = new FilterLocalFileSystem();
        Assert.assertEquals(LocalFileSystem.class, flfs.getRawFileSystem().getClass());
        this.checkFsConf((FileSystem)flfs, null, 3);
        flfs.initialize(URI.create("flfs:/"), conf);
        this.checkFsConf((FileSystem)flfs, conf, 3);
    }

    @Test
    public void testVerifyChecksumPassthru() {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FilterFileSystem fs = new FilterFileSystem(mockFs);
        fs.setVerifyChecksum(false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setVerifyChecksum(Mockito.eq((boolean)false));
        Mockito.reset((Object[])new FileSystem[]{mockFs});
        fs.setVerifyChecksum(true);
        ((FileSystem)Mockito.verify((Object)mockFs)).setVerifyChecksum(Mockito.eq((boolean)true));
    }

    @Test
    public void testWriteChecksumPassthru() {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FilterFileSystem fs = new FilterFileSystem(mockFs);
        fs.setWriteChecksum(false);
        ((FileSystem)Mockito.verify((Object)mockFs)).setWriteChecksum(Mockito.eq((boolean)false));
        Mockito.reset((Object[])new FileSystem[]{mockFs});
        fs.setWriteChecksum(true);
        ((FileSystem)Mockito.verify((Object)mockFs)).setWriteChecksum(Mockito.eq((boolean)true));
    }

    @Test
    public void testRenameOptions() throws Exception {
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        FilterFileSystem fs = new FilterFileSystem(mockFs);
        Path src = new Path("/src");
        Path dst = new Path("/dest");
        Options.Rename opt = Options.Rename.TO_TRASH;
        fs.rename(src, dst, new Options.Rename[]{opt});
        ((FileSystem)Mockito.verify((Object)mockFs)).rename((Path)Mockito.eq((Object)src), (Path)Mockito.eq((Object)dst), new Options.Rename[]{(Options.Rename)Mockito.eq((Object)opt)});
    }

    private void checkInit(FilterFileSystem fs, boolean expectInit) throws Exception {
        URI uri = URI.create("filter:/");
        fs.initialize(uri, conf);
        FileSystem embedFs = fs.getRawFileSystem();
        if (expectInit) {
            ((FileSystem)Mockito.verify((Object)embedFs, (VerificationMode)Mockito.times((int)1))).initialize((URI)Mockito.eq((Object)uri), (Configuration)Mockito.eq((Object)conf));
        } else {
            ((FileSystem)Mockito.verify((Object)embedFs, (VerificationMode)Mockito.times((int)0))).initialize((URI)Mockito.any(URI.class), (Configuration)Mockito.any(Configuration.class));
        }
    }

    private void checkFsConf(FileSystem fs, Configuration conf, int expectDepth) {
        int depth = 0;
        while (true) {
            Assert.assertFalse((String)("depth " + ++depth + ">" + expectDepth), (depth > expectDepth ? 1 : 0) != 0);
            Assert.assertEquals((Object)conf, (Object)fs.getConf());
            if (!(fs instanceof FilterFileSystem)) break;
            fs = ((FilterFileSystem)fs).getRawFileSystem();
        }
        Assert.assertEquals((long)expectDepth, (long)depth);
    }

    private static class FilterLocalFileSystem
    extends FilterFileSystem {
        FilterLocalFileSystem() {
            super((FileSystem)new LocalFileSystem());
        }
    }

    public static interface MustNotImplement {
        public BlockLocation[] getFileBlockLocations(Path var1, long var2, long var4);

        public FSDataOutputStream append(Path var1) throws IOException;

        public FSDataOutputStream append(Path var1, int var2) throws IOException;

        public long getLength(Path var1);

        public boolean exists(Path var1);

        public boolean isDirectory(Path var1);

        public boolean isFile(Path var1);

        public boolean createNewFile(Path var1);

        public FSDataOutputStream createNonRecursive(Path var1, boolean var2, int var3, short var4, long var5, Progressable var7) throws IOException;

        public FSDataOutputStream createNonRecursive(Path var1, FsPermission var2, boolean var3, int var4, short var5, long var6, Progressable var8) throws IOException;

        public boolean mkdirs(Path var1);

        public FSDataInputStream open(Path var1);

        public FSDataInputStream open(PathHandle var1);

        public FSDataOutputStream create(Path var1);

        public FSDataOutputStream create(Path var1, boolean var2);

        public FSDataOutputStream create(Path var1, Progressable var2);

        public FSDataOutputStream create(Path var1, short var2);

        public FSDataOutputStream create(Path var1, short var2, Progressable var3);

        public FSDataOutputStream create(Path var1, boolean var2, int var3);

        public FSDataOutputStream create(Path var1, boolean var2, int var3, Progressable var4);

        public FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5);

        public FSDataOutputStream create(Path var1, boolean var2, int var3, short var4, long var5, Progressable var7);

        public FSDataOutputStream create(Path var1, FsPermission var2, EnumSet<CreateFlag> var3, int var4, short var5, long var6, Progressable var8);

        public String getName();

        public boolean delete(Path var1);

        public short getReplication(Path var1);

        public void processDeleteOnExit();

        public FsStatus getStatus();

        public FileStatus[] listStatus(Path var1, PathFilter var2);

        public FileStatus[] listStatusBatch(Path var1, byte[] var2);

        public FileStatus[] listStatus(Path[] var1);

        public FileStatus[] listStatus(Path[] var1, PathFilter var2);

        public FileStatus[] globStatus(Path var1);

        public FileStatus[] globStatus(Path var1, PathFilter var2);

        public Iterator<LocatedFileStatus> listFiles(Path var1, boolean var2);

        public void copyFromLocalFile(Path var1, Path var2);

        public void moveFromLocalFile(Path[] var1, Path var2);

        public void moveFromLocalFile(Path var1, Path var2);

        public void copyToLocalFile(Path var1, Path var2);

        public void copyToLocalFile(boolean var1, Path var2, Path var3, boolean var4);

        public void moveToLocalFile(Path var1, Path var2);

        public long getBlockSize(Path var1);

        public FSDataOutputStream primitiveCreate(Path var1, EnumSet<CreateFlag> var2, Options.CreateOpts ... var3);

        public void primitiveMkdir(Path var1, FsPermission var2, boolean var3);

        public int getDefaultPort();

        public String getCanonicalServiceName();

        public Token<?> getDelegationToken(String var1) throws IOException;

        public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException;

        public boolean deleteOnExit(Path var1) throws IOException;

        public boolean cancelDeleteOnExit(Path var1) throws IOException;

        public Token<?>[] addDelegationTokens(String var1, Credentials var2) throws IOException;

        public String getScheme();

        public Path fixRelativePart(Path var1);

        public ContentSummary getContentSummary(Path var1);

        public QuotaUsage getQuotaUsage(Path var1);

        public StorageStatistics getStorageStatistics();
    }
}

