/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.CommandShell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCommandShell {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();

    private String outMsg(String message) {
        return "OUT:\n" + this.outContent.toString() + "\n" + message;
    }

    @Before
    public void setup() throws Exception {
        System.setOut(new PrintStream(this.outContent));
    }

    @Test
    public void testCommandShellExample() throws Exception {
        Example ex = new Example();
        ex.setConf(new Configuration());
        int rc = 0;
        this.outContent.reset();
        String[] args1 = new String[]{"hello"};
        rc = ex.run(args1);
        Assert.assertEquals((String)this.outMsg("test exit code - normal hello"), (long)0L, (long)rc);
        Assert.assertTrue((String)this.outMsg("test normal hello message"), (boolean)this.outContent.toString().contains("hello is running"));
        this.outContent.reset();
        String[] args2 = new String[]{"hello", "x"};
        rc = ex.run(args2);
        Assert.assertEquals((String)this.outMsg("test exit code - bad hello"), (long)1L, (long)rc);
        Assert.assertTrue((String)this.outMsg("test bad hello message"), (boolean)this.outContent.toString().contains("example hello"));
        this.outContent.reset();
        String[] args3 = new String[]{"goodbye"};
        rc = ex.run(args3);
        Assert.assertEquals((String)this.outMsg("test exit code - normal goodbye"), (long)0L, (long)rc);
        Assert.assertTrue((String)this.outMsg("test normal goodbye message"), (boolean)this.outContent.toString().contains("goodbye is running"));
    }

    public class Example
    extends CommandShell {
        public static final String EXAMPLE = "example";
        public static final String HELLO = "hello";
        public static final String HELLO_MSG = "hello is running";
        public static final String GOODBYE = "goodbye";
        public static final String GOODBYE_MSG = "goodbye is running";
        public String[] savedArgs = null;

        protected int init(String[] args) throws Exception {
            String command = args[0];
            if (command.equals(HELLO)) {
                this.setSubCommand(new Hello());
            } else if (command.equals(GOODBYE)) {
                this.setSubCommand(new Goodbye());
            } else {
                return 1;
            }
            this.savedArgs = args;
            return 0;
        }

        public String getCommandUsage() {
            return EXAMPLE;
        }

        public class Goodbye
        extends CommandShell.SubCommand {
            public static final String GOODBYE_USAGE = "example goodbye";

            public Goodbye() {
                super((CommandShell)Example.this);
            }

            public void execute() throws Exception {
                System.out.println(Example.GOODBYE_MSG);
            }

            public String getUsage() {
                return GOODBYE_USAGE;
            }
        }

        public class Hello
        extends CommandShell.SubCommand {
            public static final String HELLO_USAGE = "example hello";

            public Hello() {
                super((CommandShell)Example.this);
            }

            public boolean validate() {
                return Example.this.savedArgs.length == 1;
            }

            public void execute() throws Exception {
                System.out.println(Example.HELLO_MSG);
            }

            public String getUsage() {
                return HELLO_USAGE;
            }
        }
    }
}

