/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import com.google.common.base.Preconditions;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ftp.FTPFileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestFTPFileSystem {
    @Rule
    public Timeout testTimeout = new Timeout(180000);

    @Test
    public void testFTPDefaultPort() throws Exception {
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)21L, (long)ftp.getDefaultPort());
    }

    @Test
    public void testFTPTransferMode() throws Exception {
        Configuration conf = new Configuration();
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)11L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "STREAM_TRANSFER_MODE");
        Assert.assertEquals((long)10L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "COMPRESSED_TRANSFER_MODE");
        Assert.assertEquals((long)12L, (long)ftp.getTransferMode(conf));
        conf.set("fs.ftp.transfer.mode", "invalid");
        Assert.assertEquals((long)11L, (long)ftp.getTransferMode(conf));
    }

    @Test
    public void testFTPDataConnectionMode() throws Exception {
        Configuration conf = new Configuration();
        FTPClient client = new FTPClient();
        FTPFileSystem ftp = new FTPFileSystem();
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        conf.set("fs.ftp.data.connection.mode", "invalid");
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)0L, (long)client.getDataConnectionMode());
        conf.set("fs.ftp.data.connection.mode", "PASSIVE_LOCAL_DATA_CONNECTION_MODE");
        ftp.setDataConnectionMode(client, conf);
        Assert.assertEquals((long)2L, (long)client.getDataConnectionMode());
    }

    @Test
    public void testGetFsAction() {
        FTPFileSystem ftp = new FTPFileSystem();
        int[] accesses = new int[]{0, 1, 2};
        FsAction[] actions = FsAction.values();
        for (int i = 0; i < accesses.length; ++i) {
            for (int j = 0; j < actions.length; ++j) {
                this.enhancedAssertEquals(actions[j], ftp.getFsAction(accesses[i], this.getFTPFileOf(accesses[i], actions[j])));
            }
        }
    }

    private void enhancedAssertEquals(FsAction actionA, FsAction actionB) {
        String notNullErrorMessage = "FsAction cannot be null here.";
        Preconditions.checkNotNull((Object)actionA, (Object)notNullErrorMessage);
        Preconditions.checkNotNull((Object)actionB, (Object)notNullErrorMessage);
        String errorMessageFormat = "expect FsAction is %s, whereas it is %s now.";
        String notEqualErrorMessage = String.format(errorMessageFormat, actionA.name(), actionB.name());
        Assert.assertEquals((String)notEqualErrorMessage, (Object)actionA, (Object)actionB);
    }

    private FTPFile getFTPFileOf(int access, FsAction action) {
        boolean check = access == 0 || access == 1 || access == 2;
        String errorFormat = "access must be in [%d,%d,%d], but it is %d now.";
        String errorMessage = String.format(errorFormat, 0, 1, 2, access);
        Preconditions.checkArgument((boolean)check, (Object)errorMessage);
        Preconditions.checkNotNull((Object)action);
        FTPFile ftpFile = new FTPFile();
        if (action.implies(FsAction.READ)) {
            ftpFile.setPermission(access, 0, true);
        }
        if (action.implies(FsAction.WRITE)) {
            ftpFile.setPermission(access, 1, true);
        }
        if (action.implies(FsAction.EXECUTE)) {
            ftpFile.setPermission(access, 2, true);
        }
        return ftpFile;
    }

    @Test
    public void testFTPSetTimeout() {
        Configuration conf = new Configuration();
        FTPClient client = new FTPClient();
        FTPFileSystem ftp = new FTPFileSystem();
        ftp.setTimeout(client, conf);
        Assert.assertEquals((long)client.getControlKeepAliveTimeout(), (long)0L);
        long timeout = 600L;
        conf.setLong("fs.ftp.timeout", timeout);
        ftp.setTimeout(client, conf);
        Assert.assertEquals((long)client.getControlKeepAliveTimeout(), (long)timeout);
    }
}

