/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFsBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestViewFsWithAuthorityLocalFs
extends ViewFsBaseTest {
    URI schemeWithAuthority;

    @Override
    @Before
    public void setUp() throws Exception {
        this.fcTarget = FileContext.getLocalFSFileContext();
        super.setUp();
        this.schemeWithAuthority = new URI("viewfs", "default", "/", null, null);
        this.fcView = FileContext.getFileContext((URI)this.schemeWithAuthority, (Configuration)this.conf);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    @Test
    public void testBasicPaths() {
        Assert.assertEquals((Object)this.schemeWithAuthority, (Object)this.fcView.getDefaultFileSystem().getUri());
        Assert.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getWorkingDirectory());
        Assert.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getHomeDirectory());
        Assert.assertEquals((Object)new Path("/foo/bar").makeQualified(this.schemeWithAuthority, null), (Object)this.fcView.makeQualified(new Path("/foo/bar")));
    }
}

