/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.SpanReceiver;
import org.junit.Assert;

public class SetSpanReceiver
extends SpanReceiver {
    public SetSpanReceiver(HTraceConfiguration conf) {
    }

    public void receiveSpan(Span span) {
        SetHolder.spans.put(span.getSpanId(), span);
    }

    public void close() {
    }

    public static void clear() {
        SetHolder.spans.clear();
    }

    public static int size() {
        return SetHolder.spans.size();
    }

    public static Collection<Span> getSpans() {
        return SetHolder.spans.values();
    }

    public static Map<String, List<Span>> getMap() {
        return SetHolder.getMap();
    }

    public static void assertSpanNamesFound(final String[] expectedSpanNames) {
        try {
            GenericTestUtils.waitFor(new Supplier<Boolean>(){

                public Boolean get() {
                    Map<String, List<Span>> map = SetHolder.getMap();
                    for (String spanName : expectedSpanNames) {
                        if (map.containsKey(spanName)) continue;
                        return false;
                    }
                    return true;
                }
            }, 100L, 1000L);
        }
        catch (TimeoutException e) {
            Assert.fail((String)("timed out to get expected spans: " + e.getMessage()));
        }
        catch (InterruptedException e) {
            Assert.fail((String)("interrupted while waiting spans: " + e.getMessage()));
        }
    }

    public static class SetHolder {
        public static ConcurrentHashMap<SpanId, Span> spans = new ConcurrentHashMap();

        public static Map<String, List<Span>> getMap() {
            HashMap<String, List<Span>> map = new HashMap<String, List<Span>>();
            for (Span s : spans.values()) {
                LinkedList<Span> l = (LinkedList<Span>)map.get(s.getDescription());
                if (l == null) {
                    l = new LinkedList<Span>();
                    map.put(s.getDescription(), l);
                }
                l.add(s);
            }
            return map;
        }
    }
}

