/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.WhitelistBasedResolver;
import org.apache.hadoop.util.TestFileBasedIPList;
import org.junit.Assert;
import org.junit.Test;

public class TestWhitelistBasedResolver {
    public static final Map<String, String> SASL_PRIVACY_PROPS = WhitelistBasedResolver.getSaslProperties((Configuration)new Configuration());

    @Test
    public void testFixedVariableAndLocalWhiteList() throws IOException {
        String[] fixedIps = new String[]{"10.119.103.112", "10.221.102.0/23"};
        TestFileBasedIPList.createFileWithEntries("fixedwhitelist.txt", fixedIps);
        String[] variableIps = new String[]{"10.222.0.0/16", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("variablewhitelist.txt", variableIps);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.sasl.fixedwhitelist.file", "fixedwhitelist.txt");
        conf.setBoolean("hadoop.security.sasl.variablewhitelist.enable", true);
        conf.setLong("hadoop.security.sasl.variablewhitelist.cache.secs", 1L);
        conf.set("hadoop.security.sasl.variablewhitelist.file", "variablewhitelist.txt");
        WhitelistBasedResolver wqr = new WhitelistBasedResolver();
        wqr.setConf(conf);
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties(InetAddress.getByName("10.119.103.112")));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.119.103.113"));
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties("10.221.103.121"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.221.104.0"));
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties("10.222.103.121"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.223.104.0"));
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties("10.113.221.221"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.113.221.222"));
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties("127.0.0.1"));
        TestFileBasedIPList.removeFile("fixedwhitelist.txt");
        TestFileBasedIPList.removeFile("variablewhitelist.txt");
    }

    @Test
    public void testFixedAndLocalWhiteList() throws IOException {
        String[] fixedIps = new String[]{"10.119.103.112", "10.221.102.0/23"};
        TestFileBasedIPList.createFileWithEntries("fixedwhitelist.txt", fixedIps);
        String[] variableIps = new String[]{"10.222.0.0/16", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("variablewhitelist.txt", variableIps);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.sasl.fixedwhitelist.file", "fixedwhitelist.txt");
        conf.setBoolean("hadoop.security.sasl.variablewhitelist.enable", false);
        conf.setLong("hadoop.security.sasl.variablewhitelist.cache.secs", 100L);
        conf.set("hadoop.security.sasl.variablewhitelist.file", "variablewhitelist.txt");
        WhitelistBasedResolver wqr = new WhitelistBasedResolver();
        wqr.setConf(conf);
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties(InetAddress.getByName("10.119.103.112")));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.119.103.113"));
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties("10.221.103.121"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.221.104.0"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.222.103.121"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.223.104.0"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.113.221.221"));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties("10.113.221.222"));
        Assert.assertEquals((Object)wqr.getDefaultProperties(), (Object)wqr.getServerProperties("127.0.0.1"));
        TestFileBasedIPList.removeFile("fixedwhitelist.txt");
        TestFileBasedIPList.removeFile("variablewhitelist.txt");
    }

    @Test
    public void testNullIPAddress() throws IOException {
        String[] fixedIps = new String[]{"10.119.103.112", "10.221.102.0/23"};
        TestFileBasedIPList.createFileWithEntries("fixedwhitelist.txt", fixedIps);
        String[] variableIps = new String[]{"10.222.0.0/16", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("variablewhitelist.txt", variableIps);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.sasl.fixedwhitelist.file", "fixedwhitelist.txt");
        conf.setBoolean("hadoop.security.sasl.variablewhitelist.enable", true);
        conf.setLong("hadoop.security.sasl.variablewhitelist.cache.secs", 100L);
        conf.set("hadoop.security.sasl.variablewhitelist.file", "variablewhitelist.txt");
        WhitelistBasedResolver wqr = new WhitelistBasedResolver();
        wqr.setConf(conf);
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties((InetAddress)null));
        Assert.assertEquals(SASL_PRIVACY_PROPS, (Object)wqr.getServerProperties((String)null));
        TestFileBasedIPList.removeFile("fixedwhitelist.txt");
        TestFileBasedIPList.removeFile("variablewhitelist.txt");
    }
}

