/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hadoop.fs.impl.FutureIOSupport;
import org.apache.hadoop.fs.statistics.DurationStatisticSummary;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.StubDurationTrackerFactory;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.FunctionRaisingIOE;
import org.apache.hadoop.util.functional.FutureIO;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDurationTracking
extends AbstractHadoopTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestDurationTracking.class);
    private static final String REQUESTS = "requests";
    public static final String UNKNOWN = "unknown";
    private IOStatisticsStore stats;
    private final AtomicInteger invocationCounter = new AtomicInteger(0);

    @Before
    public void setup() {
        this.stats = IOStatisticsBinding.iostatisticsStore().withDurationTracking(new String[]{REQUESTS}).build();
    }

    @After
    public void teardown() {
        LOG.info("stats {}", (Object)this.stats);
    }

    @Test
    public void testDurationTryWithResources() throws Throwable {
        DurationTracker tracker = this.stats.trackDuration(REQUESTS);
        IOStatisticAssertions.verifyStatisticCounterValue((IOStatistics)this.stats, REQUESTS, 1L);
        this.sleep();
        tracker.close();
        try (DurationTracker ignored = this.stats.trackDuration(REQUESTS);){
            this.sleep();
        }
        LOG.info("Statistics: {}", (Object)this.stats);
        DurationStatisticSummary summary = DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS);
        this.assertSummaryValues(summary, 2, 1, 1);
        this.assertSummaryMean(summary, 2, 0.0);
    }

    public void sleep() {
        this.sleepf(10);
    }

    protected int sleepf(int millis) {
        this.invocationCounter.incrementAndGet();
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return millis;
    }

    private void assertCounterValue(int expected) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.invocationCounter.get()).describedAs("Sleep invocation Counter", new Object[0])).isEqualTo(expected);
    }

    @Test
    public void testDurationFunctionIOE() throws Throwable {
        FunctionRaisingIOE fn = IOStatisticsBinding.trackFunctionDuration((DurationTrackerFactory)this.stats, (String)REQUESTS, x -> this.invocationCounter.getAndSet((int)x));
        Assertions.assertThat((Integer)((Integer)fn.apply((Object)1))).isEqualTo(0);
        this.assertCounterValue(1);
        this.assertSummaryValues(DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS), 1, 0, 0);
    }

    @Test
    public void testDurationFunctionIOEFailure() throws Throwable {
        FunctionRaisingIOE fn = IOStatisticsBinding.trackFunctionDuration((DurationTrackerFactory)this.stats, (String)REQUESTS, x -> {
            this.sleep();
            return 100 / x;
        });
        LambdaTestUtils.intercept(ArithmeticException.class, () -> (Integer)fn.apply((Object)0));
        this.assertSummaryValues(DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS), 1, -1, -1);
        DurationStatisticSummary failures = DurationStatisticSummary.fetchDurationSummary((IOStatistics)this.stats, (String)REQUESTS, (boolean)false);
        this.assertSummaryValues(failures, 1, 0, 0);
        this.assertSummaryMean(failures, 1, 0.0);
    }

    @Test
    public void testDurationJavaFunctionFailure() throws Throwable {
        Function fn = IOStatisticsBinding.trackJavaFunctionDuration((DurationTrackerFactory)this.stats, (String)REQUESTS, x -> 100 / x);
        LambdaTestUtils.intercept(ArithmeticException.class, () -> (Integer)fn.apply(0));
        this.assertSummaryValues(DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS), 1, -1, -1);
        DurationStatisticSummary failures = DurationStatisticSummary.fetchDurationSummary((IOStatistics)this.stats, (String)REQUESTS, (boolean)false);
        this.assertSummaryValues(failures, 1, 0, 0);
    }

    @Test
    public void testCallableDuration() throws Throwable {
        Assertions.assertThat((Integer)((Integer)IOStatisticsBinding.trackDurationOfCallable((DurationTrackerFactory)this.stats, (String)REQUESTS, () -> this.sleepf(100)).call())).isEqualTo(100);
        DurationStatisticSummary summary = DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS);
        this.assertSummaryValues(summary, 1, 0, 0);
        this.assertSummaryMean(summary, 1, 0.0);
    }

    @Test
    public void testCallableFailureDuration() throws Throwable {
        LambdaTestUtils.intercept(RuntimeException.class, IOStatisticsBinding.trackDurationOfCallable((DurationTrackerFactory)this.stats, (String)REQUESTS, () -> {
            this.sleepf(100);
            throw new RuntimeException("oops");
        }));
        this.assertCounterValue(1);
        this.assertSummaryValues(DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS), 1, -1, -1);
        this.assertSummaryValues(DurationStatisticSummary.fetchDurationSummary((IOStatistics)this.stats, (String)REQUESTS, (boolean)false), 1, 0, 0);
    }

    @Test
    public void testInvocationDuration() throws Throwable {
        IOStatisticsBinding.trackDurationOfInvocation((DurationTrackerFactory)this.stats, (String)REQUESTS, () -> this.sleepf(100));
        this.assertCounterValue(1);
        DurationStatisticSummary summary = DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS);
        this.assertSummaryValues(summary, 1, 0, 0);
        this.assertSummaryMean(summary, 1, 0.0);
    }

    @Test
    public void testCallableIOEDuration() throws Throwable {
        Assertions.assertThat((Integer)((Integer)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.stats, (String)REQUESTS, () -> this.sleepf(100)))).isEqualTo(100);
        DurationStatisticSummary summary = DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS);
        this.assertSummaryValues(summary, 1, 0, 0);
        this.assertSummaryMean(summary, 1, 0.0);
    }

    @Test
    public void testCallableIOEFailureDuration() throws Throwable {
        LambdaTestUtils.intercept(IOException.class, () -> IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.stats, (String)REQUESTS, () -> {
            this.sleepf(100);
            throw new IOException("oops");
        }));
        this.assertSummaryValues(DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)REQUESTS), 1, -1, -1);
        this.assertSummaryValues(DurationStatisticSummary.fetchDurationSummary((IOStatistics)this.stats, (String)REQUESTS, (boolean)false), 1, 0, 0);
    }

    @Test
    public void testDurationThroughEval() throws Throwable {
        CompletableFuture eval = FutureIOSupport.eval((CallableRaisingIOE)IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.stats, (String)REQUESTS, () -> {
            this.sleepf(100);
            throw new FileNotFoundException("oops");
        }));
        LambdaTestUtils.intercept(FileNotFoundException.class, "oops", () -> FutureIO.awaitFuture((Future)eval));
        this.assertSummaryValues(DurationStatisticSummary.fetchDurationSummary((IOStatistics)this.stats, (String)REQUESTS, (boolean)false), 1, 0, 0);
    }

    @Test
    public void testUnknownDuration() throws Throwable {
        IOStatisticsBinding.trackDurationOfCallable((DurationTrackerFactory)this.stats, (String)UNKNOWN, () -> this.sleepf(1)).call();
        DurationStatisticSummary summary = DurationStatisticSummary.fetchSuccessSummary((IOStatistics)this.stats, (String)UNKNOWN);
        this.assertSummaryValues(summary, 0, -1, -1);
        Assertions.assertThat((Object)summary.getMean()).isNull();
    }

    @Test
    public void testTrackDurationWithStubFactory() throws Throwable {
        IOStatisticsBinding.trackDuration((DurationTrackerFactory)StubDurationTrackerFactory.STUB_DURATION_TRACKER_FACTORY, (String)UNKNOWN, () -> this.sleepf(1));
    }

    @Test
    public void testStubDurationLifecycle() throws Throwable {
        DurationTracker tracker = StubDurationTrackerFactory.STUB_DURATION_TRACKER_FACTORY.trackDuration("k", 1L);
        tracker.failed();
        tracker.close();
        tracker.close();
    }

    protected void assertSummaryValues(DurationStatisticSummary summary, int count, int minBase, int maxBase) {
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)summary).matches(s -> s.getCount() == (long)count, "Count value")).matches(s -> s.getMax() >= (long)maxBase, "Max value")).matches(s -> s.getMin() >= (long)minBase, "Min value");
    }

    protected void assertSummaryMean(DurationStatisticSummary summary, int expectedSampleCount, double meanGreaterThan) {
        String description = "mean of " + summary;
        ((ObjectAssert)Assertions.assertThat((Object)summary.getMean()).describedAs(description, new Object[0])).isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)summary.getMean().getSamples()).describedAs(description, new Object[0])).isEqualTo((long)expectedSampleCount);
        ((AbstractDoubleAssert)Assertions.assertThat((double)summary.getMean().mean()).describedAs(description, new Object[0])).isGreaterThan(meanGreaterThan);
    }
}

