/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.LambdaUtils;
import org.junit.Before;
import org.junit.Test;

public class TestFutureIO
extends HadoopTestBase {
    private ThreadLocal<AtomicInteger> local;

    @Before
    public void setup() throws Exception {
        this.local = ThreadLocal.withInitial(() -> new AtomicInteger(1));
    }

    @Test
    public void testEvalInCurrentThread() throws Throwable {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture eval = LambdaUtils.eval(result, () -> this.getLocal().addAndGet(2));
        TestFutureIO.assertEquals((String)"Thread local value", (long)3L, (long)this.getLocalValue());
        TestFutureIO.assertEquals((String)"Evaluated Value", (long)3L, (long)((Integer)eval.get()).intValue());
    }

    @Test
    public void testEvalAsync() throws Throwable {
        CompletableFuture<Integer> eval = CompletableFuture.supplyAsync(() -> this.getLocal().addAndGet(2));
        TestFutureIO.assertEquals((String)"Thread local value", (long)1L, (long)this.getLocalValue());
        TestFutureIO.assertEquals((String)"Evaluated Value", (long)3L, (long)eval.get().intValue());
    }

    protected AtomicInteger getLocal() {
        return this.local.get();
    }

    protected int getLocalValue() {
        return this.local.get().get();
    }
}

