/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestExitUtil
extends AbstractHadoopTestBase {
    @Before
    public void before() {
        ExitUtil.disableSystemExit();
        ExitUtil.disableSystemHalt();
        ExitUtil.resetFirstExitException();
        ExitUtil.resetFirstHaltException();
    }

    @After
    public void after() {
        ExitUtil.resetFirstExitException();
        ExitUtil.resetFirstHaltException();
    }

    @Test
    public void testGetSetExitExceptions() throws Throwable {
        ExitUtil.ExitException ee1 = new ExitUtil.ExitException(1, "TestExitUtil forged 1st ExitException");
        ExitUtil.ExitException ee2 = new ExitUtil.ExitException(2, "TestExitUtil forged 2nd ExitException");
        Assert.assertFalse((String)"ExitUtil.terminateCalled initial value should be false", (boolean)ExitUtil.terminateCalled());
        Assert.assertNull((String)"ExitUtil.getFirstExitException initial value should be null", (Object)ExitUtil.getFirstExitException());
        ExitUtil.ExitException ee = LambdaTestUtils.intercept(ExitUtil.ExitException.class, () -> ExitUtil.terminate((ExitUtil.ExitException)ee1));
        Assert.assertSame((String)"ExitUtil.terminate should have rethrown its ExitException argument but it had thrown something else", (Object)ee1, (Object)ee);
        Assert.assertTrue((String)"ExitUtil.terminateCalled should be true after 1st ExitUtil.terminate call", (boolean)ExitUtil.terminateCalled());
        Assert.assertSame((String)"ExitUtil.terminate should store its 1st call's ExitException", (Object)ee1, (Object)ExitUtil.getFirstExitException());
        ee = LambdaTestUtils.intercept(ExitUtil.ExitException.class, () -> ExitUtil.terminate((ExitUtil.ExitException)ee2));
        Assert.assertSame((String)"ExitUtil.terminate should have rethrown its HaltException argument but it had thrown something else", (Object)ee2, (Object)ee);
        Assert.assertTrue((String)"ExitUtil.terminateCalled should still be true after 2nd ExitUtil.terminate call", (boolean)ExitUtil.terminateCalled());
        Assert.assertSame((String)"ExitUtil.terminate when called twice should only remember 1st call's ExitException", (Object)ee1, (Object)ExitUtil.getFirstExitException());
        ExitUtil.resetFirstExitException();
        Assert.assertFalse((String)"ExitUtil.terminateCalled should be false after ExitUtil.resetFirstExitException call", (boolean)ExitUtil.terminateCalled());
        Assert.assertNull((String)"ExitUtil.getFirstExitException should be null after ExitUtil.resetFirstExitException call", (Object)ExitUtil.getFirstExitException());
    }

    @Test
    public void testGetSetHaltExceptions() throws Throwable {
        ExitUtil.disableSystemHalt();
        ExitUtil.resetFirstHaltException();
        ExitUtil.HaltException he1 = new ExitUtil.HaltException(1, "TestExitUtil forged 1st HaltException");
        ExitUtil.HaltException he2 = new ExitUtil.HaltException(2, "TestExitUtil forged 2nd HaltException");
        Assert.assertFalse((String)"ExitUtil.haltCalled initial value should be false", (boolean)ExitUtil.haltCalled());
        Assert.assertNull((String)"ExitUtil.getFirstHaltException initial value should be null", (Object)ExitUtil.getFirstHaltException());
        ExitUtil.HaltException he = LambdaTestUtils.intercept(ExitUtil.HaltException.class, () -> ExitUtil.halt((ExitUtil.HaltException)he1));
        Assert.assertSame((String)"ExitUtil.halt should have rethrown its HaltException argument but it had thrown something else", (Object)he1, (Object)he);
        Assert.assertTrue((String)"ExitUtil.haltCalled should be true after 1st ExitUtil.halt call", (boolean)ExitUtil.haltCalled());
        Assert.assertSame((String)"ExitUtil.halt should store its 1st call's HaltException", (Object)he1, (Object)ExitUtil.getFirstHaltException());
        he = LambdaTestUtils.intercept(ExitUtil.HaltException.class, () -> ExitUtil.halt((ExitUtil.HaltException)he2));
        Assert.assertSame((String)"ExitUtil.halt should have rethrown its HaltException argument but it had thrown something else", (Object)he2, (Object)he);
        Assert.assertTrue((String)"ExitUtil.haltCalled should still be true after 2nd ExitUtil.halt call", (boolean)ExitUtil.haltCalled());
        Assert.assertSame((String)"ExitUtil.halt when called twice should only remember 1st call's HaltException", (Object)he1, (Object)ExitUtil.getFirstHaltException());
        ExitUtil.resetFirstHaltException();
        Assert.assertFalse((String)"ExitUtil.haltCalled should be false after ExitUtil.resetFirstHaltException call", (boolean)ExitUtil.haltCalled());
        Assert.assertNull((String)"ExitUtil.getFirstHaltException should be null after ExitUtil.resetFirstHaltException call", (Object)ExitUtil.getFirstHaltException());
    }
}

