/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.channels.ClosedChannelException;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.CloseableReferenceCount;
import org.junit.Test;

public class TestCloseableReferenceCount
extends HadoopTestBase {
    @Test
    public void testReference() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.reference();
        TestCloseableReferenceCount.assertEquals((String)"Incorrect reference count", (long)1L, (long)clr.getReferenceCount());
    }

    @Test
    public void testUnreference() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.reference();
        clr.reference();
        TestCloseableReferenceCount.assertFalse((String)"New reference count should not equal STATUS_CLOSED_MASK", (boolean)clr.unreference());
        TestCloseableReferenceCount.assertEquals((String)"Incorrect reference count", (long)1L, (long)clr.getReferenceCount());
    }

    @Test
    public void testUnreferenceCheckClosed() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.reference();
        clr.reference();
        clr.unreferenceCheckClosed();
        TestCloseableReferenceCount.assertEquals((String)"Incorrect reference count", (long)1L, (long)clr.getReferenceCount());
    }

    @Test
    public void testSetClosed() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        TestCloseableReferenceCount.assertTrue((String)"Reference count should be open", (boolean)clr.isOpen());
        clr.setClosed();
        TestCloseableReferenceCount.assertFalse((String)"Reference count should be closed", (boolean)clr.isOpen());
    }

    @Test(expected=ClosedChannelException.class)
    public void testReferenceClosedReference() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.setClosed();
        TestCloseableReferenceCount.assertFalse((String)"Reference count should be closed", (boolean)clr.isOpen());
        clr.reference();
    }

    @Test(expected=ClosedChannelException.class)
    public void testUnreferenceClosedReference() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        clr.reference();
        clr.setClosed();
        TestCloseableReferenceCount.assertFalse((String)"Reference count should be closed", (boolean)clr.isOpen());
        clr.unreferenceCheckClosed();
    }

    @Test(expected=ClosedChannelException.class)
    public void testDoubleClose() throws ClosedChannelException {
        CloseableReferenceCount clr = new CloseableReferenceCount();
        TestCloseableReferenceCount.assertTrue((String)"Reference count should be open", (boolean)clr.isOpen());
        clr.setClosed();
        TestCloseableReferenceCount.assertFalse((String)"Reference count should be closed", (boolean)clr.isOpen());
        clr.setClosed();
    }
}

