/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import org.apache.hadoop.fs.ByteBufferPositionedReadable;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.VectoredReadUtils;
import org.apache.hadoop.fs.impl.CombinedFileRange;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.MoreAsserts;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestVectoredReadUtils
extends HadoopTestBase {
    @Test
    public void testSliceTo() {
        int size = 65536;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        IntBuffer intBuffer = buffer.asIntBuffer();
        for (int i = 0; i < 16384; ++i) {
            intBuffer.put(i);
        }
        ByteBuffer slice = VectoredReadUtils.sliceTo((ByteBuffer)buffer, (long)100L, (FileRange)FileRange.createFileRange((long)100L, (int)65536));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buffer).describedAs("Slicing on the same offset shouldn't create a new buffer", new Object[0])).isEqualTo((Object)slice);
        int offset = 100;
        int sliceStart = 1024;
        int sliceLength = 16384;
        slice = VectoredReadUtils.sliceTo((ByteBuffer)buffer, (long)100L, (FileRange)FileRange.createFileRange((long)1124L, (int)16384));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buffer).describedAs("Slicing on new offset should create a new buffer", new Object[0])).isNotEqualTo((Object)slice);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])buffer.array()).describedAs("Slicing should use the same underlying data", new Object[0])).isEqualTo((Object)slice.array());
        intBuffer = slice.asIntBuffer();
        for (int i = 0; i < 4096; ++i) {
            TestVectoredReadUtils.assertEquals((String)("i = " + i), (long)(i + 256), (long)intBuffer.get());
        }
    }

    @Test
    public void testRounding() {
        for (int i = 5; i < 10; ++i) {
            TestVectoredReadUtils.assertEquals((String)("i = " + i), (long)5L, (long)VectoredReadUtils.roundDown((long)i, (int)5));
            TestVectoredReadUtils.assertEquals((String)("i = " + i), (long)10L, (long)VectoredReadUtils.roundUp((long)(i + 1), (int)5));
        }
        TestVectoredReadUtils.assertEquals((String)"Error while roundDown", (long)13L, (long)VectoredReadUtils.roundDown((long)13L, (int)1));
        TestVectoredReadUtils.assertEquals((String)"Error while roundUp", (long)13L, (long)VectoredReadUtils.roundUp((long)13L, (int)1));
    }

    @Test
    public void testMerge() {
        FileRange base = FileRange.createFileRange((long)2000L, (int)1000);
        CombinedFileRange mergeBase = new CombinedFileRange(2000L, 3000L, base);
        TestVectoredReadUtils.assertFalse((String)"Large gap ranges shouldn't get merged", (boolean)mergeBase.merge(5000L, 6000L, FileRange.createFileRange((long)5000L, (int)1000), 2000, 4000));
        TestVectoredReadUtils.assertEquals((String)"Number of ranges in merged range shouldn't increase", (long)1L, (long)mergeBase.getUnderlying().size());
        TestVectoredReadUtils.assertEquals((String)"post merge offset", (long)2000L, (long)mergeBase.getOffset());
        TestVectoredReadUtils.assertEquals((String)"post merge length", (long)1000L, (long)mergeBase.getLength());
        TestVectoredReadUtils.assertFalse((String)"Large size ranges shouldn't get merged", (boolean)mergeBase.merge(5000L, 6000L, FileRange.createFileRange((long)5000L, (int)1000), 2001, 3999));
        TestVectoredReadUtils.assertEquals((String)"Number of ranges in merged range shouldn't increase", (long)1L, (long)mergeBase.getUnderlying().size());
        TestVectoredReadUtils.assertEquals((String)"post merge offset", (long)2000L, (long)mergeBase.getOffset());
        TestVectoredReadUtils.assertEquals((String)"post merge length", (long)1000L, (long)mergeBase.getLength());
        TestVectoredReadUtils.assertTrue((String)"ranges should get merged ", (boolean)mergeBase.merge(5000L, 6000L, FileRange.createFileRange((long)5000L, (int)1000), 2001, 4000));
        TestVectoredReadUtils.assertEquals((String)"post merge size", (long)2L, (long)mergeBase.getUnderlying().size());
        TestVectoredReadUtils.assertEquals((String)"post merge offset", (long)2000L, (long)mergeBase.getOffset());
        TestVectoredReadUtils.assertEquals((String)"post merge length", (long)4000L, (long)mergeBase.getLength());
        mergeBase = new CombinedFileRange(200L, 300L, base);
        TestVectoredReadUtils.assertEquals((long)200L, (long)mergeBase.getOffset());
        TestVectoredReadUtils.assertEquals((long)100L, (long)mergeBase.getLength());
        TestVectoredReadUtils.assertTrue((String)"ranges should get merged ", (boolean)mergeBase.merge(500L, 600L, FileRange.createFileRange((long)5000L, (int)1000), 201, 400));
        TestVectoredReadUtils.assertEquals((String)"post merge size", (long)2L, (long)mergeBase.getUnderlying().size());
        TestVectoredReadUtils.assertEquals((String)"post merge offset", (long)200L, (long)mergeBase.getOffset());
        TestVectoredReadUtils.assertEquals((String)"post merge length", (long)400L, (long)mergeBase.getLength());
    }

    @Test
    public void testSortAndMerge() {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)3000L, (int)100), FileRange.createFileRange((long)2100L, (int)100), FileRange.createFileRange((long)1000L, (int)100));
        TestVectoredReadUtils.assertFalse((String)"Ranges are non disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint(input, (int)100, (int)800));
        List outputList = VectoredReadUtils.mergeSortedRanges(Arrays.asList(VectoredReadUtils.sortRanges(input)), (int)100, (int)1001, (int)2500);
        ((ListAssert)Assertions.assertThat((List)outputList).describedAs("merged range size", new Object[0])).hasSize(1);
        CombinedFileRange output = (CombinedFileRange)outputList.get(0);
        ((ListAssert)Assertions.assertThat((List)output.getUnderlying()).describedAs("merged range underlying size", new Object[0])).hasSize(3);
        TestVectoredReadUtils.assertEquals((Object)"range[1000,3100)", (Object)output.toString());
        TestVectoredReadUtils.assertTrue((String)"merged output ranges are disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint((List)outputList, (int)100, (int)800));
        TestVectoredReadUtils.assertFalse((String)"Ranges are non disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint(input, (int)100, (int)1000));
        outputList = VectoredReadUtils.mergeSortedRanges(Arrays.asList(VectoredReadUtils.sortRanges(input)), (int)100, (int)1000, (int)2100);
        ((ListAssert)Assertions.assertThat((List)outputList).describedAs("merged range size", new Object[0])).hasSize(2);
        TestVectoredReadUtils.assertEquals((Object)"range[1000,1100)", (Object)((CombinedFileRange)outputList.get(0)).toString());
        TestVectoredReadUtils.assertEquals((Object)"range[2100,3100)", (Object)((CombinedFileRange)outputList.get(1)).toString());
        TestVectoredReadUtils.assertTrue((String)"merged output ranges are disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint((List)outputList, (int)100, (int)1000));
        TestVectoredReadUtils.assertFalse((String)"Ranges are non disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint(input, (int)100, (int)800));
        outputList = VectoredReadUtils.mergeSortedRanges(Arrays.asList(VectoredReadUtils.sortRanges(input)), (int)100, (int)1001, (int)2099);
        ((ListAssert)Assertions.assertThat((List)outputList).describedAs("merged range size", new Object[0])).hasSize(2);
        TestVectoredReadUtils.assertEquals((Object)"range[1000,2200)", (Object)((CombinedFileRange)outputList.get(0)).toString());
        TestVectoredReadUtils.assertEquals((Object)"range[3000,3100)", (Object)((CombinedFileRange)outputList.get(1)).toString());
        TestVectoredReadUtils.assertTrue((String)"merged output ranges are disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint((List)outputList, (int)100, (int)800));
        TestVectoredReadUtils.assertFalse((String)"Ranges are non disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint(input, (int)16, (int)700));
        outputList = VectoredReadUtils.mergeSortedRanges(Arrays.asList(VectoredReadUtils.sortRanges(input)), (int)16, (int)1001, (int)100);
        ((ListAssert)Assertions.assertThat((List)outputList).describedAs("merged range size", new Object[0])).hasSize(3);
        TestVectoredReadUtils.assertEquals((Object)"range[992,1104)", (Object)((CombinedFileRange)outputList.get(0)).toString());
        TestVectoredReadUtils.assertEquals((Object)"range[2096,2208)", (Object)((CombinedFileRange)outputList.get(1)).toString());
        TestVectoredReadUtils.assertEquals((Object)"range[2992,3104)", (Object)((CombinedFileRange)outputList.get(2)).toString());
        TestVectoredReadUtils.assertTrue((String)"merged output ranges are disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint((List)outputList, (int)16, (int)700));
    }

    @Test
    public void testSortAndMergeMoreCases() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)3000L, (int)110), FileRange.createFileRange((long)3000L, (int)100), FileRange.createFileRange((long)2100L, (int)100), FileRange.createFileRange((long)1000L, (int)100));
        TestVectoredReadUtils.assertFalse((String)"Ranges are non disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint(input, (int)100, (int)800));
        List outputList = VectoredReadUtils.mergeSortedRanges(Arrays.asList(VectoredReadUtils.sortRanges(input)), (int)1, (int)1001, (int)2500);
        ((ListAssert)Assertions.assertThat((List)outputList).describedAs("merged range size", new Object[0])).hasSize(1);
        CombinedFileRange output = (CombinedFileRange)outputList.get(0);
        ((ListAssert)Assertions.assertThat((List)output.getUnderlying()).describedAs("merged range underlying size", new Object[0])).hasSize(4);
        TestVectoredReadUtils.assertEquals((Object)"range[1000,3110)", (Object)output.toString());
        TestVectoredReadUtils.assertTrue((String)"merged output ranges are disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint((List)outputList, (int)1, (int)800));
        outputList = VectoredReadUtils.mergeSortedRanges(Arrays.asList(VectoredReadUtils.sortRanges(input)), (int)100, (int)1001, (int)2500);
        ((ListAssert)Assertions.assertThat((List)outputList).describedAs("merged range size", new Object[0])).hasSize(1);
        output = (CombinedFileRange)outputList.get(0);
        ((ListAssert)Assertions.assertThat((List)output.getUnderlying()).describedAs("merged range underlying size", new Object[0])).hasSize(4);
        TestVectoredReadUtils.assertEquals((Object)"range[1000,3200)", (Object)output.toString());
        TestVectoredReadUtils.assertTrue((String)"merged output ranges are disjoint", (boolean)VectoredReadUtils.isOrderedDisjoint((List)outputList, (int)1, (int)800));
    }

    @Test
    public void testValidateOverlappingRanges() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)100L, (int)100), FileRange.createFileRange((long)200L, (int)100), FileRange.createFileRange((long)250L, (int)100));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> VectoredReadUtils.validateNonOverlappingAndReturnSortedRanges((List)input));
        List<FileRange> input1 = Arrays.asList(FileRange.createFileRange((long)100L, (int)100), FileRange.createFileRange((long)500L, (int)100), FileRange.createFileRange((long)1000L, (int)100), FileRange.createFileRange((long)1000L, (int)100));
        LambdaTestUtils.intercept(UnsupportedOperationException.class, () -> VectoredReadUtils.validateNonOverlappingAndReturnSortedRanges((List)input1));
        List<FileRange> input2 = Arrays.asList(FileRange.createFileRange((long)100L, (int)100), FileRange.createFileRange((long)200L, (int)100), FileRange.createFileRange((long)300L, (int)100));
        VectoredReadUtils.validateNonOverlappingAndReturnSortedRanges(input2);
    }

    @Test
    public void testMaxSizeZeroDisablesMering() throws Exception {
        List<FileRange> randomRanges = Arrays.asList(FileRange.createFileRange((long)3000L, (int)110), FileRange.createFileRange((long)3000L, (int)100), FileRange.createFileRange((long)2100L, (int)100));
        this.assertEqualRangeCountsAfterMerging(randomRanges, 1, 1, 0);
        this.assertEqualRangeCountsAfterMerging(randomRanges, 1, 0, 0);
        this.assertEqualRangeCountsAfterMerging(randomRanges, 1, 100, 0);
    }

    private void assertEqualRangeCountsAfterMerging(List<FileRange> inputRanges, int chunkSize, int minimumSeek, int maxSize) {
        List combinedFileRanges = VectoredReadUtils.mergeSortedRanges(inputRanges, (int)chunkSize, (int)minimumSeek, (int)maxSize);
        ((ListAssert)Assertions.assertThat((List)combinedFileRanges).describedAs("Mismatch in number of ranges post merging", new Object[0])).hasSize(inputRanges.size());
    }

    static void fillBuffer(ByteBuffer buffer) {
        byte b = 0;
        while (buffer.remaining() > 0) {
            byte by = b;
            b = (byte)(b + 1);
            buffer.put(by);
        }
    }

    @Test
    public void testReadRangeFromByteBufferPositionedReadable() throws Exception {
        Stream stream = (Stream)Mockito.mock(Stream.class);
        ((Stream)Mockito.doAnswer(invocation -> {
            TestVectoredReadUtils.fillBuffer((ByteBuffer)invocation.getArgument(1));
            return null;
        }).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        CompletableFuture result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), ByteBuffer::allocate);
        MoreAsserts.assertFutureCompletedSuccessfully(result);
        ByteBuffer buffer = (ByteBuffer)result.get();
        TestVectoredReadUtils.assertEquals((String)"Size of result buffer", (long)100L, (long)buffer.remaining());
        int b = 0;
        while (buffer.remaining() > 0) {
            int n = b;
            b = (byte)(b + 1);
            TestVectoredReadUtils.assertEquals((String)("remain = " + buffer.remaining()), (long)n, (long)buffer.get());
        }
        Mockito.reset((Object[])new Stream[]{stream});
        ((Stream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("foo")}).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), ByteBuffer::allocate);
        MoreAsserts.assertFutureFailedExceptionally(result);
    }

    static void runReadRangeFromPositionedReadable(IntFunction<ByteBuffer> allocate) throws Exception {
        PositionedReadable stream = (PositionedReadable)Mockito.mock(PositionedReadable.class);
        ((PositionedReadable)Mockito.doAnswer(invocation -> {
            int b = 0;
            byte[] buffer = (byte[])invocation.getArgument(1);
            for (int i = 0; i < buffer.length; ++i) {
                int n = b;
                b = (byte)(b + 1);
                buffer[i] = n;
            }
            return null;
        }).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        CompletableFuture result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), allocate);
        MoreAsserts.assertFutureCompletedSuccessfully(result);
        ByteBuffer buffer = (ByteBuffer)result.get();
        TestVectoredReadUtils.assertEquals((String)"Size of result buffer", (long)100L, (long)buffer.remaining());
        int b = 0;
        while (buffer.remaining() > 0) {
            int n = b;
            b = (byte)(b + 1);
            TestVectoredReadUtils.assertEquals((String)("remain = " + buffer.remaining()), (long)n, (long)buffer.get());
        }
        Mockito.reset((Object[])new PositionedReadable[]{stream});
        ((PositionedReadable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("foo")}).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), ByteBuffer::allocate);
        MoreAsserts.assertFutureFailedExceptionally(result);
    }

    @Test
    public void testReadRangeArray() throws Exception {
        TestVectoredReadUtils.runReadRangeFromPositionedReadable(ByteBuffer::allocate);
    }

    @Test
    public void testReadRangeDirect() throws Exception {
        TestVectoredReadUtils.runReadRangeFromPositionedReadable(ByteBuffer::allocateDirect);
    }

    static void validateBuffer(String message, ByteBuffer buffer, int start) {
        byte expected = (byte)start;
        while (buffer.remaining() > 0) {
            byte by = expected;
            expected = (byte)(expected + 1);
            TestVectoredReadUtils.assertEquals((String)(message + " remain: " + buffer.remaining()), (long)by, (long)buffer.get());
        }
    }

    @Test
    public void testReadVectored() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)0L, (int)100), FileRange.createFileRange((long)100000L, (int)100), FileRange.createFileRange((long)200000L, (int)100));
        this.runAndValidateVectoredRead(input);
    }

    @Test
    public void testReadVectoredZeroBytes() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)0L, (int)0), FileRange.createFileRange((long)100000L, (int)100), FileRange.createFileRange((long)200000L, (int)0));
        this.runAndValidateVectoredRead(input);
    }

    private void runAndValidateVectoredRead(List<FileRange> input) throws Exception {
        Stream stream = (Stream)Mockito.mock(Stream.class);
        ((Stream)Mockito.doAnswer(invocation -> {
            TestVectoredReadUtils.fillBuffer((ByteBuffer)invocation.getArgument(1));
            return null;
        }).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        VectoredReadUtils.readVectored((PositionedReadable)stream, input, ByteBuffer::allocate);
        ((Stream)Mockito.verify((Object)stream, (VerificationMode)Mockito.times((int)3))).readFully(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        for (int b = 0; b < input.size(); ++b) {
            TestVectoredReadUtils.validateBuffer("buffer " + b, (ByteBuffer)input.get(b).getData().get(), 0);
        }
    }

    static interface Stream
    extends PositionedReadable,
    ByteBufferPositionedReadable {
    }
}

