/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.AfterClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractStreamIOStatisticsTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractStreamIOStatisticsTest.class);
    protected static final IOStatisticsSnapshot FILESYSTEM_IOSTATS = IOStatisticsSupport.snapshotIOStatistics();

    @Override
    public void teardown() throws Exception {
        FileSystem fs = this.getFileSystem();
        if (fs instanceof IOStatisticsSource) {
            FILESYSTEM_IOSTATS.aggregate(((IOStatisticsSource)fs).getIOStatistics());
        }
        super.teardown();
    }

    @AfterClass
    public static void dumpFileSystemIOStatistics() {
        if (!FILESYSTEM_IOSTATS.counters().isEmpty()) {
            LOG.info("Aggregate FileSystem Statistics {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString((IOStatistics)FILESYSTEM_IOSTATS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutputStreamStatisticKeys() throws Throwable {
        this.describe("Look at the statistic keys of an output stream");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(path.getParent());
        try (FSDataOutputStream out = fs.create(path, true);){
            IOStatistics statistics = IOStatisticAssertions.extractStatistics(out);
            List<String> keys = this.outputStreamStatisticKeys();
            ((IterableAssert)Assertions.assertThat(statistics.counters().keySet()).describedAs("statistic keys of %s", new Object[]{statistics})).containsAll(keys);
            ((ListAssert)Assertions.assertThat(keys).describedAs("Statistics supported by the stream %s", new Object[]{out})).contains((Object[])new String[]{"stream_write_bytes"});
        }
        finally {
            fs.delete(path, false);
        }
    }

    public boolean streamWritesInBlocks() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteSingleByte() throws Throwable {
        this.describe("Write a byte to a file and verify the stream statistics are updated");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(path.getParent());
        boolean writesInBlocks = this.streamWritesInBlocks();
        try (FSDataOutputStream out = fs.create(path, true);){
            IOStatistics statistics = IOStatisticAssertions.extractStatistics(out);
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_write_bytes", 0L);
            out.write(48);
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_write_bytes", writesInBlocks ? 0L : 1L);
            out.close();
            statistics = IOStatisticAssertions.extractStatistics(out);
            String strVal = statistics.toString();
            LOG.info("Statistics = {}", (Object)strVal);
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_write_bytes", 1L);
        }
        finally {
            fs.delete(path, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteByteArrays() throws Throwable {
        this.describe("Write byte arrays to a file and verify the stream statistics are updated");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(path.getParent());
        boolean writesInBlocks = this.streamWritesInBlocks();
        try (FSDataOutputStream out = fs.create(path, true);){
            Object demandStatsString = IOStatisticsLogging.demandStringifyIOStatisticsSource((IOStatisticsSource)out);
            byte[] bytes = ContractTestUtils.toAsciiByteArray("statistically-speaking");
            long len = bytes.length;
            out.write(bytes);
            out.flush();
            LOG.info("stats {}", demandStatsString);
            IOStatistics statistics = IOStatisticAssertions.extractStatistics(out);
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_write_bytes", writesInBlocks ? 0L : len);
            out.write(bytes);
            out.flush();
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_write_bytes", writesInBlocks ? 0L : len * 2L);
            out.close();
            LOG.info("stats {}", demandStatsString);
            statistics = IOStatisticAssertions.extractStatistics(out);
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_write_bytes", len * 2L);
            Assertions.assertThat((String)demandStatsString.toString()).contains(new CharSequence[]{Long.toString(len * 2L)});
        }
        finally {
            fs.delete(path, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInputStreamStatisticKeys() throws Throwable {
        this.describe("Look at the statistic keys of an input stream");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.touch(fs, path);
        try (FSDataInputStream in = fs.open(path);){
            IOStatistics statistics = IOStatisticAssertions.extractStatistics(in);
            List<String> keys = this.inputStreamStatisticKeys();
            ((IterableAssert)Assertions.assertThat(statistics.counters().keySet()).describedAs("statistic keys of %s", new Object[]{statistics})).containsAll(keys);
            ((ListAssert)Assertions.assertThat(keys).describedAs("Statistics supported by the stream %s", new Object[]{in})).contains((Object[])new String[]{"stream_read_bytes"});
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_read_bytes", 0L);
        }
        finally {
            fs.delete(path, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInputStreamStatisticRead() throws Throwable {
        this.describe("Read Data from an input stream");
        Path path = this.methodPath();
        FileSystem fs = this.getFileSystem();
        int fileLen = 1024;
        byte[] ds = ContractTestUtils.dataset(1024, 97, 26);
        ContractTestUtils.writeDataset(fs, path, ds, 1024, 8000, true);
        try (FSDataInputStream in = fs.open(path);){
            long current = 0L;
            IOStatistics statistics = IOStatisticAssertions.extractStatistics(in);
            IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_read_bytes", 0L);
            Assertions.assertThat((int)in.read()).isEqualTo(97);
            int bufferSize = this.readBufferSize();
            current = this.verifyBytesRead(statistics, current, 1, bufferSize);
            int bufferLen = 128;
            byte[] buf128 = new byte[128];
            in.read(buf128);
            current = this.verifyBytesRead(statistics, current, 128, bufferSize);
            in.readFully(buf128);
            current = this.verifyBytesRead(statistics, current, 128, bufferSize);
            in.readFully(0L, buf128);
            current = this.verifyBytesRead(statistics, current, 128, bufferSize);
            in.seek(256L);
            this.verifyBytesRead(statistics, current, 0, bufferSize);
            int sublen = 32;
            Assertions.assertThat((int)in.read(buf128, 0, 32)).isEqualTo(32);
            current = this.verifyBytesRead(statistics, current, 32, bufferSize);
            if (bufferSize == 0) {
                int pos = 992;
                in.seek(992L);
                ((AbstractIntegerAssert)Assertions.assertThat((int)in.read(buf128)).describedAs("Read overlapping EOF", new Object[0])).isEqualTo(32);
                current = IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_read_bytes", current + 32L);
                ((AbstractIntegerAssert)Assertions.assertThat((int)in.read(992L, buf128, 0, 128)).describedAs("Read(buffer) overlapping EOF", new Object[0])).isEqualTo(32);
                IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_read_bytes", current + 32L);
            }
        }
        finally {
            fs.delete(path, false);
        }
    }

    public long verifyBytesRead(IOStatistics statistics, long current, int bytesRead, int bufferSize) {
        long finalPos;
        long expected = finalPos = current + (long)bytesRead;
        if (bufferSize > 0) {
            expected = (long)bufferSize * (1L + current / (long)bufferSize);
        }
        IOStatisticAssertions.verifyStatisticCounterValue(statistics, "stream_read_bytes", expected);
        return finalPos;
    }

    public int readBufferSize() {
        return 0;
    }

    public List<String> outputStreamStatisticKeys() {
        return Collections.singletonList("stream_write_bytes");
    }

    public List<String> inputStreamStatisticKeys() {
        return Collections.singletonList("stream_read_bytes");
    }
}

