/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.sink.StatsDSink;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestStatsDMetrics {
    private AbstractMetric makeMetric(String name, Number value, MetricType type) {
        AbstractMetric metric = (AbstractMetric)Mockito.mock(AbstractMetric.class);
        Mockito.when((Object)metric.name()).thenReturn((Object)name);
        Mockito.when((Object)metric.value()).thenReturn((Object)value);
        Mockito.when((Object)metric.type()).thenReturn((Object)type);
        return metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testPutMetrics() throws IOException, IllegalAccessException {
        StatsDSink sink = new StatsDSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, "host"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "jvm"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.ProcessName, "process"));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1.25, MetricType.COUNTER));
        metrics.add(this.makeMetric("foo2", 2.25, MetricType.GAUGE));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        try (DatagramSocket sock = new DatagramSocket();){
            sock.setReceiveBufferSize(8192);
            StatsDSink.StatsD mockStatsD = new StatsDSink.StatsD(sock.getLocalAddress().getHostName(), sock.getLocalPort());
            sink.setStatsd(mockStatsD);
            DatagramPacket p = new DatagramPacket(new byte[8192], 8192);
            sink.putMetrics((MetricsRecord)record);
            sock.receive(p);
            String result = new String(p.getData(), 0, p.getLength(), Charset.forName("UTF-8"));
            Assert.assertTrue((String)"Received data did not match data sent", (result.equals("host.process.jvm.Context.foo1:1.25|c") || result.equals("host.process.jvm.Context.foo2:2.25|g") ? 1 : 0) != 0);
        }
        finally {
            sink.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=3000L)
    public void testPutMetrics2() throws IOException, IllegalAccessException {
        StatsDSink sink = new StatsDSink();
        ArrayList<MetricsTag> tags = new ArrayList<MetricsTag>();
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Hostname, null));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.Context, "jvm"));
        tags.add(new MetricsTag((MetricsInfo)MsInfo.ProcessName, "process"));
        HashSet<AbstractMetric> metrics = new HashSet<AbstractMetric>();
        metrics.add(this.makeMetric("foo1", 1, MetricType.COUNTER));
        metrics.add(this.makeMetric("foo2", 2, MetricType.GAUGE));
        MetricsRecordImpl record = new MetricsRecordImpl((MetricsInfo)MsInfo.Context, 10000L, tags, metrics);
        try (DatagramSocket sock = new DatagramSocket();){
            sock.setReceiveBufferSize(8192);
            StatsDSink.StatsD mockStatsD = new StatsDSink.StatsD(sock.getLocalAddress().getHostName(), sock.getLocalPort());
            sink.setStatsd(mockStatsD);
            DatagramPacket p = new DatagramPacket(new byte[8192], 8192);
            sink.putMetrics((MetricsRecord)record);
            sock.receive(p);
            String result = new String(p.getData(), 0, p.getLength(), Charset.forName("UTF-8"));
            Assert.assertTrue((String)"Received data did not match data sent", (result.equals("process.jvm.Context.foo1:1|c") || result.equals("process.jvm.Context.foo2:2|g") ? 1 : 0) != 0);
        }
        finally {
            sink.close();
        }
    }
}

