/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;

class DiffInfo {
    static final Comparator<DiffInfo> sourceComparator = new Comparator<DiffInfo>(){

        @Override
        public int compare(DiffInfo d1, DiffInfo d2) {
            return d2.source.compareTo((Object)d1.source);
        }
    };
    static final Comparator<DiffInfo> targetComparator = new Comparator<DiffInfo>(){

        @Override
        public int compare(DiffInfo d1, DiffInfo d2) {
            return d1.target == null ? -1 : (d2.target == null ? 1 : d1.target.compareTo((Object)d2.target));
        }
    };
    final Path source;
    private Path tmp;
    final Path target;

    DiffInfo(Path source, Path target) {
        assert (source != null);
        this.source = source;
        this.target = target;
    }

    void setTmp(Path tmp) {
        this.tmp = tmp;
    }

    Path getTmp() {
        return this.tmp;
    }

    static DiffInfo[] getDiffs(SnapshotDiffReport report, Path targetDir) {
        ArrayList<DiffInfo> diffs = new ArrayList<DiffInfo>();
        for (SnapshotDiffReport.DiffReportEntry entry : report.getDiffList()) {
            Path source;
            if (entry.getType() == SnapshotDiffReport.DiffType.DELETE) {
                source = new Path(targetDir, DFSUtil.bytes2String((byte[])entry.getSourcePath()));
                diffs.add(new DiffInfo(source, null));
                continue;
            }
            if (entry.getType() != SnapshotDiffReport.DiffType.RENAME) continue;
            source = new Path(targetDir, DFSUtil.bytes2String((byte[])entry.getSourcePath()));
            Path target = new Path(targetDir, DFSUtil.bytes2String((byte[])entry.getTargetPath()));
            diffs.add(new DiffInfo(source, target));
        }
        return diffs.toArray(new DiffInfo[diffs.size()]);
    }
}

