/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.DataInput;
import java.io.DataOutput;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.junit.Assert;
import org.junit.Test;

public class TestCopyListingFileStatus {
    @Test
    public void testCopyListingFileStatusSerialization() throws Exception {
        CopyListingFileStatus src = new CopyListingFileStatus(4344L, false, 2, 0x20000000L, 1234L, 5678L, new FsPermission(330), "dingo", "yaks", new Path("hdfs://localhost:4344"));
        DataOutputBuffer dob = new DataOutputBuffer();
        src.write((DataOutput)dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        CopyListingFileStatus dst = new CopyListingFileStatus();
        dst.readFields((DataInput)dib);
        Assert.assertEquals((Object)src, (Object)dst);
    }

    @Test
    public void testFileStatusEquality() throws Exception {
        FileStatus stat = new FileStatus(4344L, false, 2, 0x20000000L, 1234L, 5678L, new FsPermission(330), "dingo", "yaks", new Path("hdfs://localhost:4344/foo/bar/baz"));
        CopyListingFileStatus clfs = new CopyListingFileStatus(stat);
        Assert.assertEquals((long)stat.getLen(), (long)clfs.getLen());
        Assert.assertEquals((Object)stat.isDirectory(), (Object)clfs.isDirectory());
        Assert.assertEquals((long)stat.getReplication(), (long)clfs.getReplication());
        Assert.assertEquals((long)stat.getBlockSize(), (long)clfs.getBlockSize());
        Assert.assertEquals((long)stat.getAccessTime(), (long)clfs.getAccessTime());
        Assert.assertEquals((long)stat.getModificationTime(), (long)clfs.getModificationTime());
        Assert.assertEquals((Object)stat.getPermission(), (Object)clfs.getPermission());
        Assert.assertEquals((Object)stat.getOwner(), (Object)clfs.getOwner());
        Assert.assertEquals((Object)stat.getGroup(), (Object)clfs.getGroup());
        Assert.assertEquals((Object)stat.getPath(), (Object)clfs.getPath());
        Assert.assertEquals((Object)stat.isErasureCoded(), (Object)clfs.isErasureCoded());
    }
}

