/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.CommonJobTest;
import org.apache.hadoop.mapred.gridmix.DebugJobProducer;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.GridmixJobSubmissionPolicy;
import org.apache.hadoop.mapred.gridmix.GridmixTestUtils;
import org.apache.hadoop.mapred.gridmix.JobCreator;
import org.apache.hadoop.mapred.gridmix.SleepJob;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSleepJob
extends CommonJobTest {
    public static final Log LOG = LogFactory.getLog(Gridmix.class);
    static GridmixJobSubmissionPolicy policy;

    @BeforeClass
    public static void init() throws IOException {
        GridmixTestUtils.initCluster(TestSleepJob.class);
    }

    @AfterClass
    public static void shutDown() throws IOException {
        GridmixTestUtils.shutdownCluster();
    }

    @Test(timeout=500000L)
    public void testMapTasksOnlySleepJobs() throws Exception {
        JobStory story;
        Configuration configuration = GridmixTestUtils.mrvl.getConfig();
        DebugJobProducer jobProducer = new DebugJobProducer(5, configuration);
        configuration.setBoolean("gridmix.sleep.maptask-only", true);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        int seq = 1;
        while ((story = jobProducer.getNextJob()) != null) {
            GridmixJob gridmixJob = JobCreator.SLEEPJOB.createGridmixJob(configuration, 0L, story, new Path("ignored"), ugi, seq++);
            gridmixJob.buildSplits(null);
            Job job = (Job)gridmixJob.call();
            Assert.assertEquals((long)0L, (long)job.getNumReduceTasks());
        }
        jobProducer.close();
        Assert.assertEquals((long)6L, (long)seq);
    }

    @Test(timeout=100000L)
    public void testRandomLocation() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        this.testRandomLocation(1, 10, ugi);
        this.testRandomLocation(2, 10, ugi);
    }

    @Test(timeout=500000L)
    public void testSerialSubmit() throws Exception {
        policy = GridmixJobSubmissionPolicy.SERIAL;
        LOG.info((Object)("Serial started at " + System.currentTimeMillis()));
        this.doSubmission(JobCreator.SLEEPJOB.name(), false);
        LOG.info((Object)("Serial ended at " + System.currentTimeMillis()));
    }

    @Test(timeout=500000L)
    public void testReplaySubmit() throws Exception {
        policy = GridmixJobSubmissionPolicy.REPLAY;
        LOG.info((Object)(" Replay started at " + System.currentTimeMillis()));
        this.doSubmission(JobCreator.SLEEPJOB.name(), false);
        LOG.info((Object)(" Replay ended at " + System.currentTimeMillis()));
    }

    @Test(timeout=500000L)
    public void testStressSubmit() throws Exception {
        policy = GridmixJobSubmissionPolicy.STRESS;
        LOG.info((Object)(" Replay started at " + System.currentTimeMillis()));
        this.doSubmission(JobCreator.SLEEPJOB.name(), false);
        LOG.info((Object)(" Replay ended at " + System.currentTimeMillis()));
    }

    private void testRandomLocation(int locations, int njobs, UserGroupInformation ugi) throws Exception {
        JobStory story;
        Configuration configuration = new Configuration();
        DebugJobProducer jobProducer = new DebugJobProducer(njobs, configuration);
        Configuration jconf = GridmixTestUtils.mrvl.getConfig();
        jconf.setInt("gridmix.sleep.fake-locations", locations);
        int seq = 1;
        while ((story = jobProducer.getNextJob()) != null) {
            GridmixJob gridmixJob = JobCreator.SLEEPJOB.createGridmixJob(jconf, 0L, story, new Path("ignored"), ugi, seq++);
            gridmixJob.buildSplits(null);
            List splits = new SleepJob.SleepInputFormat().getSplits((JobContext)gridmixJob.getJob());
            for (InputSplit split : splits) {
                Assert.assertEquals((long)locations, (long)split.getLocations().length);
            }
        }
        jobProducer.close();
    }

    static {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.mapred.gridmix")).getLogger().setLevel(Level.DEBUG);
        policy = GridmixJobSubmissionPolicy.REPLAY;
    }
}

