/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix.emulators.resourceusage;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.Progressive;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.ResourceUsageEmulatorPlugin;
import org.apache.hadoop.mapreduce.util.ResourceCalculatorPlugin;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;

public class CumulativeCpuUsageEmulatorPlugin
implements ResourceUsageEmulatorPlugin {
    protected CpuUsageEmulatorCore emulatorCore;
    private ResourceCalculatorPlugin monitor;
    private Progressive progress;
    private boolean enabled = true;
    private float emulationInterval;
    private long targetCpuUsage = 0L;
    private float lastSeenProgress = 0.0f;
    private long lastSeenCpuUsageCpuUsage = 0L;
    public static final String CPU_EMULATION_PROGRESS_INTERVAL = "gridmix.emulators.resource-usage.cpu.emulation-interval";
    private static final float DEFAULT_EMULATION_FREQUENCY = 0.1f;

    public CumulativeCpuUsageEmulatorPlugin() {
        this(new DefaultCpuUsageEmulator());
    }

    public CumulativeCpuUsageEmulatorPlugin(CpuUsageEmulatorCore core) {
        this.emulatorCore = core;
    }

    private float getWeightForProgressInterval(float progress) {
        return progress * progress * progress * progress;
    }

    @Override
    public void emulate() throws IOException, InterruptedException {
        float currentProgress;
        if (this.enabled && this.lastSeenProgress < (currentProgress = this.progress.getProgress()) && (currentProgress - this.lastSeenProgress >= this.emulationInterval || currentProgress == 1.0f)) {
            float rate;
            long currentCpuUsage = this.monitor.getProcResourceValues().getCumulativeCpuTime();
            long projectedUsage = currentCpuUsage + (long)((1.0f - currentProgress) * (rate = (float)(currentCpuUsage - this.lastSeenCpuUsageCpuUsage) / (currentProgress - this.lastSeenProgress)));
            if (projectedUsage < this.targetCpuUsage) {
                long currentWeighedTarget = (long)((float)this.targetCpuUsage * this.getWeightForProgressInterval(currentProgress));
                while (this.monitor.getProcResourceValues().getCumulativeCpuTime() < currentWeighedTarget) {
                    this.emulatorCore.compute();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        String message = "CumulativeCpuUsageEmulatorPlugin got interrupted. Exiting.";
                        throw new RuntimeException(message);
                    }
                }
            }
            this.lastSeenProgress = this.progress.getProgress();
            this.lastSeenCpuUsageCpuUsage = this.monitor.getProcResourceValues().getCumulativeCpuTime();
        }
    }

    @Override
    public void initialize(Configuration conf, ResourceUsageMetrics metrics, ResourceCalculatorPlugin monitor, Progressive progress) {
        this.targetCpuUsage = metrics.getCumulativeCpuUsage();
        if (this.targetCpuUsage <= 0L) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        this.monitor = monitor;
        this.progress = progress;
        this.emulationInterval = conf.getFloat(CPU_EMULATION_PROGRESS_INTERVAL, 0.1f);
        this.emulatorCore.calibrate(monitor, this.targetCpuUsage);
        this.lastSeenProgress = 0.0f;
        this.lastSeenCpuUsageCpuUsage = 0L;
    }

    public static class DefaultCpuUsageEmulator
    implements CpuUsageEmulatorCore {
        private int numIterations;
        private final Random random;
        protected double returnValue;

        public DefaultCpuUsageEmulator() {
            this(-1);
        }

        DefaultCpuUsageEmulator(int numIterations) {
            this.numIterations = numIterations;
            this.random = new Random();
        }

        @Override
        public void compute() {
            for (int i = 0; i < this.numIterations; ++i) {
                this.performUnitComputation();
            }
        }

        protected void performUnitComputation() {
            int randomData = this.random.nextInt();
            int randomDataCube = randomData * randomData * randomData;
            double randomDataCubeRoot = Math.cbrt(randomData);
            this.returnValue = Math.log(Math.tan(randomDataCubeRoot * Math.exp(randomDataCube)) * Math.sqrt(randomData));
        }

        @Override
        public void calibrate(ResourceCalculatorPlugin monitor, long totalCpuUsage) {
            long initTime = monitor.getProcResourceValues().getCumulativeCpuTime();
            long defaultLoopSize = 0L;
            long finalTime = initTime;
            while (finalTime - initTime < 100L) {
                ++defaultLoopSize;
                this.performUnitComputation();
                finalTime = monitor.getProcResourceValues().getCumulativeCpuTime();
            }
            long referenceRuntime = finalTime - initTime;
            float timePerLoop = (float)referenceRuntime / (float)defaultLoopSize;
            long onePercent = totalCpuUsage / 100L;
            this.numIterations = Math.max(1, (int)((float)onePercent / timePerLoop));
            System.out.println("Calibration done. Basic computation runtime : " + timePerLoop + " milliseconds. Optimal number of iterations (1%): " + this.numIterations);
        }
    }

    public static interface CpuUsageEmulatorCore {
        public void compute();

        public void calibrate(ResourceCalculatorPlugin var1, long var2);
    }
}

