/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapred.gridmix.StressJobFactory;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.tools.rumen.JobStoryProducer;

public class StressJobFactory
extends JobFactory<Statistics.ClusterStats> {
    public static final Log LOG = LogFactory.getLog(StressJobFactory.class);
    private final LoadStatus loadStatus = new LoadStatus();
    private static final float OVERLOAD_MAPTASK_MAPSLOT_RATIO = 2.0f;
    public static final String CONF_OVERLOAD_MAPTASK_MAPSLOT_RATIO = "gridmix.throttle.maps.task-to-slot-ratio";
    final float overloadMapTaskMapSlotRatio;
    private static final float OVERLOAD_REDUCETASK_REDUCESLOT_RATIO = 2.5f;
    public static final String CONF_OVERLOAD_REDUCETASK_REDUCESLOT_RATIO = "gridmix.throttle.reduces.task-to-slot-ratio";
    final float overloadReduceTaskReduceSlotRatio;
    private static final float MAX_MAPSLOT_SHARE_PER_JOB = 0.1f;
    public static final String CONF_MAX_MAPSLOT_SHARE_PER_JOB = "gridmix.throttle.maps.max-slot-share-per-job";
    final float maxMapSlotSharePerJob;
    private static final float MAX_REDUCESLOT_SHARE_PER_JOB = 0.1f;
    public static final String CONF_MAX_REDUCESLOT_SHARE_PER_JOB = "gridmix.throttle.reducess.max-slot-share-per-job";
    final float maxReduceSlotSharePerJob;
    private static final float MAX_JOB_TRACKER_RATIO = 1.0f;
    public static final String CONF_MAX_JOB_TRACKER_RATIO = "gridmix.throttle.jobs-to-tracker-ratio";
    final float maxJobTrackerRatio;

    public StressJobFactory(JobSubmitter submitter, JobStoryProducer jobProducer, Path scratch, Configuration conf, CountDownLatch startFlag, UserResolver resolver) throws IOException {
        super(submitter, jobProducer, scratch, conf, startFlag, resolver);
        this.overloadMapTaskMapSlotRatio = conf.getFloat(CONF_OVERLOAD_MAPTASK_MAPSLOT_RATIO, 2.0f);
        this.overloadReduceTaskReduceSlotRatio = conf.getFloat(CONF_OVERLOAD_REDUCETASK_REDUCESLOT_RATIO, 2.5f);
        this.maxMapSlotSharePerJob = conf.getFloat(CONF_MAX_MAPSLOT_SHARE_PER_JOB, 0.1f);
        this.maxReduceSlotSharePerJob = conf.getFloat(CONF_MAX_REDUCESLOT_SHARE_PER_JOB, 0.1f);
        this.maxJobTrackerRatio = conf.getFloat(CONF_MAX_JOB_TRACKER_RATIO, 1.0f);
    }

    public Thread createReaderThread() {
        return new StressReaderThread(this, "StressJobFactory");
    }

    public void update(Statistics.ClusterStats item) {
        ClusterStatus clusterMetrics = item.getStatus();
        try {
            this.checkLoadAndGetSlotsToBackfill(item, clusterMetrics);
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't get the new Status", (Throwable)e);
        }
    }

    float calcEffectiveIncompleteMapTasks(int mapSlotCapacity, int numMaps, float mapProgress) {
        float maxEffIncompleteMapTasks = Math.max(1.0f, (float)mapSlotCapacity * this.maxMapSlotSharePerJob);
        float mapProgressAdjusted = Math.max(Math.min(mapProgress, 1.0f), 0.0f);
        return Math.min(maxEffIncompleteMapTasks, (float)numMaps * (1.0f - mapProgressAdjusted));
    }

    float calcEffectiveIncompleteReduceTasks(int reduceSlotCapacity, int numReduces, float reduceProgress) {
        float maxEffIncompleteReduceTasks = Math.max(1.0f, (float)reduceSlotCapacity * this.maxReduceSlotSharePerJob);
        float reduceProgressAdjusted = Math.max(Math.min(reduceProgress, 1.0f), 0.0f);
        return Math.min(maxEffIncompleteReduceTasks, (float)numReduces * (1.0f - reduceProgressAdjusted));
    }

    private void checkLoadAndGetSlotsToBackfill(Statistics.ClusterStats stats, ClusterStatus clusterStatus) throws IOException, InterruptedException {
        int mapCapacity = clusterStatus.getMaxMapTasks();
        this.loadStatus.updateMapCapacity(mapCapacity);
        int reduceCapacity = clusterStatus.getMaxReduceTasks();
        this.loadStatus.updateReduceCapacity(reduceCapacity);
        int numTrackers = clusterStatus.getTaskTrackers();
        int jobLoad = (int)(this.maxJobTrackerRatio * (float)numTrackers) - stats.getNumRunningJob();
        this.loadStatus.updateJobLoad(jobLoad);
        if (this.loadStatus.getJobLoad() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(System.currentTimeMillis() + " [JobLoad] Overloaded is " + Boolean.TRUE.toString() + " NumJobsBackfill is " + this.loadStatus.getJobLoad()));
            }
            return;
        }
        float incompleteMapTasks = 0.0f;
        for (Statistics.JobStats job : Statistics.ClusterStats.getRunningJobStats()) {
            float mapProgress = job.getJob().mapProgress();
            int noOfMaps = job.getNoOfMaps();
            incompleteMapTasks += this.calcEffectiveIncompleteMapTasks(mapCapacity, noOfMaps, mapProgress);
        }
        int mapSlotsBackFill = (int)(this.overloadMapTaskMapSlotRatio * (float)mapCapacity - incompleteMapTasks);
        this.loadStatus.updateMapLoad(mapSlotsBackFill);
        if (this.loadStatus.getMapLoad() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(System.currentTimeMillis() + " [MAP-LOAD] Overloaded is " + Boolean.TRUE.toString() + " MapSlotsBackfill is " + this.loadStatus.getMapLoad()));
            }
            return;
        }
        float incompleteReduceTasks = 0.0f;
        for (Statistics.JobStats job : Statistics.ClusterStats.getRunningJobStats()) {
            int noOfReduces = job.getNoOfReds();
            if (noOfReduces <= 0) continue;
            float reduceProgress = job.getJob().reduceProgress();
            incompleteReduceTasks += this.calcEffectiveIncompleteReduceTasks(reduceCapacity, noOfReduces, reduceProgress);
        }
        int reduceSlotsBackFill = (int)(this.overloadReduceTaskReduceSlotRatio * (float)reduceCapacity - incompleteReduceTasks);
        this.loadStatus.updateReduceLoad(reduceSlotsBackFill);
        if (this.loadStatus.getReduceLoad() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(System.currentTimeMillis() + " [REDUCE-LOAD] Overloaded is " + Boolean.TRUE.toString() + " ReduceSlotsBackfill is " + this.loadStatus.getReduceLoad()));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(System.currentTimeMillis() + " [OVERALL] Overloaded is " + Boolean.FALSE.toString() + "Current load Status is " + this.loadStatus));
        }
    }

    public void start() {
        LOG.info((Object)" Starting Stress submission ");
        this.rThread.start();
    }

    static /* synthetic */ LoadStatus access$000(StressJobFactory x0) {
        return x0.loadStatus;
    }
}

