/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.CustomOutputCommitter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.DistributedCacheEmulator;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.mapred.gridmix.GridmixSplit;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.LoadJob;
import org.apache.hadoop.mapred.gridmix.LoadSplit;
import org.apache.hadoop.mapred.gridmix.ReadRecordFactory;
import org.apache.hadoop.mapred.gridmix.RecordFactory;
import org.apache.hadoop.mapred.gridmix.SerialJobFactory;
import org.apache.hadoop.mapred.gridmix.SleepJob;
import org.apache.hadoop.mapred.gridmix.SubmitterUserResolver;
import org.apache.hadoop.mapred.gridmix.TestGridMixClasses;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.mapreduce.lib.reduce.WrappedReducer;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.mapreduce.task.ReduceContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.apache.hadoop.tools.rumen.ZombieJobProducer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGridMixClasses {
    private static final Log LOG = LogFactory.getLog(TestGridMixClasses.class);

    @Test(timeout=5000L)
    public void testLoadSplit() throws Exception {
        LoadSplit test = this.getLoadSplit();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        test.write((DataOutput)out);
        LoadSplit copy = new LoadSplit();
        copy.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(data.toByteArray())));
        Assert.assertEquals((long)test.getId(), (long)copy.getId());
        Assert.assertEquals((long)test.getMapCount(), (long)copy.getMapCount());
        Assert.assertEquals((long)test.getInputRecords(), (long)copy.getInputRecords());
        Assert.assertEquals((long)test.getOutputBytes()[0], (long)copy.getOutputBytes()[0]);
        Assert.assertEquals((long)test.getOutputRecords()[0], (long)copy.getOutputRecords()[0]);
        Assert.assertEquals((long)test.getReduceBytes(0), (long)copy.getReduceBytes(0));
        Assert.assertEquals((long)test.getReduceRecords(0), (long)copy.getReduceRecords(0));
        Assert.assertEquals((long)test.getMapResourceUsageMetrics().getCumulativeCpuUsage(), (long)copy.getMapResourceUsageMetrics().getCumulativeCpuUsage());
        Assert.assertEquals((long)test.getReduceResourceUsageMetrics(0).getCumulativeCpuUsage(), (long)copy.getReduceResourceUsageMetrics(0).getCumulativeCpuUsage());
    }

    @Test(timeout=5000L)
    public void testGridmixSplit() throws Exception {
        Path[] files = new Path[]{new Path("one"), new Path("two")};
        long[] start = new long[]{1L, 2L};
        long[] lengths = new long[]{100L, 200L};
        String[] locations = new String[]{"locOne", "loctwo"};
        CombineFileSplit cfsplit = new CombineFileSplit(files, start, lengths, locations);
        ResourceUsageMetrics metrics = new ResourceUsageMetrics();
        metrics.setCumulativeCpuUsage(200L);
        double[] reduceBytes = new double[]{8.1, 8.2};
        double[] reduceRecords = new double[]{9.1, 9.2};
        long[] reduceOutputBytes = new long[]{101L, 102L};
        long[] reduceOutputRecords = new long[]{111L, 112L};
        GridmixSplit test = new GridmixSplit(cfsplit, 2, 3, 4L, 5L, 6L, 7L, reduceBytes, reduceRecords, reduceOutputBytes, reduceOutputRecords);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(data);
        test.write((DataOutput)out);
        GridmixSplit copy = new GridmixSplit();
        copy.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(data.toByteArray())));
        Assert.assertEquals((long)test.getId(), (long)copy.getId());
        Assert.assertEquals((long)test.getMapCount(), (long)copy.getMapCount());
        Assert.assertEquals((long)test.getInputRecords(), (long)copy.getInputRecords());
        Assert.assertEquals((long)test.getOutputBytes()[0], (long)copy.getOutputBytes()[0]);
        Assert.assertEquals((long)test.getOutputRecords()[0], (long)copy.getOutputRecords()[0]);
        Assert.assertEquals((long)test.getReduceBytes(0), (long)copy.getReduceBytes(0));
        Assert.assertEquals((long)test.getReduceRecords(0), (long)copy.getReduceRecords(0));
    }

    @Test(timeout=5000L)
    public void testLoadMapper() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.reduces", 2);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setBoolean("mapreduce.map.output.compress", true);
        TaskAttemptID taskid = new TaskAttemptID();
        FakeRecordReader reader = new FakeRecordReader(this, null);
        LoadRecordGkGrWriter writer = new LoadRecordGkGrWriter(this, null);
        CustomOutputCommitter committer = new CustomOutputCommitter();
        TaskAttemptContextImpl.DummyReporter reporter = new TaskAttemptContextImpl.DummyReporter();
        LoadSplit split = this.getLoadSplit();
        MapContextImpl mapcontext = new MapContextImpl(conf, taskid, (RecordReader)reader, (RecordWriter)writer, (OutputCommitter)committer, (StatusReporter)reporter, (InputSplit)split);
        Mapper.Context ctxt = new WrappedMapper().getMapContext((MapContext)mapcontext);
        reader.initialize((InputSplit)split, (TaskAttemptContext)ctxt);
        ctxt.getConfiguration().setBoolean("mapreduce.map.output.compress", true);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)ctxt.getConfiguration(), (boolean)true);
        LoadJob.LoadMapper mapper = new LoadJob.LoadMapper();
        mapper.run(ctxt);
        Map data = writer.getData();
        Assert.assertEquals((long)2L, (long)data.size());
    }

    private LoadSplit getLoadSplit() throws Exception {
        Path[] files = new Path[]{new Path("one"), new Path("two")};
        long[] start = new long[]{1L, 2L};
        long[] lengths = new long[]{100L, 200L};
        String[] locations = new String[]{"locOne", "loctwo"};
        CombineFileSplit cfsplit = new CombineFileSplit(files, start, lengths, locations);
        ResourceUsageMetrics metrics = new ResourceUsageMetrics();
        metrics.setCumulativeCpuUsage(200L);
        ResourceUsageMetrics[] rMetrics = new ResourceUsageMetrics[]{metrics};
        double[] reduceBytes = new double[]{8.1, 8.2};
        double[] reduceRecords = new double[]{9.1, 9.2};
        long[] reduceOutputBytes = new long[]{101L, 102L};
        long[] reduceOutputRecords = new long[]{111L, 112L};
        return new LoadSplit(cfsplit, 2, 1, 4L, 5L, 6L, 7L, reduceBytes, reduceRecords, reduceOutputBytes, reduceOutputRecords, metrics, rMetrics);
    }

    @Test(timeout=5000L)
    public void testGridmixJobSpecGroupingComparator() throws Exception {
        GridmixJob.SpecGroupingComparator test = new GridmixJob.SpecGroupingComparator();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(data);
        WritableUtils.writeVInt((DataOutput)dos, (int)2);
        WritableUtils.writeVInt((DataOutput)dos, (int)1);
        WritableUtils.writeVInt((DataOutput)dos, (int)0);
        WritableUtils.writeVInt((DataOutput)dos, (int)7);
        WritableUtils.writeVInt((DataOutput)dos, (int)4);
        byte[] b1 = data.toByteArray();
        byte[] b2 = data.toByteArray();
        Assert.assertEquals((long)0L, (long)test.compare(b1, 0, 1, b2, 0, 1));
        b2[2] = 1;
        Assert.assertEquals((long)-1L, (long)test.compare(b1, 0, 1, b2, 0, 1));
        b2[2] = 1;
        Assert.assertEquals((long)-1L, (long)test.compare(b1, 0, 1, b2, 0, 1));
        Assert.assertEquals((long)0L, (long)test.compare(new GridmixKey(1, 100, 2L), new GridmixKey(1, 100, 2L)));
        Assert.assertEquals((long)-1L, (long)test.compare(new GridmixKey(0, 100, 2L), new GridmixKey(1, 100, 2L)));
        Assert.assertEquals((long)1L, (long)test.compare(new GridmixKey(1, 100, 2L), new GridmixKey(0, 100, 2L)));
        Assert.assertEquals((long)2L, (long)test.compare(new GridmixKey(1, 102, 2L), new GridmixKey(1, 100, 2L)));
    }

    @Test(timeout=5000L)
    public void testCompareGridmixJob() throws Exception {
        Configuration conf = new Configuration();
        Path outRoot = new Path("target");
        JobStory jobdesc = (JobStory)Mockito.mock(JobStory.class);
        Mockito.when((Object)jobdesc.getName()).thenReturn((Object)"JobName");
        Mockito.when((Object)jobdesc.getJobConf()).thenReturn((Object)new JobConf(conf));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        LoadJob j1 = new LoadJob(conf, 1000L, jobdesc, outRoot, ugi, 0);
        LoadJob j2 = new LoadJob(conf, 1000L, jobdesc, outRoot, ugi, 0);
        LoadJob j3 = new LoadJob(conf, 1000L, jobdesc, outRoot, ugi, 1);
        LoadJob j4 = new LoadJob(conf, 1000L, jobdesc, outRoot, ugi, 1);
        Assert.assertTrue((boolean)j1.equals((Object)j2));
        Assert.assertEquals((long)0L, (long)j1.compareTo((Delayed)j2));
        Assert.assertFalse((boolean)j1.equals((Object)j3));
        Assert.assertEquals((long)-1L, (long)j1.compareTo((Delayed)j3));
        Assert.assertEquals((long)-1L, (long)j1.compareTo((Delayed)j4));
    }

    @Test(timeout=5000L)
    public void testReadRecordFactory() throws Exception {
        FakeRecordFactory rf = new FakeRecordFactory(this, null);
        FakeInputStream input = new FakeInputStream(this, null);
        ReadRecordFactory test = new ReadRecordFactory((RecordFactory)rf, (InputStream)input, new Configuration());
        GridmixKey key = new GridmixKey(1, 100, 2L);
        GridmixRecord val = new GridmixRecord(200, 2L);
        while (test.next(key, val)) {
        }
        Assert.assertEquals((long)3000L, (long)input.getCounter());
        Assert.assertEquals((double)-1.0, (double)rf.getProgress(), (double)0.01);
        test.close();
    }

    @Test(timeout=5000L)
    public void testLoadJobLoadRecordReader() throws Exception {
        LoadJob.LoadRecordReader test = new LoadJob.LoadRecordReader();
        Configuration conf = new Configuration();
        FileSystem fs1 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs1.open((Path)Mockito.anyObject())).thenReturn((Object)new FakeFSDataInputStream(this, (InputStream)new FakeInputStream(this, null)));
        Path p1 = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)p1.getFileSystem((Configuration)((JobConf)Mockito.anyObject()))).thenReturn((Object)fs1);
        FileSystem fs2 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fs2.open((Path)Mockito.anyObject())).thenReturn((Object)new FakeFSDataInputStream(this, (InputStream)new FakeInputStream(this, null)));
        Path p2 = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)p2.getFileSystem((Configuration)((JobConf)Mockito.anyObject()))).thenReturn((Object)fs2);
        Path[] paths = new Path[]{p1, p2};
        long[] start = new long[]{0L, 0L};
        long[] lengths = new long[]{1000L, 1000L};
        String[] locations = new String[]{"temp1", "temp2"};
        CombineFileSplit cfsplit = new CombineFileSplit(paths, start, lengths, locations);
        double[] reduceBytes = new double[]{100.0, 100.0};
        double[] reduceRecords = new double[]{2.0, 2.0};
        long[] reduceOutputBytes = new long[]{500L, 500L};
        long[] reduceOutputRecords = new long[]{2L, 2L};
        ResourceUsageMetrics metrics = new ResourceUsageMetrics();
        ResourceUsageMetrics[] rMetrics = new ResourceUsageMetrics[]{new ResourceUsageMetrics(), new ResourceUsageMetrics()};
        LoadSplit input = new LoadSplit(cfsplit, 2, 3, 1500L, 2L, 3000L, 2L, reduceBytes, reduceRecords, reduceOutputBytes, reduceOutputRecords, metrics, rMetrics);
        TaskAttemptID taskId = new TaskAttemptID();
        TaskAttemptContextImpl ctxt = new TaskAttemptContextImpl(conf, taskId);
        test.initialize((InputSplit)input, (TaskAttemptContext)ctxt);
        GridmixRecord gr = test.getCurrentValue();
        int counter = 0;
        while (test.nextKeyValue()) {
            gr = test.getCurrentValue();
            if (counter == 0) {
                Assert.assertEquals((double)0.5, (double)test.getProgress(), (double)0.001);
            } else if (counter == 1) {
                Assert.assertEquals((double)1.0, (double)test.getProgress(), (double)0.001);
            }
            Assert.assertEquals((long)1000L, (long)gr.getSize());
            ++counter;
        }
        Assert.assertEquals((long)1000L, (long)gr.getSize());
        Assert.assertEquals((long)2L, (long)counter);
        test.close();
    }

    @Test(timeout=5000L)
    public void testLoadJobLoadReducer() throws Exception {
        LoadJob.LoadReducer test = new LoadJob.LoadReducer();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.reduces", 2);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setBoolean("mapreduce.map.output.compress", true);
        TaskAttemptID taskid = new TaskAttemptID();
        FakeRawKeyValueIterator input = new FakeRawKeyValueIterator(this);
        GenericCounter counter = new GenericCounter();
        GenericCounter inputValueCounter = new GenericCounter();
        LoadRecordWriter output = new LoadRecordWriter(this, null);
        CustomOutputCommitter committer = new CustomOutputCommitter();
        TaskAttemptContextImpl.DummyReporter reporter = new TaskAttemptContextImpl.DummyReporter();
        FakeRawComparator comparator = new FakeRawComparator(this, null);
        ReduceContextImpl reducecontext = new ReduceContextImpl(conf, taskid, (RawKeyValueIterator)input, (Counter)counter, (Counter)inputValueCounter, (RecordWriter)output, (OutputCommitter)committer, (StatusReporter)reporter, (RawComparator)comparator, GridmixKey.class, GridmixRecord.class);
        reducecontext.nextKeyValue();
        Reducer.Context context = new WrappedReducer().getReducerContext((ReduceContext)reducecontext);
        test.run(context);
        Assert.assertEquals((long)9L, (long)counter.getValue());
        Assert.assertEquals((long)10L, (long)inputValueCounter.getValue());
        Assert.assertEquals((long)1L, (long)output.getData().size());
        GridmixRecord record = (GridmixRecord)output.getData().values().iterator().next();
        Assert.assertEquals((long)1593L, (long)record.getSize());
    }

    @Test(timeout=5000L)
    public void testSerialReaderThread() throws Exception {
        Configuration conf = new Configuration();
        File fin = new File("src" + File.separator + "test" + File.separator + "resources" + File.separator + "data" + File.separator + "wordcount2.json");
        ZombieJobProducer jobProducer = new ZombieJobProducer(new Path(fin.getAbsolutePath()), null, conf);
        CountDownLatch startFlag = new CountDownLatch(1);
        SubmitterUserResolver resolver = new SubmitterUserResolver();
        FakeJobSubmitter submitter = new FakeJobSubmitter(this);
        File ws = new File("target" + File.separator + this.getClass().getName());
        if (!ws.exists()) {
            Assert.assertTrue((boolean)ws.mkdirs());
        }
        SerialJobFactory jobFactory = new SerialJobFactory((JobSubmitter)submitter, (JobStoryProducer)jobProducer, new Path(ws.getAbsolutePath()), conf, startFlag, (UserResolver)resolver);
        Path ioPath = new Path(ws.getAbsolutePath());
        jobFactory.setDistCacheEmulator(new DistributedCacheEmulator(conf, ioPath));
        Thread test = jobFactory.createReaderThread();
        test.start();
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)submitter.getJobs().size());
        startFlag.countDown();
        while (test.isAlive()) {
            Thread.sleep(1000L);
            jobFactory.update(null);
        }
        Assert.assertEquals((long)2L, (long)submitter.getJobs().size());
    }

    @Test(timeout=5000L)
    public void testSleepMapper() throws Exception {
        SleepJob.SleepMapper test = new SleepJob.SleepMapper();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.reduces", 2);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setBoolean("mapreduce.map.output.compress", true);
        TaskAttemptID taskid = new TaskAttemptID();
        FakeRecordLLReader reader = new FakeRecordLLReader(this, null);
        LoadRecordGkNullWriter writer = new LoadRecordGkNullWriter(this, null);
        CustomOutputCommitter committer = new CustomOutputCommitter();
        TaskAttemptContextImpl.DummyReporter reporter = new TaskAttemptContextImpl.DummyReporter();
        SleepJob.SleepSplit split = this.getSleepSplit();
        MapContextImpl mapcontext = new MapContextImpl(conf, taskid, (RecordReader)reader, (RecordWriter)writer, (OutputCommitter)committer, (StatusReporter)reporter, (InputSplit)split);
        Mapper.Context context = new WrappedMapper().getMapContext((MapContext)mapcontext);
        long start = System.currentTimeMillis();
        LOG.info((Object)("start:" + start));
        LongWritable key = new LongWritable(start + 2000L);
        LongWritable value = new LongWritable(start + 2000L);
        test.map(key, value, context);
        LOG.info((Object)("finish:" + System.currentTimeMillis()));
        Assert.assertTrue((System.currentTimeMillis() >= start + 2000L ? 1 : 0) != 0);
        test.cleanup(context);
        Assert.assertEquals((long)1L, (long)writer.getData().size());
    }

    private SleepJob.SleepSplit getSleepSplit() throws Exception {
        String[] locations = new String[]{"locOne", "loctwo"};
        long[] reduceDurations = new long[]{101L, 102L};
        return new SleepJob.SleepSplit(0, 2000L, reduceDurations, 2, locations);
    }

    @Test(timeout=5000L)
    public void testSleepReducer() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.reduces", 2);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setBoolean("mapreduce.output.fileoutputformat.compress", true);
        CompressionEmulationUtil.setCompressionEmulationEnabled((Configuration)conf, (boolean)true);
        conf.setBoolean("mapreduce.map.output.compress", true);
        TaskAttemptID taskid = new TaskAttemptID();
        FakeRawKeyValueReducerIterator input = new FakeRawKeyValueReducerIterator(this);
        GenericCounter counter = new GenericCounter();
        GenericCounter inputValueCounter = new GenericCounter();
        LoadRecordReduceWriter output = new LoadRecordReduceWriter(this, null);
        CustomOutputCommitter committer = new CustomOutputCommitter();
        TaskAttemptContextImpl.DummyReporter reporter = new TaskAttemptContextImpl.DummyReporter();
        FakeRawComparator comparator = new FakeRawComparator(this, null);
        ReduceContextImpl reducecontext = new ReduceContextImpl(conf, taskid, (RawKeyValueIterator)input, (Counter)counter, (Counter)inputValueCounter, (RecordWriter)output, (OutputCommitter)committer, (StatusReporter)reporter, (RawComparator)comparator, GridmixKey.class, NullWritable.class);
        Reducer.Context context = new WrappedReducer().getReducerContext((ReduceContext)reducecontext);
        SleepJob.SleepReducer test = new SleepJob.SleepReducer();
        long start = System.currentTimeMillis();
        test.setup(context);
        long sleeped = ((GridmixKey)context.getCurrentKey()).getReduceOutputBytes();
        Assert.assertEquals((Object)("Sleeping... " + sleeped + " ms left"), (Object)context.getStatus());
        Assert.assertTrue((System.currentTimeMillis() >= start + sleeped ? 1 : 0) != 0);
        test.cleanup(context);
        Assert.assertEquals((Object)("Slept for " + sleeped), (Object)context.getStatus());
    }
}

