/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;

/*
 * Exception performing whole class analysis ignored.
 */
public class GridmixTestUtils {
    private static final Log LOG = LogFactory.getLog(GridmixTestUtils.class);
    static final Path DEST = new Path("/gridmix");
    static FileSystem dfs = null;
    static MiniDFSCluster dfsCluster = null;
    static MiniMRCluster mrCluster = null;

    public static void initCluster() throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapred.queue.names", "default,q1,q2");
        dfsCluster = new MiniDFSCluster(conf, 3, true, null);
        dfs = dfsCluster.getFileSystem();
        conf.set("mapreduce.jobtracker.retirejobs", "false");
        mrCluster = new MiniMRCluster(3, dfs.getUri().toString(), 1, null, null, new JobConf(conf));
    }

    public static void shutdownCluster() throws IOException {
        if (mrCluster != null) {
            mrCluster.shutdown();
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    public static void createHomeAndStagingDirectory(String user, JobConf conf) {
        try {
            FileSystem fs = dfsCluster.getFileSystem();
            String path = "/user/" + user;
            Path homeDirectory = new Path(path);
            if (fs.exists(homeDirectory)) {
                fs.delete(homeDirectory, true);
            }
            LOG.info((Object)("Creating Home directory : " + homeDirectory));
            fs.mkdirs(homeDirectory);
            GridmixTestUtils.changePermission((String)user, (Path)homeDirectory, (FileSystem)fs);
            Path stagingArea = new Path(conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
            LOG.info((Object)("Creating Staging root directory : " + stagingArea));
            fs.mkdirs(stagingArea);
            fs.setPermission(stagingArea, new FsPermission(511));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static void changePermission(String user, Path homeDirectory, FileSystem fs) throws IOException {
        fs.setOwner(homeDirectory, user, "");
    }
}

