/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.FilePool;

class FilePool {
    public static final Log LOG = LogFactory.getLog(FilePool.class);
    public static final String GRIDMIX_MIN_FILE = "gridmix.min.file.size";
    public static final String GRIDMIX_MAX_TOTAL = "gridmix.max.total.scan";
    private Node root = null;
    private final Path path;
    private final FileSystem fs;
    private final Configuration conf;
    private final ReadWriteLock updateLock;

    public FilePool(Configuration conf, Path input) throws IOException {
        this.conf = conf;
        this.path = input;
        this.fs = this.path.getFileSystem(conf);
        this.updateLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInputFiles(long minSize, Collection<FileStatus> files) throws IOException {
        this.updateLock.readLock().lock();
        try {
            long l = this.root.selectFiles(minSize, files);
            return l;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IOException {
        this.updateLock.writeLock().lock();
        try {
            this.root = new InnerDesc(this.fs, this.fs.getFileStatus(this.path), new MinFileFilter(this.conf.getLong(GRIDMIX_MIN_FILE, 0x8000000L), this.conf.getLong(GRIDMIX_MAX_TOTAL, 0x640000000000L)));
            if (0L == this.root.getSize()) {
                throw new IOException("Found no satisfactory file in " + this.path);
            }
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    public BlockLocation[] locationsFor(FileStatus stat, long start, long len) throws IOException {
        return this.fs.getFileBlockLocations(stat, start, len);
    }
}

