/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.JobMonitor;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapreduce.Job;

class JobMonitor
implements Gridmix.Component<Job> {
    public static final Log LOG = LogFactory.getLog(JobMonitor.class);
    private final Queue<Job> mJobs;
    private final MonitorThread mThread = new MonitorThread(this);
    private final BlockingQueue<Job> runningJobs = new LinkedBlockingQueue();
    private final long pollDelayMillis;
    private Statistics statistics;
    private boolean graceful = false;
    private boolean shutdown = false;

    public JobMonitor(Statistics statistics) {
        this(5, TimeUnit.SECONDS, statistics);
    }

    public JobMonitor(int pollDelay, TimeUnit unit, Statistics statistics) {
        this.mJobs = new LinkedList();
        this.pollDelayMillis = TimeUnit.MILLISECONDS.convert(pollDelay, unit);
        this.statistics = statistics;
    }

    public void add(Job job) throws InterruptedException {
        this.runningJobs.put(job);
    }

    public void submissionFailed(Job job) {
        LOG.info((Object)("Job submission failed notification for job " + job.getJobID()));
        this.statistics.add(job);
    }

    protected void onSuccess(Job job) {
        LOG.info((Object)(job.getJobName() + " (" + job.getJobID() + ")" + " success"));
    }

    protected void onFailure(Job job) {
        LOG.info((Object)(job.getJobName() + " (" + job.getJobID() + ")" + " failure"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Job> getRemainingJobs() {
        if (this.mThread.isAlive()) {
            LOG.warn((Object)"Internal error: Polling running monitor for jobs");
        }
        Queue queue = this.mJobs;
        synchronized (queue) {
            return new ArrayList<Job>(this.mJobs);
        }
    }

    public void start() {
        this.mThread.start();
    }

    public void join(long millis) throws InterruptedException {
        this.mThread.join(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Queue queue = this.mJobs;
        synchronized (queue) {
            this.graceful = false;
            this.shutdown = true;
        }
        this.mThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Queue queue = this.mJobs;
        synchronized (queue) {
            this.graceful = true;
            this.shutdown = true;
        }
        this.mThread.interrupt();
    }

    static /* synthetic */ Queue access$000(JobMonitor x0) {
        return x0.mJobs;
    }

    static /* synthetic */ boolean access$100(JobMonitor x0) {
        return x0.graceful;
    }

    static /* synthetic */ boolean access$200(JobMonitor x0) {
        return x0.shutdown;
    }

    static /* synthetic */ BlockingQueue access$300(JobMonitor x0) {
        return x0.runningJobs;
    }

    static /* synthetic */ Statistics access$400(JobMonitor x0) {
        return x0.statistics;
    }

    static /* synthetic */ long access$500(JobMonitor x0) {
        return x0.pollDelayMillis;
    }
}

