/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.DummyResourceCalculatorPlugin;
import org.apache.hadoop.mapred.gridmix.Progressive;
import org.apache.hadoop.mapred.gridmix.TestResourceUsageEmulators;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.CumulativeCpuUsageEmulatorPlugin;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.ResourceUsageEmulatorPlugin;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.ResourceUsageMatcher;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.mapreduce.util.ResourceCalculatorPlugin;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestResourceUsageEmulators {
    @Test
    public void testResourceUsageMatcher() throws Exception {
        ResourceUsageMatcher matcher = new ResourceUsageMatcher();
        Configuration conf = new Configuration();
        conf.setClass("gridmix.emulators.resource-usage.plugins", TestResourceUsageEmulatorPlugin.class, ResourceUsageEmulatorPlugin.class);
        long currentTime = System.currentTimeMillis();
        matcher.configure(conf, null, null, null);
        matcher.matchResourceUsage();
        String id = "test";
        long result = TestResourceUsageEmulatorPlugin.testInitialization((String)id, (Configuration)conf);
        Assert.assertTrue((String)"Resource usage matcher failed to initialize the configured plugin", (result > currentTime ? 1 : 0) != 0);
        result = TestResourceUsageEmulatorPlugin.testEmulation((String)id, (Configuration)conf);
        Assert.assertTrue((String)"Resource usage matcher failed to load and emulate the configured plugin", (result > currentTime ? 1 : 0) != 0);
        conf.setStrings("gridmix.emulators.resource-usage.plugins", new String[]{TestCpu.class.getName() + "," + TestOthers.class.getName()});
        matcher.configure(conf, null, null, null);
        long time1 = TestResourceUsageEmulatorPlugin.testInitialization((String)"cpu", (Configuration)conf);
        long time2 = TestResourceUsageEmulatorPlugin.testInitialization((String)"others", (Configuration)conf);
        Assert.assertTrue((String)"Resource usage matcher failed to initialize the configured plugins in order", (time1 < time2 ? 1 : 0) != 0);
        matcher.matchResourceUsage();
        time1 = TestResourceUsageEmulatorPlugin.testInitialization((String)"cpu", (Configuration)conf);
        time2 = TestResourceUsageEmulatorPlugin.testInitialization((String)"others", (Configuration)conf);
        Assert.assertTrue((String)"Resource usage matcher failed to load the configured plugins", (time1 < time2 ? 1 : 0) != 0);
    }

    @Test
    public void testResourceUsageMatcherRunner() throws Exception {
        Configuration conf = new Configuration();
        FakeProgressive progress = new FakeProgressive();
        conf.setClass("mapreduce.tasktracker.resourcecalculatorplugin", DummyResourceCalculatorPlugin.class, ResourceCalculatorPlugin.class);
        conf.setClass("gridmix.emulators.resource-usage.plugins", TestResourceUsageEmulatorPlugin.class, ResourceUsageEmulatorPlugin.class);
        long currentTime = System.currentTimeMillis();
        TaskAttemptID id = new TaskAttemptID("test", 1, TaskType.MAP, 1, 1);
        DummyReporter reporter = new DummyReporter((Progressive)progress);
        MapContextImpl context = new MapContextImpl(conf, id, null, null, null, (StatusReporter)reporter, null);
        FakeResourceUsageMatcherRunner matcher = new FakeResourceUsageMatcherRunner((TaskInputOutputContext)context, null);
        String identifier = "test";
        long initTime = TestResourceUsageEmulatorPlugin.testInitialization((String)identifier, (Configuration)conf);
        Assert.assertTrue((String)"ResourceUsageMatcherRunner failed to initialize the configured plugin", (initTime > currentTime ? 1 : 0) != 0);
        Assert.assertEquals((String)"Progress mismatch in ResourceUsageMatcherRunner", (double)0.0, (double)progress.getProgress(), (double)0.0);
        progress.setProgress(0.01f);
        currentTime = System.currentTimeMillis();
        matcher.test();
        long emulateTime = TestResourceUsageEmulatorPlugin.testEmulation((String)identifier, (Configuration)conf);
        Assert.assertTrue((String)"ProgressBasedResourceUsageMatcher failed to load and emulate the configured plugin", (emulateTime > currentTime ? 1 : 0) != 0);
    }

    @Test
    public void testCpuUsageEmulator() throws IOException {
        long target = 100000L;
        int unitUsage = 50;
        FakeCpuUsageEmulatorCore fakeCpuEmulator = new FakeCpuUsageEmulatorCore(null);
        fakeCpuEmulator.setUnitUsage(unitUsage);
        FakeResourceUsageMonitor fakeMonitor = new FakeResourceUsageMonitor(fakeCpuEmulator);
        fakeCpuEmulator.calibrate((ResourceCalculatorPlugin)fakeMonitor, target);
        Assert.assertEquals((String)"Fake calibration failed", (long)100L, (long)fakeMonitor.getCumulativeCpuTime());
        Assert.assertEquals((String)"Fake calibration failed", (long)100L, (long)fakeCpuEmulator.getCpuUsage());
        Assert.assertEquals((String)"Fake calibration failed", (long)2L, (long)fakeCpuEmulator.getNumCalls());
    }

    static ResourceUsageMetrics createMetrics(long target) {
        ResourceUsageMetrics metrics = new ResourceUsageMetrics();
        metrics.setCumulativeCpuUsage(target);
        metrics.setVirtualMemoryUsage(target);
        metrics.setPhysicalMemoryUsage(target);
        metrics.setHeapUsage(target);
        return metrics;
    }

    @Test
    public void testCumulativeCpuUsageEmulatorPlugin() throws Exception {
        Configuration conf = new Configuration();
        long targetCpuUsage = 1000L;
        int unitCpuUsage = 50;
        FakeProgressive fakeProgress = new FakeProgressive();
        FakeCpuUsageEmulatorCore fakeCore = new FakeCpuUsageEmulatorCore(null);
        fakeCore.setUnitUsage(unitCpuUsage);
        CumulativeCpuUsageEmulatorPlugin cpuPlugin = new CumulativeCpuUsageEmulatorPlugin((CumulativeCpuUsageEmulatorPlugin.CpuUsageEmulatorCore)fakeCore);
        ResourceUsageMetrics invalidUsage = TestResourceUsageEmulators.createMetrics((long)0L);
        cpuPlugin.initialize(conf, invalidUsage, null, null);
        int numCallsPre = fakeCore.getNumCalls();
        long cpuUsagePre = fakeCore.getCpuUsage();
        cpuPlugin.emulate();
        int numCallsPost = fakeCore.getNumCalls();
        long cpuUsagePost = fakeCore.getCpuUsage();
        Assert.assertEquals((String)"Disabled cumulative CPU usage emulation plugin works!", (long)numCallsPre, (long)numCallsPost);
        Assert.assertEquals((String)"Disabled cumulative CPU usage emulation plugin works!", (long)cpuUsagePre, (long)cpuUsagePost);
        ResourceUsageMetrics metrics = TestResourceUsageEmulators.createMetrics((long)targetCpuUsage);
        FakeResourceUsageMonitor monitor = new FakeResourceUsageMonitor(fakeCore);
        TestResourceUsageEmulators.testEmulationAccuracy((Configuration)conf, (FakeCpuUsageEmulatorCore)fakeCore, (ResourceCalculatorPlugin)monitor, (ResourceUsageMetrics)metrics, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)targetCpuUsage, (long)(targetCpuUsage / (long)unitCpuUsage));
        conf.setFloat("gridmix.emulators.resource-usage.cpu.emulation-interval", 0.2f);
        TestResourceUsageEmulators.testEmulationAccuracy((Configuration)conf, (FakeCpuUsageEmulatorCore)fakeCore, (ResourceCalculatorPlugin)monitor, (ResourceUsageMetrics)metrics, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)targetCpuUsage, (long)(targetCpuUsage / (long)unitCpuUsage));
        fakeProgress = new FakeProgressive();
        fakeCore.reset();
        fakeCore.setUnitUsage(1);
        conf.setFloat("gridmix.emulators.resource-usage.cpu.emulation-interval", 0.25f);
        cpuPlugin.initialize(conf, metrics, (ResourceCalculatorPlugin)monitor, (Progressive)fakeProgress);
        long initCpuUsage = monitor.getCumulativeCpuTime();
        long initNumCalls = fakeCore.getNumCalls();
        TestResourceUsageEmulators.testEmulationBoundary((float)0.0f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)initCpuUsage, (long)initNumCalls, (String)"[no-op, 0 progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)0.24f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)initCpuUsage, (long)initNumCalls, (String)"[no-op, 24% progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)0.25f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)initCpuUsage, (long)initNumCalls, (String)"[op, 25% progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)0.8f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)410L, (long)410L, (String)"[op, 80% progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)1.0f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)targetCpuUsage, (long)targetCpuUsage, (String)"[op, 100% progress]");
        fakeProgress = new FakeProgressive();
        fakeCore.reset();
        fakeCore.setUnitUsage(unitCpuUsage);
        conf.setFloat("gridmix.emulators.resource-usage.cpu.emulation-interval", 0.4f);
        cpuPlugin.initialize(conf, metrics, (ResourceCalculatorPlugin)monitor, (Progressive)fakeProgress);
        initCpuUsage = monitor.getCumulativeCpuTime();
        initNumCalls = fakeCore.getNumCalls();
        TestResourceUsageEmulators.testEmulationBoundary((float)0.0f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)initCpuUsage, (long)initNumCalls, (String)"[no-op, 0 progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)0.39f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)initCpuUsage, (long)initNumCalls, (String)"[no-op, 39% progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)0.4f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)initCpuUsage, (long)initNumCalls, (String)"[op, 40% progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)0.9f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)700L, (long)(700 / unitCpuUsage), (String)"[op, 90% progress]");
        TestResourceUsageEmulators.testEmulationBoundary((float)1.0f, (FakeCpuUsageEmulatorCore)fakeCore, (FakeProgressive)fakeProgress, (CumulativeCpuUsageEmulatorPlugin)cpuPlugin, (long)targetCpuUsage, (long)(targetCpuUsage / (long)unitCpuUsage), (String)"[op, 100% progress]");
    }

    private static void testEmulationAccuracy(Configuration conf, FakeCpuUsageEmulatorCore fakeCore, ResourceCalculatorPlugin monitor, ResourceUsageMetrics metrics, CumulativeCpuUsageEmulatorPlugin cpuPlugin, long expectedTotalCpuUsage, long expectedTotalNumCalls) throws Exception {
        FakeProgressive fakeProgress = new FakeProgressive();
        fakeCore.reset();
        cpuPlugin.initialize(conf, metrics, monitor, (Progressive)fakeProgress);
        int numLoops = 0;
        while (fakeProgress.getProgress() < 1.0f) {
            float progress = (float)(++numLoops) / 100.0f;
            fakeProgress.setProgress(progress);
            cpuPlugin.emulate();
        }
        Assert.assertEquals((String)"Cumulative cpu usage emulator plugin failed (num calls)!", (double)expectedTotalNumCalls, (double)fakeCore.getNumCalls(), (double)0.0);
        Assert.assertEquals((String)"Cumulative cpu usage emulator plugin failed (total usage)!", (double)expectedTotalCpuUsage, (double)fakeCore.getCpuUsage(), (double)0.0);
    }

    private static void testEmulationBoundary(float progress, FakeCpuUsageEmulatorCore fakeCore, FakeProgressive fakeProgress, CumulativeCpuUsageEmulatorPlugin cpuPlugin, long expectedTotalCpuUsage, long expectedTotalNumCalls, String info) throws Exception {
        fakeProgress.setProgress(progress);
        cpuPlugin.emulate();
        Assert.assertEquals((String)("Emulation interval test for cpu usage failed " + info + "!"), (double)expectedTotalCpuUsage, (double)fakeCore.getCpuUsage(), (double)0.0);
        Assert.assertEquals((String)("Emulation interval test for num calls failed " + info + "!"), (double)expectedTotalNumCalls, (double)fakeCore.getNumCalls(), (double)0.0);
    }
}

