/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix.emulators.resourceusage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.Progressive;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.ResourceUsageEmulatorPlugin;
import org.apache.hadoop.mapred.gridmix.emulators.resourceusage.TotalHeapUsageEmulatorPlugin;
import org.apache.hadoop.mapreduce.util.ResourceCalculatorPlugin;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;

public class TotalHeapUsageEmulatorPlugin
implements ResourceUsageEmulatorPlugin {
    protected HeapUsageEmulatorCore emulatorCore;
    private Progressive progress;
    private boolean enabled = true;
    private float emulationInterval;
    private long targetHeapUsageInMB = 0L;
    public static final String HEAP_EMULATION_PROGRESS_INTERVAL = "gridmix.emulators.resource-usage.heap.emulation-interval";
    private static final float DEFAULT_EMULATION_PROGRESS_INTERVAL = 0.1f;
    private float prevEmulationProgress = 0.0f;
    public static final String MIN_HEAP_FREE_RATIO = "gridmix.emulators.resource-usage.heap.min-free-ratio";
    private float minFreeHeapRatio;
    private static final float DEFAULT_MIN_FREE_HEAP_RATIO = 0.3f;
    public static final String HEAP_LOAD_RATIO = "gridmix.emulators.resource-usage.heap.load-ratio";
    private float heapLoadRatio;
    private static final float DEFAULT_HEAP_LOAD_RATIO = 0.1f;
    public static int ONE_MB = 0x100000;

    public TotalHeapUsageEmulatorPlugin() {
        this((HeapUsageEmulatorCore)new DefaultHeapUsageEmulator());
    }

    public TotalHeapUsageEmulatorPlugin(HeapUsageEmulatorCore core) {
        this.emulatorCore = core;
    }

    protected long getTotalHeapUsageInMB() {
        return Runtime.getRuntime().totalMemory() / (long)ONE_MB;
    }

    protected long getMaxHeapUsageInMB() {
        return Runtime.getRuntime().maxMemory() / (long)ONE_MB;
    }

    public void emulate() throws IOException, InterruptedException {
        if (this.enabled) {
            float currentProgress = this.progress.getProgress();
            if (this.prevEmulationProgress < currentProgress && (currentProgress - this.prevEmulationProgress >= this.emulationInterval || currentProgress == 1.0f)) {
                long maxHeapSizeInMB = this.getMaxHeapUsageInMB();
                long committedHeapSizeInMB = this.getTotalHeapUsageInMB();
                long expectedHeapUsageInMB = Math.min(maxHeapSizeInMB, (long)((float)this.targetHeapUsageInMB * currentProgress));
                if (expectedHeapUsageInMB < maxHeapSizeInMB && committedHeapSizeInMB < expectedHeapUsageInMB) {
                    long bufferInMB = (long)(this.minFreeHeapRatio * (float)expectedHeapUsageInMB);
                    long currentDifferenceInMB = expectedHeapUsageInMB - committedHeapSizeInMB;
                    long currentIncrementLoadSizeInMB = (long)((float)currentDifferenceInMB * this.heapLoadRatio);
                    currentIncrementLoadSizeInMB = Math.max(1L, currentIncrementLoadSizeInMB);
                    while (committedHeapSizeInMB + bufferInMB < expectedHeapUsageInMB) {
                        this.emulatorCore.load(currentIncrementLoadSizeInMB);
                        committedHeapSizeInMB = this.getTotalHeapUsageInMB();
                    }
                }
                this.prevEmulationProgress = currentProgress;
            }
            this.emulatorCore.reset();
        }
    }

    public void initialize(Configuration conf, ResourceUsageMetrics metrics, ResourceCalculatorPlugin monitor, Progressive progress) {
        this.targetHeapUsageInMB = metrics.getHeapUsage() / (long)ONE_MB;
        if (this.targetHeapUsageInMB <= 0L) {
            this.enabled = false;
            return;
        }
        this.emulatorCore.initialize(monitor, this.targetHeapUsageInMB);
        this.enabled = true;
        this.progress = progress;
        this.emulationInterval = conf.getFloat(HEAP_EMULATION_PROGRESS_INTERVAL, 0.1f);
        this.minFreeHeapRatio = conf.getFloat(MIN_HEAP_FREE_RATIO, 0.3f);
        this.heapLoadRatio = conf.getFloat(HEAP_LOAD_RATIO, 0.1f);
        this.prevEmulationProgress = 0.0f;
    }
}

