/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.JobCreator;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.StatListener;
import org.apache.hadoop.mapred.gridmix.UserResolver;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.TaskAttemptInfo;
import org.apache.hadoop.tools.rumen.TaskInfo;
import org.apache.hadoop.tools.rumen.ZombieJobProducer;

abstract class JobFactory<T>
implements Gridmix.Component<Void>,
StatListener<T> {
    public static final Log LOG = LogFactory.getLog(JobFactory.class);
    protected final Path scratch;
    protected final float rateFactor;
    protected final Configuration conf;
    protected final Thread rThread;
    protected final AtomicInteger sequence;
    protected final JobSubmitter submitter;
    protected final CountDownLatch startFlag;
    protected final UserResolver userResolver;
    protected final JobCreator jobCreator;
    protected volatile IOException error = null;
    protected final JobStoryProducer jobProducer;
    protected final ReentrantLock lock = new ReentrantLock(true);
    protected int numJobsInTrace = 0;

    public JobFactory(JobSubmitter submitter, InputStream jobTrace, Path scratch, Configuration conf, CountDownLatch startFlag, UserResolver userResolver) throws IOException {
        this(submitter, (JobStoryProducer)new ZombieJobProducer(jobTrace, null), scratch, conf, startFlag, userResolver);
    }

    protected JobFactory(JobSubmitter submitter, JobStoryProducer jobProducer, Path scratch, Configuration conf, CountDownLatch startFlag, UserResolver userResolver) {
        this.sequence = new AtomicInteger(0);
        this.scratch = scratch;
        this.rateFactor = conf.getFloat("gridmix.submit.multiplier", 1.0f);
        this.jobProducer = jobProducer;
        this.conf = new Configuration(conf);
        this.submitter = submitter;
        this.startFlag = startFlag;
        this.rThread = this.createReaderThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" The submission thread name is " + this.rThread.getName()));
        }
        this.userResolver = userResolver;
        this.jobCreator = JobCreator.getPolicy(conf, JobCreator.LOADJOB);
    }

    protected abstract Thread createReaderThread();

    private JobStory getNextJobFromTrace() throws IOException {
        JobStory story = this.jobProducer.getNextJob();
        if (story != null) {
            ++this.numJobsInTrace;
        }
        return story;
    }

    protected JobStory getNextJobFiltered() throws IOException {
        JobStory job = this.getNextJobFromTrace();
        while (job != null && (job.getOutcome() != Pre21JobHistoryConstants.Values.SUCCESS || job.getSubmissionTime() < 0L)) {
            if (LOG.isDebugEnabled()) {
                String reason = null;
                if (job.getOutcome() != Pre21JobHistoryConstants.Values.SUCCESS) {
                    reason = "STATE (" + job.getOutcome().name() + ") ";
                }
                if (job.getSubmissionTime() < 0L) {
                    reason = reason + "SUBMISSION-TIME (" + job.getSubmissionTime() + ")";
                }
                LOG.debug((Object)("Ignoring job " + job.getJobID() + " from the input trace." + " Reason: " + reason == null ? "N/A" : reason));
            }
            job = this.getNextJobFromTrace();
        }
        return null == job ? null : new FilterJobStory(job){

            @Override
            public TaskInfo getTaskInfo(TaskType taskType, int taskNumber) {
                return new MinTaskInfo(this.job.getTaskInfo(taskType, taskNumber));
            }
        };
    }

    public IOException error() {
        return this.error;
    }

    @Override
    public void add(Void ignored) {
        throw new UnsupportedOperationException(this.getClass().getName() + " is at the start of the pipeline and accepts no events");
    }

    @Override
    public void start() {
        this.rThread.start();
    }

    @Override
    public void join(long millis) throws InterruptedException {
        this.rThread.join(millis);
    }

    @Override
    public void shutdown() {
        this.rThread.interrupt();
    }

    @Override
    public void abort() {
        this.rThread.interrupt();
    }

    protected static class FilterJobStory
    implements JobStory {
        protected final JobStory job;

        public FilterJobStory(JobStory job) {
            this.job = job;
        }

        public JobConf getJobConf() {
            return this.job.getJobConf();
        }

        public String getName() {
            return this.job.getName();
        }

        public JobID getJobID() {
            return this.job.getJobID();
        }

        public String getUser() {
            return this.job.getUser();
        }

        public long getSubmissionTime() {
            return this.job.getSubmissionTime();
        }

        public InputSplit[] getInputSplits() {
            return this.job.getInputSplits();
        }

        public int getNumberMaps() {
            return this.job.getNumberMaps();
        }

        public int getNumberReduces() {
            return this.job.getNumberReduces();
        }

        public TaskInfo getTaskInfo(TaskType taskType, int taskNumber) {
            return this.job.getTaskInfo(taskType, taskNumber);
        }

        public TaskAttemptInfo getTaskAttemptInfo(TaskType taskType, int taskNumber, int taskAttemptNumber) {
            return this.job.getTaskAttemptInfo(taskType, taskNumber, taskAttemptNumber);
        }

        public TaskAttemptInfo getMapTaskAttemptInfoAdjusted(int taskNumber, int taskAttemptNumber, int locality) {
            return this.job.getMapTaskAttemptInfoAdjusted(taskNumber, taskAttemptNumber, locality);
        }

        public Pre21JobHistoryConstants.Values getOutcome() {
            return this.job.getOutcome();
        }

        public String getQueueName() {
            return this.job.getQueueName();
        }
    }

    static class MinTaskInfo
    extends TaskInfo {
        public MinTaskInfo(TaskInfo info) {
            super(info.getInputBytes(), info.getInputRecords(), info.getOutputBytes(), info.getOutputRecords(), info.getTaskMemory(), info.getResourceUsageMetrics());
        }

        public long getInputBytes() {
            return Math.max(0L, super.getInputBytes());
        }

        public int getInputRecords() {
            return Math.max(0, super.getInputRecords());
        }

        public long getOutputBytes() {
            return Math.max(0L, super.getOutputBytes());
        }

        public int getOutputRecords() {
            return Math.max(0, super.getOutputRecords());
        }

        public long getTaskMemory() {
            return Math.max(0L, super.getTaskMemory());
        }
    }
}

