/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.ClusterSummarizer;
import org.apache.hadoop.mapred.gridmix.ExecutionSummarizer;
import org.apache.hadoop.mapred.gridmix.GenerateData;
import org.apache.hadoop.mapred.gridmix.JobFactory;
import org.apache.hadoop.mapred.gridmix.UserResolver;

class Summarizer {
    private ExecutionSummarizer executionSummarizer;
    private ClusterSummarizer clusterSummarizer;
    protected static final String NA = "N/A";

    Summarizer() {
        this(new String[]{NA});
    }

    Summarizer(String[] args) {
        this.executionSummarizer = new ExecutionSummarizer(args);
        this.clusterSummarizer = new ClusterSummarizer();
    }

    ExecutionSummarizer getExecutionSummarizer() {
        return this.executionSummarizer;
    }

    ClusterSummarizer getClusterSummarizer() {
        return this.clusterSummarizer;
    }

    void start(Configuration conf) {
        this.executionSummarizer.start(conf);
        this.clusterSummarizer.start(conf);
    }

    void finalize(JobFactory factory, String path, long size, UserResolver resolver, GenerateData.DataStatistics stats, Configuration conf) throws IOException {
        this.executionSummarizer.finalize(factory, path, size, resolver, stats, conf);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.executionSummarizer.toString());
        builder.append(this.clusterSummarizer.toString());
        return builder.toString();
    }
}

